/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.tasks.TaskRegistry;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class TaskRegistryTest {
    @Inject
    AtlasGraph graph;
    @Inject
    TaskRegistry registry;

    @Test
    public void basic() throws AtlasException, AtlasBaseException {
        AtlasTask task = new AtlasTask("abcd", "test", Collections.singletonMap("p1", "p1"));
        Assert.assertNull((Object)this.registry.getById(task.getGuid()));
        AtlasTask taskFromVertex = this.registry.save(task);
        AtlasVertex taskVertex = this.registry.getVertex(task.getGuid());
        Assert.assertEquals((String)taskFromVertex.getGuid(), (String)task.getGuid());
        Assert.assertEquals((String)taskFromVertex.getType(), (String)task.getType());
        Assert.assertEquals((int)taskFromVertex.getAttemptCount(), (int)task.getAttemptCount());
        Assert.assertEquals((Map)taskFromVertex.getParameters(), (Map)task.getParameters());
        Assert.assertEquals((String)taskFromVertex.getCreatedBy(), (String)task.getCreatedBy());
        taskFromVertex.incrementAttemptCount();
        taskFromVertex.setStatusPending();
        this.registry.updateStatus(taskVertex, taskFromVertex);
        this.registry.commit();
        taskFromVertex = this.registry.getById(task.getGuid());
        Assert.assertNotNull((Object)taskVertex);
        Assert.assertEquals((Object)taskFromVertex.getStatus(), (Object)AtlasTask.Status.PENDING);
        Assert.assertEquals((int)taskFromVertex.getAttemptCount(), (int)1);
        this.registry.deleteByGuid(taskFromVertex.getGuid());
        try {
            AtlasTask t = this.registry.getById(taskFromVertex.getGuid());
            Assert.assertNull((Object)t);
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)true, (String)"Indicates vertex is deleted!");
        }
    }

    @Test
    public void pendingTasks() throws AtlasBaseException {
        int MAX_TASKS = 3;
        String TASK_TYPE_FORMAT = "abcd:%d";
        for (int i = 0; i < 3; ++i) {
            AtlasTask task = new AtlasTask(String.format("abcd:%d", i), "test", Collections.singletonMap("p1", "p1"));
            this.registry.save(task);
        }
        List pendingTasks = this.registry.getPendingTasks();
        Assert.assertEquals((int)pendingTasks.size(), (int)3);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((String)((AtlasTask)pendingTasks.get(i)).getType(), (String)String.format("abcd:%d", i));
            this.registry.deleteByGuid(((AtlasTask)pendingTasks.get(i)).getGuid());
        }
        this.graph.commit();
        pendingTasks = this.registry.getPendingTasks();
        Assert.assertEquals((int)pendingTasks.size(), (int)0);
    }
}

