/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tasks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.AtlasException;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.tasks.BaseTaskFixture;
import org.apache.atlas.tasks.TaskFactory;
import org.apache.atlas.tasks.TaskManagement;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class TaskManagementTest
extends BaseTaskFixture {
    @Test
    public void factoryReturningNullIsHandled() throws AtlasException {
        TaskManagement taskManagement = new TaskManagement(null, this.taskRegistry, (TaskFactory)new NullFactory());
        taskManagement.start();
    }

    @Test
    public void taskSucceedsTaskVertexRemoved() throws AtlasException, InterruptedException, AtlasBaseException {
        BaseTaskFixture.SpyingFactory spyingFactory = new BaseTaskFixture.SpyingFactory();
        TaskManagement taskManagement = new TaskManagement(null, this.taskRegistry, (TaskFactory)spyingFactory);
        taskManagement.start();
        AtlasTask spyTask = this.createTask(taskManagement, "add");
        AtlasTask spyTaskError = this.createTask(taskManagement, "errorThrowingTask");
        this.graph.commit();
        taskManagement.addAll(Arrays.asList(spyTask, spyTaskError));
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertTrue((boolean)spyingFactory.getAddTask().taskPerformed());
        Assert.assertTrue((boolean)spyingFactory.getErrorTask().taskPerformed());
        AtlasTask task = taskManagement.getByGuid(spyTask.getGuid());
        Assert.assertNull((Object)task);
    }

    @Test
    public void severalTaskAdds() throws AtlasException, InterruptedException {
        int i;
        int MAX_THREADS = 5;
        TaskManagement taskManagement = new TaskManagement(null, this.taskRegistry);
        taskManagement.start();
        Thread[] threads = new Thread[MAX_THREADS];
        for (i = 0; i < MAX_THREADS; ++i) {
            threads[i] = new Thread(() -> {
                try {
                    AtlasTask spyAdd = taskManagement.createTask("add", "test", Collections.emptyMap());
                    AtlasTask spyErr = taskManagement.createTask("errorThrowingTask", "test", Collections.emptyMap());
                    taskManagement.addAll(Collections.singletonList(spyAdd));
                    taskManagement.addAll(Collections.singletonList(spyErr));
                    Thread.sleep(10000L);
                    for (int j = 0; j <= 3; ++j) {
                        taskManagement.addAll(Collections.singletonList(spyErr));
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        for (i = 0; i < MAX_THREADS; ++i) {
            threads[i].start();
        }
        for (i = 0; i < MAX_THREADS; ++i) {
            threads[i].join();
        }
    }

    private static class NullFactory
    implements TaskFactory {
        private NullFactory() {
        }

        public AbstractTask create(AtlasTask atlasTask) {
            return null;
        }

        public List<String> getSupportedTypes() {
            return null;
        }
    }
}

