/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.tasks.BaseTaskFixture;
import org.apache.atlas.tasks.TaskExecutor;
import org.apache.atlas.tasks.TaskFactory;
import org.apache.atlas.tasks.TaskManagement;
import org.apache.atlas.tasks.TaskRegistry;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class TaskExecutorTest
extends BaseTaskFixture {
    @Inject
    private AtlasGraph graph;
    @Inject
    private TaskRegistry taskRegistry;
    @Inject
    private TaskManagement taskManagement;

    @Test
    public void noTasksExecuted() {
        BaseTaskFixture.SpyingFactory spyingFactory = new BaseTaskFixture.SpyingFactory();
        HashMap taskFactoryMap = new HashMap();
        TaskManagement.createTaskTypeFactoryMap(new HashMap(), (TaskFactory)spyingFactory);
        TaskManagement.Statistics statistics = new TaskManagement.Statistics();
        new TaskExecutor(this.taskRegistry, taskFactoryMap, statistics);
        Assert.assertEquals((int)statistics.getTotal(), (int)0);
    }

    @Test
    public void tasksNotPersistedIsNotExecuted() throws InterruptedException {
        BaseTaskFixture.SpyingFactory spyingFactory = new BaseTaskFixture.SpyingFactory();
        HashMap taskFactoryMap = new HashMap();
        TaskManagement.createTaskTypeFactoryMap(taskFactoryMap, (TaskFactory)spyingFactory);
        TaskManagement.Statistics statistics = new TaskManagement.Statistics();
        TaskExecutor taskExecutor = new TaskExecutor(this.taskRegistry, taskFactoryMap, statistics);
        taskExecutor.addAll(Collections.singletonList(new AtlasTask("add", "test", Collections.emptyMap())));
        taskExecutor.waitUntilDone();
        Assert.assertEquals((int)statistics.getTotal(), (int)0);
    }

    @Test
    public void persistedIsExecuted() throws AtlasBaseException, InterruptedException {
        BaseTaskFixture.SpyingFactory spyingFactory = new BaseTaskFixture.SpyingFactory();
        HashMap taskFactoryMap = new HashMap();
        TaskManagement.createTaskTypeFactoryMap(taskFactoryMap, (TaskFactory)spyingFactory);
        final AtlasTask addTask = this.taskManagement.createTask("add", "test", Collections.emptyMap());
        final AtlasTask errorThrowingTask = this.taskManagement.createTask("errorThrowingTask", "test", Collections.emptyMap());
        TaskManagement.Statistics statistics = new TaskManagement.Statistics();
        ArrayList<AtlasTask> tasks = new ArrayList<AtlasTask>(){
            {
                this.add(addTask);
                this.add(errorThrowingTask);
            }
        };
        this.graph.commit();
        TaskExecutor taskExecutor = new TaskExecutor(this.taskRegistry, taskFactoryMap, statistics);
        taskExecutor.addAll((List)tasks);
        taskExecutor.waitUntilDone();
        Assert.assertEquals((int)statistics.getTotal(), (int)2);
        Assert.assertEquals((int)statistics.getTotalSuccess(), (int)1);
        Assert.assertEquals((int)statistics.getTotalError(), (int)1);
        Assert.assertNotNull((Object)((Object)spyingFactory.getAddTask()));
        Assert.assertNotNull((Object)((Object)spyingFactory.getErrorTask()));
        Assert.assertTrue((boolean)spyingFactory.getAddTask().taskPerformed());
        Assert.assertTrue((boolean)spyingFactory.getErrorTask().taskPerformed());
        this.assertTaskUntilFail(errorThrowingTask, taskExecutor);
    }

    private void assertTaskUntilFail(AtlasTask errorThrowingTask, TaskExecutor taskExecutor) throws AtlasBaseException, InterruptedException {
        AtlasTask errorTaskFromDB = this.taskManagement.getByGuid(errorThrowingTask.getGuid());
        Assert.assertNotNull((Object)errorTaskFromDB);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)errorTaskFromDB.getErrorMessage()));
        Assert.assertEquals((int)errorTaskFromDB.getAttemptCount(), (int)1);
        Assert.assertEquals((Object)errorTaskFromDB.getStatus(), (Object)AtlasTask.Status.PENDING);
        for (int i = errorTaskFromDB.getAttemptCount(); i <= 3; ++i) {
            taskExecutor.addAll(Collections.singletonList(errorThrowingTask));
        }
        taskExecutor.waitUntilDone();
        this.graph.commit();
        Assert.assertEquals((Object)errorThrowingTask.getStatus(), (Object)AtlasTask.Status.FAILED);
    }
}

