/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.tasks.AbstractTask;
import org.apache.atlas.tasks.TaskFactory;
import org.apache.atlas.tasks.TaskManagement;
import org.apache.atlas.tasks.TaskRegistry;

public class BaseTaskFixture {
    protected static final String SPYING_TASK_ADD = "add";
    protected static final String SPYING_TASK_ERROR_THROWING = "errorThrowingTask";
    @Inject
    protected AtlasGraph graph;
    @Inject
    protected TaskRegistry taskRegistry;

    protected AtlasTask createTask(TaskManagement taskManagement, String type) {
        return taskManagement.createTask(type, "testUser", Collections.singletonMap("params", "params"));
    }

    static class SpyingFactory
    implements TaskFactory {
        private SpyConcreteTask addTask;
        private SpyErrorThrowingTask errorTask;

        SpyingFactory() {
        }

        public AbstractTask create(AtlasTask atlasTask) {
            switch (atlasTask.getType()) {
                case "add": {
                    this.addTask = new SpyConcreteTask(atlasTask);
                    return this.addTask;
                }
                case "errorThrowingTask": {
                    this.errorTask = new SpyErrorThrowingTask(atlasTask);
                    return this.errorTask;
                }
            }
            return null;
        }

        public List<String> getSupportedTypes() {
            return new ArrayList<String>(){
                {
                    this.add(BaseTaskFixture.SPYING_TASK_ADD);
                    this.add(BaseTaskFixture.SPYING_TASK_ERROR_THROWING);
                }
            };
        }

        public SpyConcreteTask getAddTask() {
            return this.addTask;
        }

        public SpyErrorThrowingTask getErrorTask() {
            return this.errorTask;
        }
    }

    static class SpyErrorThrowingTask
    extends AbstractTask {
        private boolean taskPerformed;

        public SpyErrorThrowingTask(AtlasTask atlasTask) {
            super(atlasTask);
        }

        public AtlasTask.Status perform() {
            this.taskPerformed = true;
            throw new NullPointerException("SpyErrorThrowingTask: NullPointerException Encountered!");
        }

        public boolean taskPerformed() {
            return this.taskPerformed;
        }
    }

    static class SpyConcreteTask
    extends AbstractTask {
        private boolean taskPerformed;

        public SpyConcreteTask(AtlasTask atlasTask) {
            super(atlasTask);
        }

        public AtlasTask.Status perform() {
            this.taskPerformed = true;
            return AtlasTask.Status.COMPLETE;
        }

        public boolean taskPerformed() {
            return this.taskPerformed;
        }
    }
}

