/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.userprofile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.profile.AtlasUserProfile;
import org.apache.atlas.model.profile.AtlasUserSavedSearch;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.userprofile.UserProfileService;
import org.apache.atlas.repository.util.FilterUtil;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class UserProfileServiceTest
extends AtlasTestBase {
    private UserProfileService userProfileService;
    private AtlasTypeDefStore typeDefStore;
    private static final int NUM_USERS = 2;
    private static final int NUM_SEARCHES = 4;

    @Inject
    public void UserProfileServiceTest(AtlasTypeRegistry typeRegistry, AtlasTypeDefStore typeDefStore, UserProfileService userProfileService) throws IOException, AtlasBaseException {
        this.typeDefStore = typeDefStore;
        this.userProfileService = userProfileService;
        TestLoadModelUtils.loadModelFromJson("0010-base_model.json", typeDefStore, typeRegistry);
    }

    @Override
    @BeforeClass
    public void initialize() throws Exception {
        super.initialize();
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @Test
    public void filterInternalType() throws AtlasBaseException {
        SearchFilter searchFilter = new SearchFilter();
        FilterUtil.addParamsToHideInternalType((SearchFilter)searchFilter);
        AtlasTypesDef filteredTypeDefs = this.typeDefStore.searchTypesDef(searchFilter);
        Assert.assertNotNull((Object)filteredTypeDefs);
        Optional<AtlasEntityDef> anyInternal = filteredTypeDefs.getEntityDefs().stream().filter(e -> e.getSuperTypes().contains("__internal")).findAny();
        Assert.assertFalse((boolean)anyInternal.isPresent());
    }

    @Test(dependsOnMethods={"filterInternalType"})
    public void createsNewProfile() throws AtlasBaseException {
        for (int i = 0; i < 2; ++i) {
            AtlasUserProfile expected = UserProfileServiceTest.getAtlasUserProfile(i);
            AtlasUserProfile actual = this.userProfileService.saveUserProfile(expected);
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((String)expected.getName(), (String)actual.getName());
            Assert.assertEquals((String)expected.getFullName(), (String)actual.getFullName());
            Assert.assertNotNull((Object)actual.getGuid());
        }
    }

    @Test(dependsOnMethods={"createsNewProfile"})
    public void saveSearchesForUser() throws AtlasBaseException {
        int i;
        String userName = UserProfileServiceTest.getIndexBasedUserName(0);
        SearchParameters searchParameters = this.getActualSearchParameters();
        for (i = 0; i < 4; ++i) {
            this.userProfileService.addSavedSearch(this.getDefaultSavedSearch(userName, UserProfileServiceTest.getIndexBasedQueryName(i), searchParameters));
        }
        for (i = 0; i < 4; ++i) {
            AtlasUserSavedSearch savedSearch = this.userProfileService.getSavedSearch(userName, UserProfileServiceTest.getIndexBasedQueryName(i));
            Assert.assertEquals((String)savedSearch.getName(), (String)UserProfileServiceTest.getIndexBasedQueryName(i));
            Assert.assertEquals((Object)savedSearch.getSearchParameters(), (Object)searchParameters);
        }
    }

    @Test(dependsOnMethods={"saveSearchesForUser"}, expectedExceptions={AtlasBaseException.class})
    public void attemptToAddExistingSearch() throws AtlasBaseException {
        String userName = UserProfileServiceTest.getIndexBasedUserName(0);
        SearchParameters expectedSearchParameter = this.getActualSearchParameters();
        for (int j = 0; j < 4; ++j) {
            String queryName = UserProfileServiceTest.getIndexBasedQueryName(j);
            AtlasUserSavedSearch expected = this.getDefaultSavedSearch(userName, queryName, expectedSearchParameter);
            AtlasUserSavedSearch actual = this.userProfileService.addSavedSearch(expected);
            Assert.assertNotNull((Object)actual);
            Assert.assertNotNull((Object)actual.getGuid());
            Assert.assertEquals((String)actual.getOwnerName(), (String)expected.getOwnerName());
            Assert.assertEquals((String)actual.getName(), (String)expected.getName());
            Assert.assertEquals((Object)actual.getSearchType(), (Object)expected.getSearchType());
            Assert.assertEquals((Object)actual.getSearchParameters(), (Object)expected.getSearchParameters());
        }
    }

    @Test(dependsOnMethods={"attemptToAddExistingSearch"})
    public void verifySavedSearchesForUser() throws AtlasBaseException {
        String userName = UserProfileServiceTest.getIndexBasedUserName(0);
        List searches = this.userProfileService.getSavedSearches(userName);
        List<String> names = this.getIndexBasedQueryNamesList();
        for (int i = 0; i < names.size(); ++i) {
            Assert.assertTrue((boolean)names.contains(((AtlasUserSavedSearch)searches.get(i)).getName()), (String)(((AtlasUserSavedSearch)searches.get(i)).getName() + " failed!"));
        }
    }

    @Test(dependsOnMethods={"verifySavedSearchesForUser"})
    public void verifyQueryConversionFromJSON() throws AtlasBaseException {
        List list = this.userProfileService.getSavedSearches("first-0");
        for (int i = 0; i < 4; ++i) {
            SearchParameters sp = ((AtlasUserSavedSearch)list.get(i)).getSearchParameters();
            String json = AtlasType.toJson((Object)sp);
            Assert.assertEquals((String)AtlasType.toJson((Object)this.getActualSearchParameters()).replace("\n", "").replace(" ", ""), (String)json);
        }
    }

    @Test(dependsOnMethods={"verifyQueryConversionFromJSON"})
    public void addAdditionalSearchesForUser() throws AtlasBaseException {
        SearchParameters expectedSearchParameter = this.getActualSearchParameters();
        for (int i = 0; i < 2; ++i) {
            String userName = UserProfileServiceTest.getIndexBasedUserName(i);
            for (int j = 0; j < 6; ++j) {
                String queryName = UserProfileServiceTest.getIndexBasedQueryName(4 + j);
                AtlasUserSavedSearch actual = this.userProfileService.addSavedSearch(this.getDefaultSavedSearch(userName, queryName, expectedSearchParameter));
                Assert.assertNotNull((Object)actual);
                AtlasUserSavedSearch savedSearch = this.userProfileService.getSavedSearch(userName, queryName);
                Assert.assertNotNull((Object)savedSearch);
                Assert.assertEquals((Object)savedSearch.getSearchParameters(), (Object)expectedSearchParameter);
            }
        }
    }

    @Test(dependsOnMethods={"addAdditionalSearchesForUser"})
    public void updateSearch() throws AtlasBaseException {
        String userName = UserProfileServiceTest.getIndexBasedUserName(0);
        String queryName = UserProfileServiceTest.getIndexBasedQueryName(0);
        AtlasUserSavedSearch expected = this.userProfileService.getSavedSearch(userName, queryName);
        Assert.assertNotNull((Object)expected);
        SearchParameters sp = expected.getSearchParameters();
        sp.setClassification("new-classification");
        AtlasUserSavedSearch actual = this.userProfileService.updateSavedSearch(expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertNotNull((Object)actual.getSearchParameters());
        Assert.assertEquals((String)actual.getSearchParameters().getClassification(), (String)expected.getSearchParameters().getClassification());
    }

    @Test(dependsOnMethods={"updateSearch"})
    public void deleteUsingGuid() throws AtlasBaseException {
        String userName = UserProfileServiceTest.getIndexBasedUserName(0);
        String queryName = UserProfileServiceTest.getIndexBasedQueryName(1);
        AtlasUserSavedSearch expected = this.userProfileService.getSavedSearch(userName, queryName);
        Assert.assertNotNull((Object)expected);
        this.userProfileService.deleteSavedSearch(expected.getGuid());
        try {
            this.userProfileService.getSavedSearch(userName, queryName);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((String)ex.getAtlasErrorCode().name(), (String)AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND.name());
        }
    }

    @Test(dependsOnMethods={"deleteUsingGuid"})
    public void deleteSavedQuery() throws AtlasBaseException {
        String userName = UserProfileServiceTest.getIndexBasedUserName(0);
        AtlasUserProfile expected = this.userProfileService.getUserProfile(userName);
        Assert.assertNotNull((Object)expected);
        int searchCount = expected.getSavedSearches().size();
        String queryNameToBeDeleted = UserProfileServiceTest.getIndexBasedQueryName(2);
        this.userProfileService.deleteSearchBySearchName(userName, queryNameToBeDeleted);
        List savedSearchList = this.userProfileService.getSavedSearches(userName);
        Assert.assertEquals((int)savedSearchList.size(), (int)(searchCount - 1));
    }

    @Test(dependsOnMethods={"deleteSavedQuery"})
    void deleteUser() throws AtlasBaseException {
        String userName = UserProfileServiceTest.getIndexBasedUserName(0);
        AtlasUserProfile userProfile = this.userProfileService.getUserProfile(userName);
        if (userProfile.getSavedSearches() != null) {
            for (AtlasUserSavedSearch savedSearch : userProfile.getSavedSearches()) {
                this.userProfileService.deleteSavedSearch(savedSearch.getGuid());
            }
        }
        this.userProfileService.deleteUserProfile(userName);
        try {
            this.userProfileService.getUserProfile(userName);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((String)ex.getAtlasErrorCode().name(), (String)AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND.name());
        }
    }

    private static AtlasUserProfile getAtlasUserProfile(Integer s) {
        return new AtlasUserProfile(UserProfileServiceTest.getIndexBasedUserName(s), String.format("first-%s last-%s", s, s));
    }

    private static String getIndexBasedUserName(Integer i) {
        return String.format("first-%s", i.toString());
    }

    private static String getIndexBasedQueryName(Integer i) {
        return String.format("testQuery-%s", i.toString());
    }

    private SearchParameters getActualSearchParameters() {
        SearchParameters sp = new SearchParameters();
        sp.setClassification("test-classification");
        sp.setQuery("g.v().has('__guid').__guid.toList()");
        sp.setLimit(10);
        sp.setTypeName("some-type");
        return sp;
    }

    private AtlasUserSavedSearch getDefaultSavedSearch(String userName, String queryName, SearchParameters expectedSearchParam) {
        return new AtlasUserSavedSearch(userName, queryName, AtlasUserSavedSearch.SavedSearchType.BASIC, expectedSearchParam);
    }

    private List<String> getIndexBasedQueryNamesList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            list.add(UserProfileServiceTest.getIndexBasedQueryName(i));
        }
        return list;
    }
}

