/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.tagpropagation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.discovery.AtlasLineageService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.commons.collections.CollectionUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ClassificationPropagationTest
extends AtlasTestBase {
    public static final String HDFS_PATH_EMPLOYEES = "HDFS_PATH_EMPLOYEES";
    public static final String EMPLOYEES1_TABLE = "EMPLOYEES1_TABLE";
    public static final String EMPLOYEES2_TABLE = "EMPLOYEES2_TABLE";
    public static final String EMPLOYEES_UNION_TABLE = "EMPLOYEES_UNION_TABLE";
    public static final String EMPLOYEES1_PROCESS = "EMPLOYEES1_PROCESS";
    public static final String EMPLOYEES2_PROCESS = "EMPLOYEES2_PROCESS";
    public static final String EMPLOYEES_UNION_PROCESS = "EMPLOYEES_UNION_PROCESS";
    public static final String EMPLOYEES_TABLE = "EMPLOYEES_TABLE";
    public static final String US_EMPLOYEES_TABLE = "US_EMPLOYEES2_TABLE";
    public static final String EMPLOYEES_PROCESS = "EMPLOYEES_PROCESS";
    public static final String ORDERS_TABLE = "ORDERS_TABLE";
    public static final String US_ORDERS_TABLE = "US_ORDERS_TABLE";
    public static final String ORDERS_PROCESS = "ORDERS_PROCESS";
    public static final String IMPORT_FILE = "tag-propagation-data.zip";
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasEntityStore entityStore;
    @Inject
    private AtlasRelationshipStore relationshipStore;
    @Inject
    private ImportService importService;
    @Inject
    private AtlasLineageService lineageService;
    private Map<String, String> entitiesMap;
    private AtlasLineageInfo lineageInfo;

    @BeforeClass
    public void setup() throws Exception {
        RequestContext.clear();
        super.initialize();
        this.loadModelFilesAndImportTestData();
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @Test
    public void addClassification_PropagateFalse() throws AtlasBaseException {
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasClassification tag2 = new AtlasClassification("tag2");
        tag2.setPropagate(Boolean.valueOf(false));
        tag2.setEntityGuid(hdfs_employees.getGuid());
        this.addClassification(hdfs_employees, tag2);
        List<String> propagatedToEntities = Arrays.asList(EMPLOYEES1_PROCESS, EMPLOYEES2_PROCESS, EMPLOYEES1_TABLE, EMPLOYEES2_TABLE, EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        this.assertClassificationNotExistInEntities(propagatedToEntities, tag2);
    }

    @Test(dependsOnMethods={"addClassification_PropagateFalse"})
    public void updateClassification_PropagateFalseToTrue() throws AtlasBaseException {
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasClassification tag2 = new AtlasClassification("tag2");
        tag2.setEntityGuid(hdfs_employees.getGuid());
        tag2 = this.getClassification(hdfs_employees, tag2);
        tag2.setPropagate(Boolean.valueOf(true));
        this.updateClassifications(hdfs_employees, tag2);
        List<String> propagatedToEntities = Arrays.asList(EMPLOYEES1_PROCESS, EMPLOYEES2_PROCESS, EMPLOYEES1_TABLE, EMPLOYEES2_TABLE, EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        this.assertClassificationExistInEntities(propagatedToEntities, tag2);
        this.deleteClassification(hdfs_employees, tag2);
    }

    @Test(dependsOnMethods={"updateClassification_PropagateFalseToTrue"})
    public void addClassification_PropagateTrue() throws AtlasBaseException {
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasClassification tag1 = new AtlasClassification("tag1");
        tag1.setPropagate(Boolean.valueOf(true));
        tag1.setEntityGuid(hdfs_employees.getGuid());
        this.addClassification(hdfs_employees, tag1);
        List<String> propagatedToEntities = Arrays.asList(EMPLOYEES1_PROCESS, EMPLOYEES2_PROCESS, EMPLOYEES1_TABLE, EMPLOYEES2_TABLE, EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        this.assertClassificationExistInEntities(propagatedToEntities, tag1);
    }

    @Test(dependsOnMethods={"addClassification_PropagateTrue"})
    public void updateClassification_PropagateTrueToFalse() throws AtlasBaseException {
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasClassification tag1 = new AtlasClassification("tag1");
        tag1.setEntityGuid(hdfs_employees.getGuid());
        List<String> propagatedToEntities = Arrays.asList(EMPLOYEES1_PROCESS, EMPLOYEES2_PROCESS, EMPLOYEES1_TABLE, EMPLOYEES2_TABLE, EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        tag1 = this.getClassification(hdfs_employees, tag1);
        tag1.setPropagate(Boolean.valueOf(false));
        this.updateClassifications(hdfs_employees, tag1);
        this.assertClassificationNotExistInEntities(propagatedToEntities, tag1);
    }

    @Test(dependsOnMethods={"updateClassification_PropagateTrueToFalse"})
    public void deleteClassification_PropagateTrue() throws AtlasBaseException {
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasClassification tag1 = new AtlasClassification("tag1");
        tag1.setPropagate(Boolean.valueOf(true));
        tag1.setEntityGuid(hdfs_employees.getGuid());
        this.deleteClassification(hdfs_employees, tag1);
        List<String> propagatedToEntities = Arrays.asList(EMPLOYEES1_PROCESS, EMPLOYEES2_PROCESS, EMPLOYEES1_TABLE, EMPLOYEES2_TABLE, EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        this.assertClassificationNotExistInEntities(propagatedToEntities, tag1);
    }

    @Test(dependsOnMethods={"deleteClassification_PropagateTrue"})
    public void propagateSameTagFromDifferentEntities() throws AtlasBaseException {
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasClassification tag1 = new AtlasClassification("tag1");
        tag1.setPropagate(Boolean.valueOf(true));
        tag1.setEntityGuid(hdfs_employees.getGuid());
        this.addClassification(hdfs_employees, tag1);
        AtlasEntity employees2_table = this.getEntity(EMPLOYEES2_TABLE);
        tag1 = new AtlasClassification("tag1");
        tag1.setPropagate(Boolean.valueOf(true));
        tag1.setEntityGuid(employees2_table.getGuid());
        this.addClassification(employees2_table, tag1);
        AtlasEntity employees_union_table = this.getEntity(EMPLOYEES_UNION_TABLE);
        List classifications = employees_union_table.getClassifications();
        Assert.assertNotNull((Object)classifications);
        Assert.assertEquals((int)classifications.size(), (int)2);
        Assert.assertEquals((String)((AtlasClassification)classifications.get(0)).getTypeName(), (String)tag1.getTypeName());
        Assert.assertEquals((String)((AtlasClassification)classifications.get(1)).getTypeName(), (String)tag1.getTypeName());
        if (((AtlasClassification)classifications.get(0)).getEntityGuid().equals(hdfs_employees.getGuid())) {
            Assert.assertEquals((String)((AtlasClassification)classifications.get(1)).getEntityGuid(), (String)employees2_table.getGuid());
        }
        if (((AtlasClassification)classifications.get(0)).getEntityGuid().equals(employees2_table.getGuid())) {
            Assert.assertEquals((String)((AtlasClassification)classifications.get(1)).getEntityGuid(), (String)hdfs_employees.getGuid());
        }
        this.deleteClassification(hdfs_employees, tag1);
        this.deleteClassification(employees2_table, tag1);
    }

    @Test(dependsOnMethods={"propagateSameTagFromDifferentEntities"})
    public void updatePropagateTagsValue() throws AtlasBaseException {
        AtlasEntity hdfs_employees = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasEntity employees2_table = this.getEntity(EMPLOYEES2_TABLE);
        AtlasEntity employees_union_process = this.getEntity(EMPLOYEES_UNION_PROCESS);
        AtlasEntity employees_union_table = this.getEntity(EMPLOYEES_UNION_TABLE);
        AtlasClassification tag1 = new AtlasClassification("tag1");
        tag1.setPropagate(Boolean.valueOf(true));
        tag1.setEntityGuid(hdfs_employees.getGuid());
        AtlasClassification tag2 = new AtlasClassification("tag2");
        tag2.setPropagate(Boolean.valueOf(true));
        tag2.setEntityGuid(employees2_table.getGuid());
        AtlasClassification tag3 = new AtlasClassification("tag3");
        tag3.setPropagate(Boolean.valueOf(true));
        tag3.setEntityGuid(employees_union_process.getGuid());
        AtlasClassification tag4 = new AtlasClassification("tag4");
        tag4.setPropagate(Boolean.valueOf(true));
        tag4.setEntityGuid(employees_union_table.getGuid());
        this.addClassification(hdfs_employees, tag1);
        this.addClassification(employees2_table, tag2);
        this.addClassification(employees_union_process, tag3);
        this.addClassification(employees_union_table, tag4);
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, tag1);
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, tag2);
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, tag3);
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, tag4);
        AtlasRelationship employees2_process_relationship = this.getRelationship(EMPLOYEES2_TABLE, EMPLOYEES_UNION_PROCESS);
        Assert.assertEquals((Object)employees2_process_relationship.getPropagateTags(), (Object)AtlasRelationshipDef.PropagateTags.TWO_TO_ONE);
        employees2_process_relationship.setPropagateTags(AtlasRelationshipDef.PropagateTags.NONE);
        this.relationshipStore.update(employees2_process_relationship);
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, tag1);
        this.assertClassificationNotExistInEntity(EMPLOYEES_UNION_TABLE, tag2);
        employees2_process_relationship = this.getRelationship(EMPLOYEES2_TABLE, EMPLOYEES_UNION_PROCESS);
        Assert.assertEquals((Object)employees2_process_relationship.getPropagateTags(), (Object)AtlasRelationshipDef.PropagateTags.NONE);
        employees2_process_relationship.setPropagateTags(AtlasRelationshipDef.PropagateTags.TWO_TO_ONE);
        this.relationshipStore.update(employees2_process_relationship);
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, tag2);
        AtlasRelationship process3_employee_union_relationship = this.getRelationship(EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        Assert.assertEquals((Object)process3_employee_union_relationship.getPropagateTags(), (Object)AtlasRelationshipDef.PropagateTags.ONE_TO_TWO);
        process3_employee_union_relationship.setPropagateTags(AtlasRelationshipDef.PropagateTags.BOTH);
        try {
            this.relationshipStore.update(process3_employee_union_relationship);
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((Object)ex.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_PROPAGATION_TYPE);
        }
        this.deleteClassification(hdfs_employees, tag1);
        this.deleteClassification(employees2_table, tag2);
        this.deleteClassification(employees_union_process, tag3);
        this.deleteClassification(employees_union_table, tag4);
    }

    @Test(dependsOnMethods={"updatePropagateTagsValue"})
    public void addBlockedPropagatedClassifications() throws AtlasBaseException {
        AtlasEntity hdfs_path = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasEntity employees1 = this.getEntity(EMPLOYEES1_TABLE);
        AtlasEntity employees2 = this.getEntity(EMPLOYEES2_TABLE);
        AtlasEntity employees_union = this.getEntity(EMPLOYEES_UNION_TABLE);
        AtlasClassification PII_tag1 = new AtlasClassification("PII");
        PII_tag1.setPropagate(Boolean.valueOf(true));
        PII_tag1.setAttribute("type", (Object)"from hdfs_path entity");
        PII_tag1.setAttribute("valid", (Object)true);
        AtlasClassification PII_tag2 = new AtlasClassification("PII");
        PII_tag2.setPropagate(Boolean.valueOf(true));
        PII_tag2.setAttribute("type", (Object)"from employees1 entity");
        PII_tag2.setAttribute("valid", (Object)true);
        AtlasClassification PII_tag3 = new AtlasClassification("PII");
        PII_tag3.setPropagate(Boolean.valueOf(true));
        PII_tag3.setAttribute("type", (Object)"from employees2 entity");
        PII_tag3.setAttribute("valid", (Object)true);
        AtlasClassification PII_tag4 = new AtlasClassification("PII");
        PII_tag4.setPropagate(Boolean.valueOf(true));
        PII_tag4.setAttribute("type", (Object)"from employees_union entity");
        PII_tag4.setAttribute("valid", (Object)true);
        this.addClassification(hdfs_path, PII_tag1);
        this.addClassification(employees1, PII_tag2);
        this.addClassification(employees2, PII_tag3);
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, PII_tag1.getTypeName(), hdfs_path.getGuid());
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, PII_tag2.getTypeName(), employees1.getGuid());
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, PII_tag3.getTypeName(), employees2.getGuid());
        AtlasRelationship process3_employee_union_relationship = this.getRelationship(EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        Set propagatedClassifications = process3_employee_union_relationship.getPropagatedClassifications();
        Set blockedClassifications = process3_employee_union_relationship.getBlockedPropagatedClassifications();
        Assert.assertNotNull((Object)propagatedClassifications);
        this.assertClassificationEquals(propagatedClassifications, PII_tag1);
        this.assertClassificationEquals(propagatedClassifications, PII_tag2);
        this.assertClassificationEquals(propagatedClassifications, PII_tag3);
        Assert.assertTrue((boolean)blockedClassifications.isEmpty());
        PII_tag2.setEntityGuid(employees1.getGuid());
        PII_tag3.setEntityGuid(employees2.getGuid());
        process3_employee_union_relationship.setBlockedPropagatedClassifications(new HashSet<AtlasClassification>(Arrays.asList(PII_tag2, PII_tag3)));
        this.relationshipStore.update(process3_employee_union_relationship);
        process3_employee_union_relationship = this.getRelationship(EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        propagatedClassifications = process3_employee_union_relationship.getPropagatedClassifications();
        blockedClassifications = process3_employee_union_relationship.getBlockedPropagatedClassifications();
        this.assertClassificationEquals(propagatedClassifications, PII_tag1);
        Assert.assertTrue((!blockedClassifications.isEmpty() ? 1 : 0) != 0);
        this.assertClassificationEquals(blockedClassifications, PII_tag2);
        this.assertClassificationEquals(blockedClassifications, PII_tag3);
        this.assertClassificationNotExistInEntity(EMPLOYEES_UNION_TABLE, PII_tag2);
        this.assertClassificationNotExistInEntity(EMPLOYEES_UNION_TABLE, PII_tag3);
        Assert.assertEquals((int)this.getEntity(EMPLOYEES_UNION_TABLE).getClassifications().size(), (int)1);
        this.assertClassificationExistInEntity(EMPLOYEES_UNION_TABLE, PII_tag1.getTypeName(), hdfs_path.getGuid());
    }

    private void assertClassificationEquals(Set<AtlasClassification> propagatedClassifications, AtlasClassification expected) {
        String expectedTypeName = expected.getTypeName();
        for (AtlasClassification c : propagatedClassifications) {
            if (!c.getTypeName().equals(expectedTypeName)) continue;
            Assert.assertTrue((c.isPropagate() == expected.isPropagate() ? 1 : 0) != 0, (String)"isPropgate does not match");
            Assert.assertTrue((c.getValidityPeriods() == expected.getValidityPeriods() ? 1 : 0) != 0, (String)"validityPeriods do not match");
            return;
        }
        Assert.fail((String)(expectedTypeName + " could not be found"));
    }

    @Test(dependsOnMethods={"addBlockedPropagatedClassifications"})
    public void removeBlockedPropagatedClassifications() throws AtlasBaseException {
        AtlasEntity hdfs_path = this.getEntity(HDFS_PATH_EMPLOYEES);
        AtlasEntity employees1 = this.getEntity(EMPLOYEES1_TABLE);
        AtlasEntity employees2 = this.getEntity(EMPLOYEES2_TABLE);
        AtlasClassification PII_tag1 = new AtlasClassification("PII");
        PII_tag1.setPropagate(Boolean.valueOf(true));
        PII_tag1.setEntityGuid(hdfs_path.getGuid());
        PII_tag1.setAttribute("type", (Object)"from hdfs_path entity");
        PII_tag1.setAttribute("valid", (Object)true);
        AtlasClassification PII_tag2 = new AtlasClassification("PII");
        PII_tag2.setPropagate(Boolean.valueOf(true));
        PII_tag2.setEntityGuid(employees1.getGuid());
        PII_tag2.setAttribute("type", (Object)"from employees1 entity");
        PII_tag2.setAttribute("valid", (Object)true);
        AtlasClassification PII_tag3 = new AtlasClassification("PII");
        PII_tag3.setPropagate(Boolean.valueOf(true));
        PII_tag3.setEntityGuid(employees2.getGuid());
        PII_tag3.setAttribute("type", (Object)"from employees2 entity");
        PII_tag3.setAttribute("valid", (Object)true);
        AtlasRelationship process3_employee_union_relationship = this.getRelationship(EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        process3_employee_union_relationship.setBlockedPropagatedClassifications(new HashSet<AtlasClassification>(Arrays.asList(PII_tag3)));
        this.relationshipStore.update(process3_employee_union_relationship);
        process3_employee_union_relationship = this.getRelationship(EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        Set propagatedClassifications = process3_employee_union_relationship.getPropagatedClassifications();
        Set blockedClassifications = process3_employee_union_relationship.getBlockedPropagatedClassifications();
        this.assertClassificationExistInList(propagatedClassifications, PII_tag1);
        this.assertClassificationExistInList(propagatedClassifications, PII_tag2);
        this.assertClassificationExistInList(blockedClassifications, PII_tag3);
        process3_employee_union_relationship.setBlockedPropagatedClassifications(Collections.emptySet());
        this.relationshipStore.update(process3_employee_union_relationship);
        process3_employee_union_relationship = this.getRelationship(EMPLOYEES_UNION_PROCESS, EMPLOYEES_UNION_TABLE);
        propagatedClassifications = process3_employee_union_relationship.getPropagatedClassifications();
        blockedClassifications = process3_employee_union_relationship.getBlockedPropagatedClassifications();
        this.assertClassificationExistInList(propagatedClassifications, PII_tag1);
        this.assertClassificationExistInList(propagatedClassifications, PII_tag2);
        this.assertClassificationExistInList(propagatedClassifications, PII_tag3);
        Assert.assertTrue((boolean)blockedClassifications.isEmpty());
    }

    @Test(dependsOnMethods={"removeBlockedPropagatedClassifications"})
    public void addClassification_removePropagationsTrue_DeleteCase() throws AtlasBaseException {
        AtlasEntity orders = this.getEntity(ORDERS_TABLE);
        AtlasClassification tag2 = new AtlasClassification("tag2");
        tag2.setEntityGuid(orders.getGuid());
        tag2.setPropagate(Boolean.valueOf(true));
        tag2.setRemovePropagationsOnEntityDelete(Boolean.valueOf(true));
        this.addClassification(orders, tag2);
        List<String> propagatedEntities = Arrays.asList(EMPLOYEES_PROCESS, US_EMPLOYEES_TABLE);
        this.assertClassificationExistInEntities(propagatedEntities, tag2);
        AtlasEntity orders_process = this.getEntity(ORDERS_PROCESS);
        AtlasEntity us_orders = this.getEntity(US_ORDERS_TABLE);
        this.deletePropagatedClassificationExpectFail(orders_process, tag2);
        this.deletePropagatedClassificationExpectFail(us_orders, tag2);
        this.deleteEntity(ORDERS_TABLE);
        this.assertClassificationNotExistInEntity(ORDERS_PROCESS, tag2);
        this.assertClassificationNotExistInEntity(US_ORDERS_TABLE, tag2);
    }

    @Test(dependsOnMethods={"addClassification_removePropagationsTrue_DeleteCase"})
    public void addClassification_removePropagationsFalse_DeleteCase() throws AtlasBaseException {
        AtlasEntity employees = this.getEntity(EMPLOYEES_TABLE);
        AtlasClassification tag1 = new AtlasClassification("tag1");
        tag1.setEntityGuid(employees.getGuid());
        tag1.setPropagate(Boolean.valueOf(true));
        tag1.setRemovePropagationsOnEntityDelete(Boolean.valueOf(false));
        this.addClassification(employees, tag1);
        List<String> propagatedEntities = Arrays.asList(EMPLOYEES_PROCESS, US_EMPLOYEES_TABLE);
        this.assertClassificationExistInEntities(propagatedEntities, tag1);
        AtlasEntity employees_process = this.getEntity(EMPLOYEES_PROCESS);
        AtlasEntity us_employees = this.getEntity(US_EMPLOYEES_TABLE);
        this.deletePropagatedClassificationExpectFail(employees_process, tag1);
        this.deletePropagatedClassificationExpectFail(us_employees, tag1);
        this.deleteEntity(EMPLOYEES_PROCESS);
        this.assertClassificationExistInEntity(EMPLOYEES_PROCESS, tag1);
        this.assertClassificationExistInEntity(US_EMPLOYEES_TABLE, tag1);
    }

    private void assertClassificationExistInList(Set<AtlasClassification> classifications, AtlasClassification classification) {
        String classificationName = classification.getTypeName();
        String entityGuid = classification.getEntityGuid();
        boolean foundClassification = false;
        for (AtlasClassification c : classifications) {
            if (!c.getTypeName().equals(classificationName) || !c.getEntityGuid().equals(entityGuid)) continue;
            foundClassification = true;
        }
        if (!foundClassification) {
            Assert.fail((String)"Propagated classification is not present in classifications list!");
        }
    }

    private void assertClassificationExistInEntities(List<String> entityNames, AtlasClassification classification) throws AtlasBaseException {
        for (String entityName : entityNames) {
            this.assertClassificationExistInEntity(entityName, classification);
        }
    }

    private void assertClassificationExistInEntity(String entityName, AtlasClassification classification) throws AtlasBaseException {
        this.assertClassificationExistInEntity(entityName, classification.getTypeName(), classification.getEntityGuid());
    }

    private void assertClassificationExistInEntity(String entityName, String tagName, String sourceEntityGuid) throws AtlasBaseException {
        List classifications = this.getEntity(entityName).getClassifications();
        String classificationName = tagName;
        String entityGuid = sourceEntityGuid;
        if (CollectionUtils.isNotEmpty((Collection)classifications)) {
            boolean foundClassification = false;
            for (AtlasClassification c : classifications) {
                if (!c.getTypeName().equals(classificationName) || !c.getEntityGuid().equals(entityGuid)) continue;
                foundClassification = true;
            }
            if (!foundClassification) {
                Assert.fail((String)"Propagated classification is not present in entity!");
            }
        }
    }

    private void assertClassificationNotExistInEntities(List<String> entityNames, AtlasClassification classification) throws AtlasBaseException {
        for (String entityName : entityNames) {
            this.assertClassificationNotExistInEntity(entityName, classification);
        }
    }

    private void assertClassificationNotExistInEntity(String entityName, AtlasClassification classification) throws AtlasBaseException {
        List classifications = this.getEntity(entityName).getClassifications();
        String classificationName = classification.getTypeName();
        String entityGuid = classification.getEntityGuid();
        if (CollectionUtils.isNotEmpty((Collection)classifications)) {
            for (AtlasClassification c : classifications) {
                if (!c.getTypeName().equals(classificationName) || !c.getEntityGuid().equals(entityGuid)) continue;
                Assert.fail((String)"Propagated classification should not be present in entity!");
            }
        }
    }

    private void loadModelFilesAndImportTestData() {
        try {
            TestLoadModelUtils.loadModelFromJson("0000-Area0/0010-base_model.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1020-fs_model.json", this.typeDefStore, this.typeRegistry);
            TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1030-hive_model.json", this.typeDefStore, this.typeRegistry);
            this.loadSampleClassificationDefs();
            ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, ClassificationPropagationTest.getZipSource(IMPORT_FILE));
            this.initializeEntitiesMap();
        }
        catch (IOException | AtlasBaseException e) {
            throw new SkipException("Model loading failed!");
        }
    }

    public static InputStream getZipSource(String fileName) throws IOException {
        return ZipFileResourceTestUtils.getFileInputStream(fileName);
    }

    private void loadSampleClassificationDefs() throws AtlasBaseException {
        AtlasClassificationDef tag1 = new AtlasClassificationDef("tag1");
        AtlasClassificationDef tag2 = new AtlasClassificationDef("tag2");
        AtlasClassificationDef tag3 = new AtlasClassificationDef("tag3");
        AtlasClassificationDef tag4 = new AtlasClassificationDef("tag4");
        AtlasClassificationDef PII = new AtlasClassificationDef("PII");
        PII.addAttribute(new AtlasStructDef.AtlasAttributeDef("type", "string"));
        PII.addAttribute(new AtlasStructDef.AtlasAttributeDef("valid", "boolean"));
        this.typeDefStore.createTypesDef(new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), Arrays.asList(tag1, tag2, tag3, tag4, PII), Collections.emptyList(), Collections.emptyList()));
    }

    private void initializeEntitiesMap() throws AtlasBaseException {
        this.entitiesMap = new HashMap<String, String>();
        this.entitiesMap.put(HDFS_PATH_EMPLOYEES, "a3955120-ac17-426f-a4af-972ec8690e5f");
        this.entitiesMap.put(EMPLOYEES1_TABLE, "cdf0040e-739e-4590-a137-964d10e73573");
        this.entitiesMap.put(EMPLOYEES2_TABLE, "0a3e66b6-472c-48b3-8453-abdd24f9494f");
        this.entitiesMap.put(EMPLOYEES_UNION_TABLE, "1ceac963-1a2b-476a-a269-10396187d406");
        this.entitiesMap.put(EMPLOYEES1_PROCESS, "26dae763-85b7-40af-8516-71056d91d2de");
        this.entitiesMap.put(EMPLOYEES2_PROCESS, "c0201260-dbeb-45f4-930d-5129eab31dc9");
        this.entitiesMap.put(EMPLOYEES_UNION_PROCESS, "470a2d1e-b1fd-47de-8f2d-8dfd0a0275a7");
        this.entitiesMap.put(EMPLOYEES_TABLE, "b4edad46-d00f-4e94-be39-8d2619d17e6c");
        this.entitiesMap.put(US_EMPLOYEES_TABLE, "44acef8e-fefe-491c-87d9-e2ea6a9ad3b0");
        this.entitiesMap.put(EMPLOYEES_PROCESS, "a1c9a281-d30b-419c-8199-7434b245d7fe");
        this.entitiesMap.put(ORDERS_TABLE, "ab995a8d-1f87-4908-91e4-d4e8e376ba22");
        this.entitiesMap.put(US_ORDERS_TABLE, "70268a81-f145-4a37-ae39-b09daa85a928");
        this.entitiesMap.put(ORDERS_PROCESS, "da016ad9-456a-4c99-895a-fa00f2de49ba");
        this.lineageInfo = this.lineageService.getAtlasLineageInfo(this.entitiesMap.get(HDFS_PATH_EMPLOYEES), AtlasLineageInfo.LineageDirection.BOTH, 3);
    }

    private AtlasEntity getEntity(String entityName) throws AtlasBaseException {
        String entityGuid = this.entitiesMap.get(entityName);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getById(entityGuid);
        return entityWithExtInfo.getEntity();
    }

    private boolean deleteEntity(String entityName) throws AtlasBaseException {
        String entityGuid = this.entitiesMap.get(entityName);
        EntityMutationResponse response = this.entityStore.deleteById(entityGuid);
        return CollectionUtils.isNotEmpty((Collection)response.getDeletedEntities());
    }

    private AtlasClassification getClassification(AtlasEntity hdfs_employees, AtlasClassification tag2) throws AtlasBaseException {
        return this.entityStore.getClassification(hdfs_employees.getGuid(), tag2.getTypeName());
    }

    private void addClassification(AtlasEntity entity, AtlasClassification classification) throws AtlasBaseException {
        this.addClassifications(entity, Collections.singletonList(classification));
    }

    private void addClassifications(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.entityStore.addClassifications(entity.getGuid(), classifications);
    }

    private void updateClassifications(AtlasEntity entity, AtlasClassification classification) throws AtlasBaseException {
        this.updateClassifications(entity, Collections.singletonList(classification));
    }

    private void updateClassifications(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        this.entityStore.updateClassifications(entity.getGuid(), classifications);
    }

    private void deleteClassification(AtlasEntity entity, AtlasClassification classification) throws AtlasBaseException {
        this.deleteClassifications(entity, Collections.singletonList(classification.getTypeName()));
    }

    private void deleteClassifications(AtlasEntity entity, List<String> classificationNames) throws AtlasBaseException {
        for (String classificationName : classificationNames) {
            this.entityStore.deleteClassification(entity.getGuid(), classificationName);
        }
    }

    private void deletePropagatedClassification(AtlasEntity entity, AtlasClassification classification) throws AtlasBaseException {
        this.deletePropagatedClassification(entity, classification.getTypeName(), classification.getEntityGuid());
    }

    private void deletePropagatedClassification(AtlasEntity entity, String classificationName, String associatedEntityGuid) throws AtlasBaseException {
        this.entityStore.deleteClassification(entity.getGuid(), classificationName, associatedEntityGuid);
    }

    private void deletePropagatedClassificationExpectFail(AtlasEntity entity, AtlasClassification classification) {
        try {
            this.deletePropagatedClassification(entity, classification);
            Assert.fail();
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((Object)ex.getAtlasErrorCode(), (Object)AtlasErrorCode.PROPAGATED_CLASSIFICATION_REMOVAL_NOT_SUPPORTED);
        }
    }

    private AtlasRelationship getRelationship(String fromEntityName, String toEntityName) throws AtlasBaseException {
        String fromEntityId = this.entitiesMap.get(fromEntityName);
        String toEntityId = this.entitiesMap.get(toEntityName);
        Set relations = this.lineageInfo.getRelations();
        String relationshipGuid = null;
        for (AtlasLineageInfo.LineageRelation relation : relations) {
            if (!relation.getFromEntityId().equals(fromEntityId) || !relation.getToEntityId().equals(toEntityId)) continue;
            relationshipGuid = relation.getRelationshipId();
        }
        return this.relationshipStore.getById(relationshipGuid);
    }
}

