/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.atlas.DeleteType;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.store.graph.v2.InverseReferenceUpdateV2Test;
import org.apache.atlas.type.AtlasTypeUtil;
import org.testng.Assert;

public class InverseReferenceUpdateSoftDeleteV2Test
extends InverseReferenceUpdateV2Test {
    public InverseReferenceUpdateSoftDeleteV2Test() {
        super(DeleteType.SOFT);
    }

    @Override
    protected void verify_testInverseReferenceAutoUpdate_NonComposite_OneToMany(AtlasEntity jane) throws Exception {
        this.verifyReferenceList(jane, "subordinates", (List<AtlasObjectId>)ImmutableList.of((Object)((AtlasObjectId)this.nameIdMap.get("John")), (Object)((AtlasObjectId)this.nameIdMap.get("Max"))));
    }

    @Override
    protected void verify_testInverseReferenceAutoUpdate_NonCompositeManyToOne(AtlasEntity a1, AtlasEntity a2, AtlasEntity a3, AtlasEntity b) {
        this.verifyReferenceValue(a1, "oneB", b.getGuid());
        this.verifyReferenceValue(a2, "oneB", b.getGuid());
        this.verifyReferenceList(b, "manyA", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a3)));
    }

    @Override
    protected void verify_testInverseReferenceAutoUpdate_NonComposite_OneToOne(AtlasEntity a1, AtlasEntity b) {
        this.verifyReferenceValue(a1, "b", b.getGuid());
    }

    @Override
    protected void verify_testInverseReferenceAutoUpdate_Map(AtlasEntity a1, AtlasEntity b1, AtlasEntity b2, AtlasEntity b3) {
        Object value = a1.getAttribute("mapToB");
        Assert.assertTrue((boolean)(value instanceof Map));
        Map refMap = (Map)value;
        Assert.assertEquals((int)refMap.size(), (int)3);
        AtlasObjectId referencedEntityId = (AtlasObjectId)refMap.get("b3");
        Assert.assertEquals((Object)referencedEntityId, (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)b3));
        this.verifyReferenceValue(b1, "mappedFromA", a1.getGuid());
        this.verifyReferenceValue(b2, "mappedFromA", a1.getGuid());
    }
}

