/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasEntityHeaders;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.ClassificationAssociator;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public class ClassificationAssociatorTest {
    private static final String TABLE_GUID = "df122fc3-5555-40f8-a30f-3090b8a622f8";
    private static String TEST_FILES_SUBDIR = "classification-association";
    private static String MESSAGE_SEPARATOR = ":";
    private static String ENTITY_NAME_SEPARATOR = "->";

    @Test
    public void auditScanYieldsNothing_EmptyHeadersReturned() {
        AtlasEntityHeaders actualEntityHeaders = this.setupRetriever("header-empty", 0, 0, null);
        Assert.assertNotNull((Object)actualEntityHeaders);
        Assert.assertEquals((int)actualEntityHeaders.getGuidHeaderMap().size(), (int)0);
    }

    @Test
    public void auditScanYieldsOneEntity_EntityHeadersHasOneElementWithClassification() {
        AtlasEntityHeaders actualEntityHeaders = this.setupRetriever("header-Tx", 0, 0, TABLE_GUID);
        Assert.assertNotNull((Object)actualEntityHeaders);
        Assert.assertEquals((int)actualEntityHeaders.getGuidHeaderMap().size(), (int)1);
        Assert.assertTrue((boolean)actualEntityHeaders.getGuidHeaderMap().containsKey(TABLE_GUID));
        Assert.assertEquals((String)((AtlasEntityHeader)actualEntityHeaders.getGuidHeaderMap().get(TABLE_GUID)).getGuid(), (String)TABLE_GUID);
        Assert.assertNotNull((Object)((AtlasEntityHeader)actualEntityHeaders.getGuidHeaderMap().get(TABLE_GUID)).getClassifications());
        Assert.assertEquals((int)((AtlasEntityHeader)actualEntityHeaders.getGuidHeaderMap().get(TABLE_GUID)).getClassifications().size(), (int)1);
    }

    private AtlasEntityHeaders setupRetriever(String headersFile, int fromTimestamp, int toTimestamp, String tableGuid) {
        AtlasEntityHeader entityHeaderWithClassification = null;
        try {
            HashSet<String> guids = new HashSet<String>();
            entityHeaderWithClassification = TestResourceFileUtils.readObjectFromJson(TEST_FILES_SUBDIR, headersFile, AtlasEntityHeader.class);
            if (!StringUtils.isEmpty((String)tableGuid)) {
                guids.add(tableGuid);
            }
            EntityAuditRepository auditRepository = (EntityAuditRepository)Mockito.mock(EntityAuditRepository.class);
            Mockito.when((Object)auditRepository.getEntitiesWithTagChanges(Matchers.anyLong(), Matchers.anyLong())).thenReturn(guids);
            EntityGraphRetriever entityGraphRetriever = (EntityGraphRetriever)Mockito.mock(EntityGraphRetriever.class);
            Mockito.when((Object)entityGraphRetriever.toAtlasEntityHeaderWithClassifications(TABLE_GUID)).thenReturn((Object)entityHeaderWithClassification);
            ClassificationAssociator.Retriever retriever = new ClassificationAssociator.Retriever(entityGraphRetriever, auditRepository);
            return retriever.get((long)fromTimestamp, (long)toTimestamp);
        }
        catch (Exception ex) {
            FileAssert.fail((String)"Exception!");
            return null;
        }
    }

    @Test
    public void updaterIncorrectType_ReturnsError() throws IOException {
        AtlasEntityHeaders entityHeaderMap = this.getEntityHeaderMapFromFile("header-PII");
        AtlasEntityStore entitiesStore = (AtlasEntityStore)Mockito.mock(AtlasEntityStore.class);
        AtlasTypeRegistry typeRegistry = (AtlasTypeRegistry)Mockito.mock(AtlasTypeRegistry.class);
        Mockito.when((Object)typeRegistry.getEntityTypeByName(Matchers.anyString())).thenReturn(null);
        AtlasGraph atlasGraph = (AtlasGraph)Mockito.mock(AtlasGraph.class);
        ClassificationAssociator.Updater updater = new ClassificationAssociator.Updater(atlasGraph, typeRegistry, entitiesStore);
        String summary = updater.setClassifications(entityHeaderMap.getGuidHeaderMap());
        Assert.assertTrue((boolean)summary.contains("hive_"));
        Assert.assertTrue((boolean)summary.contains("(Skipped)"));
    }

    @Test
    public void updaterCorrectTypeEntityNotFound_Skipped() throws IOException {
        AtlasEntityHeaders entityHeaderMap = this.getEntityHeaderMapFromFile("header-PII");
        AtlasEntityType hiveTable = (AtlasEntityType)Mockito.mock(AtlasEntityType.class);
        AtlasEntityStore entitiesStore = (AtlasEntityStore)Mockito.mock(AtlasEntityStore.class);
        AtlasTypeRegistry typeRegistry = (AtlasTypeRegistry)Mockito.mock(AtlasTypeRegistry.class);
        AtlasGraph atlasGraph = (AtlasGraph)Mockito.mock(AtlasGraph.class);
        Mockito.when((Object)typeRegistry.getEntityTypeByName(Matchers.anyString())).thenReturn((Object)hiveTable);
        Mockito.when((Object)hiveTable.getTypeName()).thenReturn((Object)"hive_column");
        ClassificationAssociatorUpdaterForSpy updater = new ClassificationAssociatorUpdaterForSpy(atlasGraph, typeRegistry, entitiesStore);
        String summary = updater.setClassifications(entityHeaderMap.getGuidHeaderMap());
        TypeReference<String[]> typeReference = new TypeReference<String[]>(){};
        String[] summaryArray = (String[])AtlasJson.fromJson((String)summary, (TypeReference)typeReference);
        Assert.assertEquals((int)summaryArray.length, (int)1);
        this.assertSummaryElement(summaryArray[0], "Entity", "(Skipped)", "");
    }

    @Test
    public void updaterEntityWithUniqueName() throws IOException, AtlasBaseException {
        AtlasEntityDef ed = this.getAtlasEntityDefFromFile("col-entity-def-unique-name");
        AtlasEntityHeaders entityHeaderMap = this.getEntityHeaderMapFromFile("header-PII-no-qualifiedName");
        AtlasEntityStore entitiesStore = (AtlasEntityStore)Mockito.mock(AtlasEntityStore.class);
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = typeRegistry.lockTypeRegistryForUpdate();
        ttr.addTypes((Collection)CollectionUtils.newSingletonArrayList((Object)ed));
        AtlasGraph atlasGraph = (AtlasGraph)Mockito.mock(AtlasGraph.class);
        ClassificationAssociatorUpdaterForSpy updater = new ClassificationAssociatorUpdaterForSpy(atlasGraph, (AtlasTypeRegistry)ttr, entitiesStore, "col-entity-PII");
        String summary = updater.setClassifications(entityHeaderMap.getGuidHeaderMap());
        TypeReference<String[]> typeReference = new TypeReference<String[]>(){};
        String[] summaryArray = (String[])AtlasJson.fromJson((String)summary, (TypeReference)typeReference);
        Assert.assertEquals((int)summaryArray.length, (int)1);
        this.assertSummaryElement(summaryArray[0], "Update", "(Done)", "PII");
    }

    @Test
    public void updaterTests() throws IOException {
        this.updaterAssert("header-None", "col-entity-None", new String[0]);
        this.updaterAssert("header-PII", "col-entity-None", "Add:PII");
        this.updaterAssert("header-PII", "col-entity-PII", "Update:PII");
        this.updaterAssert("header-None", "col-entity-PII", "Delete:PII");
        this.updaterAssert("header-PII-VENDOR_PII", "col-entity-PII-FIN_PII", "Delete:FIN_PII", "Update:PII", "Add:VENDOR_PII");
        this.updaterAssert("header-None", "col-entity-None", new String[0]);
        this.updaterAssert("header-FIN_PII", "col-entity-PII", "Delete:PII", "Add:FIN_PII");
    }

    @Test
    public void updater_filterPropagatedClassifications() throws IOException {
        this.updaterAssert("header-Tx-prop-T1", "col-entity-T1-prop-Tn", "Delete:T1", "Add:Tx");
        this.updaterAssert("header-Tx-prop-T1-No-Guid", "col-entity-T1-prop-Tn-No-Guid", "Delete:Tn", "Update:T1", "Add:Tx");
    }

    private void assertSummaryElement(String summaryElement, String operation, String status, String classificationName) {
        String[] splits = StringUtils.split((String)summaryElement, (String)MESSAGE_SEPARATOR);
        String[] nameSplits = StringUtils.split((String)splits[3], (String)ENTITY_NAME_SEPARATOR);
        if (nameSplits.length > 1) {
            Assert.assertEquals((String)nameSplits[1].trim(), (String)classificationName);
        }
        Assert.assertEquals((String)splits[0], (String)operation);
        Assert.assertEquals((String)splits[4], (String)status);
    }

    private String[] setupUpdater(String entityHeaderFileName, String entityFileName, int expectedSummaryLength) throws IOException {
        AtlasEntityHeaders entityHeaderMap = this.getEntityHeaderMapFromFile(entityHeaderFileName);
        AtlasEntityType hiveTable = (AtlasEntityType)Mockito.mock(AtlasEntityType.class);
        AtlasEntityStore entitiesStore = (AtlasEntityStore)Mockito.mock(AtlasEntityStore.class);
        AtlasTypeRegistry typeRegistry = (AtlasTypeRegistry)Mockito.mock(AtlasTypeRegistry.class);
        AtlasGraph atlasGraph = (AtlasGraph)Mockito.mock(AtlasGraph.class);
        Mockito.when((Object)typeRegistry.getEntityTypeByName(Matchers.anyString())).thenReturn((Object)hiveTable);
        Mockito.when((Object)hiveTable.getTypeName()).thenReturn((Object)"hive_column");
        ClassificationAssociatorUpdaterForSpy updater = new ClassificationAssociatorUpdaterForSpy(atlasGraph, typeRegistry, entitiesStore, entityFileName);
        String summary = updater.setClassifications(entityHeaderMap.getGuidHeaderMap());
        TypeReference<String[]> typeReference = new TypeReference<String[]>(){};
        String[] summaryArray = (String[])AtlasJson.fromJson((String)summary, (TypeReference)typeReference);
        Assert.assertEquals((int)summaryArray.length, (int)expectedSummaryLength);
        return summaryArray;
    }

    private AtlasEntityHeader getEntityHeaderFromFile(String entityJson) throws IOException {
        return TestResourceFileUtils.readObjectFromJson(TEST_FILES_SUBDIR, entityJson, AtlasEntityHeader.class);
    }

    private AtlasEntityHeaders getEntityHeaderMapFromFile(String filename) throws IOException {
        return TestResourceFileUtils.readObjectFromJson(TEST_FILES_SUBDIR, filename, AtlasEntityHeaders.class);
    }

    private AtlasEntityDef getAtlasEntityDefFromFile(String filename) throws IOException {
        return TestResourceFileUtils.readObjectFromJson(TEST_FILES_SUBDIR, filename, AtlasEntityDef.class);
    }

    private void updaterAssert(String incoming, String entity, String ... opNamePair) throws IOException {
        String[] summary = this.setupUpdater(incoming, entity, opNamePair.length);
        for (int i = 0; i < opNamePair.length; ++i) {
            String s = opNamePair[i];
            String[] splits = StringUtils.split((String)s, (String)":");
            this.assertSummaryElement(summary[i], splits[0], "(Done)", splits[1]);
        }
    }

    private class ClassificationAssociatorUpdaterForSpy
    extends ClassificationAssociator.Updater {
        private final String entityFileName;

        public ClassificationAssociatorUpdaterForSpy(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry, AtlasEntityStore entitiesStore) {
            super(atlasGraph, typeRegistry, entitiesStore);
            this.entityFileName = "";
        }

        public ClassificationAssociatorUpdaterForSpy(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry, AtlasEntityStore entitiesStore, String entityFileName) {
            super(atlasGraph, typeRegistry, entitiesStore);
            this.entityFileName = entityFileName;
        }

        AtlasEntityHeader getByUniqueAttributes(AtlasEntityType entityType, String qualifiedName, Map<String, Object> attrValues) {
            try {
                if (StringUtils.isEmpty((String)this.entityFileName)) {
                    return null;
                }
                return ClassificationAssociatorTest.this.getEntityHeaderFromFile(this.entityFileName);
            }
            catch (IOException e) {
                FileAssert.fail((String)(this.entityFileName + " could not be loaded."));
                return null;
            }
        }
    }
}

