/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.atlas.DeleteType;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.store.graph.v2.AtlasRelationshipStoreV2Test;
import org.apache.atlas.type.AtlasTypeUtil;
import org.testng.Assert;

public class AtlasRelationshipStoreSoftDeleteV2Test
extends AtlasRelationshipStoreV2Test {
    public AtlasRelationshipStoreSoftDeleteV2Test() {
        super(DeleteType.SOFT);
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_NonComposite_OneToMany(AtlasEntity jane) throws Exception {
        AtlasRelationshipStoreSoftDeleteV2Test.verifyRelationshipAttributeList(jane, "subordinates", (List<AtlasObjectId>)ImmutableList.of((Object)((AtlasObjectId)this.employeeNameIdMap.get("John")), (Object)((AtlasObjectId)this.employeeNameIdMap.get("Max"))));
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_NonComposite_ManyToOne(AtlasEntity a1, AtlasEntity a2, AtlasEntity a3, AtlasEntity b) {
        AtlasRelationshipStoreSoftDeleteV2Test.verifyRelationshipAttributeValue(a1, "oneB", b.getGuid());
        AtlasRelationshipStoreSoftDeleteV2Test.verifyRelationshipAttributeValue(a2, "oneB", b.getGuid());
        AtlasRelationshipStoreSoftDeleteV2Test.verifyRelationshipAttributeList(b, "manyA", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a3)));
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_NonComposite_OneToOne(AtlasEntity a1, AtlasEntity b) {
        AtlasRelationshipStoreSoftDeleteV2Test.verifyRelationshipAttributeValue(a1, "b", b.getGuid());
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_ManyToMany_Friends(AtlasEntity max, AtlasEntity julius, AtlasEntity mike, AtlasEntity john) throws Exception {
        AtlasObjectId johnId = (AtlasObjectId)this.employeeNameIdMap.get("John");
        AtlasObjectId mikeId = (AtlasObjectId)this.employeeNameIdMap.get("Mike");
        AtlasObjectId juliusId = (AtlasObjectId)this.employeeNameIdMap.get("Julius");
        AtlasObjectId maxId = (AtlasObjectId)this.employeeNameIdMap.get("Max");
        List<AtlasObjectId> maxFriendsIds = AtlasRelationshipStoreSoftDeleteV2Test.toAtlasObjectIds(max.getRelationshipAttribute("friends"));
        Assert.assertNotNull(maxFriendsIds);
        Assert.assertEquals((int)maxFriendsIds.size(), (int)3);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdsContains(maxFriendsIds, johnId);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdsContains(maxFriendsIds, juliusId);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdsContains(maxFriendsIds, mikeId);
        List<AtlasObjectId> juliusFriendsIds = AtlasRelationshipStoreSoftDeleteV2Test.toAtlasObjectIds(julius.getRelationshipAttribute("friends"));
        Assert.assertNotNull(juliusFriendsIds);
        Assert.assertEquals((int)juliusFriendsIds.size(), (int)1);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdsContains(juliusFriendsIds, maxId);
        List<AtlasObjectId> mikeFriendsIds = AtlasRelationshipStoreSoftDeleteV2Test.toAtlasObjectIds(mike.getRelationshipAttribute("friends"));
        Assert.assertNotNull(mikeFriendsIds);
        Assert.assertEquals((int)mikeFriendsIds.size(), (int)2);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdsContains(mikeFriendsIds, johnId);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdsContains(mikeFriendsIds, maxId);
        List<AtlasObjectId> johnFriendsIds = AtlasRelationshipStoreSoftDeleteV2Test.toAtlasObjectIds(john.getRelationshipAttribute("friends"));
        Assert.assertNotNull(johnFriendsIds);
        Assert.assertEquals((int)johnFriendsIds.size(), (int)2);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdsContains(johnFriendsIds, maxId);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdsContains(johnFriendsIds, mikeId);
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_OneToOne_Sibling(AtlasEntity julius, AtlasEntity jane, AtlasEntity mike) throws Exception {
        AtlasObjectId juliusId = (AtlasObjectId)this.employeeNameIdMap.get("Julius");
        AtlasObjectId mikeId = (AtlasObjectId)this.employeeNameIdMap.get("Mike");
        AtlasObjectId juliusSiblingId = AtlasRelationshipStoreSoftDeleteV2Test.toAtlasObjectId(julius.getRelationshipAttribute("sibling"));
        Assert.assertNotNull((Object)juliusSiblingId);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdEquals(juliusSiblingId, mikeId);
        AtlasObjectId mikeSiblingId = AtlasRelationshipStoreSoftDeleteV2Test.toAtlasObjectId(mike.getRelationshipAttribute("sibling"));
        Assert.assertNotNull((Object)mikeSiblingId);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdEquals(mikeSiblingId, juliusId);
        AtlasObjectId janeSiblingId = AtlasRelationshipStoreSoftDeleteV2Test.toAtlasObjectId(jane.getRelationshipAttribute("sibling"));
        Assert.assertNotNull((Object)janeSiblingId);
        AtlasRelationshipStoreSoftDeleteV2Test.assertObjectIdEquals(janeSiblingId, juliusId);
    }
}

