/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.atlas.DeleteType;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.store.graph.v2.AtlasRelationshipStoreV2Test;
import org.apache.atlas.type.AtlasTypeUtil;
import org.testng.Assert;

public class AtlasRelationshipStoreHardDeleteV2Test
extends AtlasRelationshipStoreV2Test {
    public AtlasRelationshipStoreHardDeleteV2Test() {
        super(DeleteType.HARD);
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_NonComposite_OneToMany(AtlasEntity jane) throws Exception {
        AtlasRelationshipStoreHardDeleteV2Test.verifyRelationshipAttributeList(jane, "subordinates", (List<AtlasObjectId>)ImmutableList.of((Object)((AtlasObjectId)this.employeeNameIdMap.get("John"))));
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_NonComposite_ManyToOne(AtlasEntity a1, AtlasEntity a2, AtlasEntity a3, AtlasEntity b) {
        AtlasRelationshipStoreHardDeleteV2Test.verifyRelationshipAttributeValue(a1, "oneB", null);
        AtlasRelationshipStoreHardDeleteV2Test.verifyRelationshipAttributeValue(a2, "oneB", null);
        AtlasRelationshipStoreHardDeleteV2Test.verifyRelationshipAttributeList(b, "manyA", (List<AtlasObjectId>)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a3)));
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_NonComposite_OneToOne(AtlasEntity a1, AtlasEntity b) {
        AtlasRelationshipStoreHardDeleteV2Test.verifyRelationshipAttributeValue(a1, "b", null);
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_ManyToMany_Friends(AtlasEntity max, AtlasEntity julius, AtlasEntity mike, AtlasEntity john) throws Exception {
        AtlasObjectId johnId = (AtlasObjectId)this.employeeNameIdMap.get("John");
        AtlasObjectId mikeId = (AtlasObjectId)this.employeeNameIdMap.get("Mike");
        AtlasObjectId juliusId = (AtlasObjectId)this.employeeNameIdMap.get("Julius");
        AtlasObjectId maxId = (AtlasObjectId)this.employeeNameIdMap.get("Max");
        List<AtlasObjectId> maxFriendsIds = AtlasRelationshipStoreHardDeleteV2Test.toAtlasObjectIds(max.getRelationshipAttribute("friends"));
        Assert.assertNotNull(maxFriendsIds);
        Assert.assertEquals((int)maxFriendsIds.size(), (int)2);
        AtlasRelationshipStoreHardDeleteV2Test.assertObjectIdsContains(maxFriendsIds, johnId);
        AtlasRelationshipStoreHardDeleteV2Test.assertObjectIdsContains(maxFriendsIds, juliusId);
        List<AtlasObjectId> juliusFriendsIds = AtlasRelationshipStoreHardDeleteV2Test.toAtlasObjectIds(julius.getRelationshipAttribute("friends"));
        Assert.assertNotNull(juliusFriendsIds);
        Assert.assertEquals((int)juliusFriendsIds.size(), (int)1);
        AtlasRelationshipStoreHardDeleteV2Test.assertObjectIdsContains(juliusFriendsIds, maxId);
        List<AtlasObjectId> mikeFriendsIds = AtlasRelationshipStoreHardDeleteV2Test.toAtlasObjectIds(mike.getRelationshipAttribute("friends"));
        Assert.assertNotNull(mikeFriendsIds);
        Assert.assertEquals((int)mikeFriendsIds.size(), (int)1);
        AtlasRelationshipStoreHardDeleteV2Test.assertObjectIdsContains(mikeFriendsIds, johnId);
        List<AtlasObjectId> johnFriendsIds = AtlasRelationshipStoreHardDeleteV2Test.toAtlasObjectIds(john.getRelationshipAttribute("friends"));
        Assert.assertNotNull(johnFriendsIds);
        Assert.assertEquals((int)johnFriendsIds.size(), (int)2);
        AtlasRelationshipStoreHardDeleteV2Test.assertObjectIdsContains(johnFriendsIds, maxId);
        AtlasRelationshipStoreHardDeleteV2Test.assertObjectIdsContains(johnFriendsIds, mikeId);
    }

    @Override
    protected void verifyRelationshipAttributeUpdate_OneToOne_Sibling(AtlasEntity julius, AtlasEntity jane, AtlasEntity mike) throws Exception {
        AtlasObjectId juliusId = (AtlasObjectId)this.employeeNameIdMap.get("Julius");
        AtlasObjectId mikeId = (AtlasObjectId)this.employeeNameIdMap.get("Mike");
        AtlasObjectId juliusSiblingId = AtlasRelationshipStoreHardDeleteV2Test.toAtlasObjectId(julius.getRelationshipAttribute("sibling"));
        Assert.assertNotNull((Object)juliusSiblingId);
        AtlasRelationshipStoreHardDeleteV2Test.assertObjectIdEquals(juliusSiblingId, mikeId);
        AtlasObjectId mikeSiblingId = AtlasRelationshipStoreHardDeleteV2Test.toAtlasObjectId(mike.getRelationshipAttribute("sibling"));
        Assert.assertNotNull((Object)mikeSiblingId);
        AtlasRelationshipStoreHardDeleteV2Test.assertObjectIdEquals(mikeSiblingId, juliusId);
        AtlasObjectId janeSiblingId = AtlasRelationshipStoreHardDeleteV2Test.toAtlasObjectId(jane.getRelationshipAttribute("sibling"));
        Assert.assertNull((Object)janeSiblingId);
    }
}

