/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.inject.Inject;
import java.util.Collections;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityDefStoreV2;
import org.apache.atlas.type.AtlasTypeUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasEntityDefStoreV2Test
extends AtlasTestBase {
    @Inject
    private AtlasEntityDefStoreV2 entityDefStore;

    @DataProvider
    public Object[][] invalidAttributeNameWithReservedKeywords() {
        AtlasEntityDef invalidAttrNameType = AtlasTypeUtil.createClassTypeDef((String)"Invalid_Attribute_Type", (String)"description", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"order", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"limit", (String)"string")});
        return new Object[][]{{invalidAttrNameType}};
    }

    @Test(dataProvider="invalidAttributeNameWithReservedKeywords")
    public void testCreateTypeWithReservedKeywords(AtlasEntityDef atlasEntityDef) throws AtlasException {
        try {
            ApplicationProperties.get().setProperty("atlas.types.allowReservedKeywords", (Object)false);
            this.entityDefStore.create(atlasEntityDef, null);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.ATTRIBUTE_NAME_INVALID);
        }
    }

    @Override
    @BeforeClass
    public void initialize() throws Exception {
        super.initialize();
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }
}

