/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestRelationshipUtilsV2;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityComparator;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityTestBase;
import org.apache.atlas.type.AtlasTypeUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasEntityComparatorTest
extends AtlasEntityTestBase {
    private AtlasEntityComparator comparator;

    @Override
    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
        AtlasTypesDef[] testTypesDefs = new AtlasTypesDef[]{TestUtilsV2.defineHiveTypes(), TestRelationshipUtilsV2.getInverseReferenceTestTypes()};
        this.createTypesDef(testTypesDefs);
        this.comparator = new AtlasEntityComparator(this.typeRegistry, null, null, false, false);
    }

    @Override
    @AfterClass
    public void clear() throws Exception {
    }

    @Test
    public void testSameEntities() throws AtlasBaseException {
        AtlasEntity dbEntity = TestUtilsV2.createDBEntity();
        dbEntity.setAttribute("namespace", (Object)"db namespace");
        dbEntity.setAttribute("cluster", (Object)"Fenton_Cluster");
        AtlasEntity tableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity);
        AtlasEntity newTableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity, (String)tableEntity.getAttribute("name").toString());
        tableEntity.setClassifications(this.toAtlasClassifications(new String[]{"test-1"}));
        newTableEntity.setClassifications(this.toAtlasClassifications(new String[]{"test-1"}));
        tableEntity.setCustomAttributes((Map)new HashMap<String, String>(){
            {
                this.put("foo", "bar");
            }
        });
        newTableEntity.setCustomAttributes((Map)new HashMap<String, String>(){
            {
                this.put("foo", "bar");
            }
        });
        AtlasEntityComparator.AtlasEntityDiffResult diffResult = this.comparator.getDiffResult(tableEntity, newTableEntity, true);
        Assert.assertFalse((boolean)diffResult.hasDifference());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInCustomAttributes());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInBusinessAttributes());
        diffResult = this.comparator.getDiffResult(tableEntity, newTableEntity, false);
        Assert.assertFalse((boolean)diffResult.hasDifference());
    }

    @Test
    public void testChangedEntities() throws AtlasBaseException {
        AtlasEntity dbEntity = TestUtilsV2.createDBEntity();
        dbEntity.setAttribute("namespace", (Object)"db namespace");
        dbEntity.setAttribute("cluster", (Object)"Fenton_Cluster");
        AtlasEntity tableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity);
        AtlasEntity newTableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity);
        tableEntity.setCustomAttributes((Map)new HashMap<String, String>(){
            {
                this.put("foo", "bar-1");
            }
        });
        newTableEntity.setCustomAttributes((Map)new HashMap<String, String>(){
            {
                this.put("foo", "bar-2");
            }
        });
        AtlasEntityComparator.AtlasEntityDiffResult diffResult = this.comparator.getDiffResult(newTableEntity, tableEntity, true);
        Assert.assertTrue((boolean)diffResult.hasDifference());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInCustomAttributes());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInBusinessAttributes());
        diffResult = this.comparator.getDiffResult(tableEntity, newTableEntity, false);
        Assert.assertNotNull((Object)diffResult.getDiffEntity());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInCustomAttributes());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInBusinessAttributes());
    }

    @Test
    public void testChangedEntitiesCustomAttribute() throws AtlasBaseException {
        AtlasEntity dbEntity = TestUtilsV2.createDBEntity();
        dbEntity.setAttribute("namespace", (Object)"db namespace");
        dbEntity.setAttribute("cluster", (Object)"Fenton_Cluster");
        AtlasEntity tableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity);
        AtlasEntity newTableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity, (String)tableEntity.getAttribute("name").toString());
        tableEntity.setCustomAttributes((Map)new HashMap<String, String>(){
            {
                this.put("foo", "bar-1");
            }
        });
        newTableEntity.setCustomAttributes((Map)new HashMap<String, String>(){
            {
                this.put("foo", "bar-2");
            }
        });
        AtlasEntityComparator.AtlasEntityDiffResult diffResult = this.comparator.getDiffResult(newTableEntity, tableEntity, true);
        Assert.assertTrue((boolean)diffResult.hasDifference());
        Assert.assertTrue((boolean)diffResult.hasDifferenceOnlyInCustomAttributes());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInBusinessAttributes());
        diffResult = this.comparator.getDiffResult(tableEntity, newTableEntity, false);
        Assert.assertNotNull((Object)diffResult.getDiffEntity());
        Assert.assertTrue((boolean)diffResult.hasDifferenceOnlyInCustomAttributes());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInBusinessAttributes());
    }

    @Test
    public void testChangedEntitiesClassification() throws AtlasBaseException {
        AtlasEntity dbEntity = TestUtilsV2.createDBEntity();
        dbEntity.setAttribute("namespace", (Object)"db namespace");
        dbEntity.setAttribute("cluster", (Object)"Fenton_Cluster");
        AtlasEntity tableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity);
        AtlasEntity newTableEntity = TestUtilsV2.createTableEntity((AtlasEntity)dbEntity, (String)tableEntity.getAttribute("name").toString());
        tableEntity.setClassifications(this.toAtlasClassifications(new String[]{"test-1"}));
        newTableEntity.setClassifications(this.toAtlasClassifications(new String[]{"test-2"}));
        AtlasEntityComparator.AtlasEntityDiffResult diffResult = this.comparator.getDiffResult(newTableEntity, tableEntity, true);
        Assert.assertTrue((boolean)diffResult.hasDifference());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInCustomAttributes());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInBusinessAttributes());
        diffResult = this.comparator.getDiffResult(tableEntity, newTableEntity, false);
        Assert.assertNotNull((Object)diffResult.getDiffEntity());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInCustomAttributes());
        Assert.assertFalse((boolean)diffResult.hasDifferenceOnlyInBusinessAttributes());
    }

    @Test
    public void testChangedRelationshipAttributes() throws AtlasBaseException {
        AtlasEntity a1 = new AtlasEntity("A");
        a1.setAttribute("name", (Object)"a1_name");
        AtlasEntity a2 = new AtlasEntity("A");
        a2.setAttribute("name", (Object)"a2_name");
        AtlasEntity a3 = new AtlasEntity("A");
        a3.setAttribute("name", (Object)"a3_name");
        AtlasEntity b1 = new AtlasEntity("B");
        b1.setAttribute("name", (Object)"b_name");
        b1.setRelationshipAttribute("manyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        AtlasEntity b2 = new AtlasEntity("B");
        b2.setAttribute("name", (Object)"b_name");
        b2.setRelationshipAttribute("manyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a1), (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a2)));
        AtlasEntity b3 = new AtlasEntity("B");
        b3.setAttribute("name", (Object)"b_name");
        b3.setRelationshipAttribute("manyA", (Object)ImmutableList.of((Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)a3)));
        AtlasEntity b4 = new AtlasEntity("B");
        b4.setAttribute("name", (Object)"b_name");
        Assert.assertFalse((boolean)this.comparator.getDiffResult(b1, b2, true).hasDifference());
        Assert.assertTrue((boolean)this.comparator.getDiffResult(b1, b3, true).hasDifference());
        Assert.assertTrue((boolean)this.comparator.getDiffResult(b1, b4, true).hasDifference());
        Assert.assertTrue((boolean)this.comparator.getDiffResult(b3, b4, true).hasDifference());
        Assert.assertFalse((boolean)this.comparator.getDiffResult(b1, b2, false).hasDifference());
        Assert.assertTrue((boolean)this.comparator.getDiffResult(b1, b3, false).hasDifference());
        Assert.assertTrue((boolean)this.comparator.getDiffResult(b1, b4, false).hasDifference());
        Assert.assertTrue((boolean)this.comparator.getDiffResult(b3, b4, false).hasDifference());
    }

    private List<AtlasClassification> toAtlasClassifications(String[] classificationNames) {
        ArrayList<AtlasClassification> ret = new ArrayList<AtlasClassification>();
        if (classificationNames != null) {
            for (String classificationName : classificationNames) {
                ret.add(new AtlasClassification(classificationName));
            }
        }
        return ret;
    }
}

