/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityTestBase;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.lang.time.DateUtils;
import org.locationtech.jts.util.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasComplexAttributesTest
extends AtlasEntityTestBase {
    private AtlasEntity.AtlasEntityWithExtInfo complexCollectionAttrEntity;
    private AtlasEntity.AtlasEntityWithExtInfo complexCollectionAttrEntityForDelete;
    private AtlasEntity.AtlasEntityWithExtInfo mapAttributesEntity;

    @Override
    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
        AtlasTypesDef[] testTypesDefs = new AtlasTypesDef[]{TestUtilsV2.defineTypeWithComplexCollectionAttributes(), TestUtilsV2.defineTypeWithMapAttributes(), TestUtilsV2.defineSimpleAttrType()};
        this.createTypesDef(testTypesDefs);
        this.complexCollectionAttrEntity = TestUtilsV2.createComplexCollectionAttrEntity();
        this.complexCollectionAttrEntityForDelete = TestUtilsV2.createComplexCollectionAttrEntity();
        this.mapAttributesEntity = TestUtilsV2.createMapAttrEntity();
    }

    @Test
    public void testCreateComplexAttributeEntity() throws Exception {
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.complexCollectionAttrEntity), false);
        AtlasEntityHeader entityCreated = response.getFirstCreatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)this.complexCollectionAttrEntity, this.getEntityFromStore(entityCreated));
    }

    @Test
    public void testPrimitiveMapAttributes() throws Exception {
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.mapAttributesEntity), false);
        AtlasEntityHeader entityCreated = response.getFirstCreatedEntityByTypeName("map_entity_type");
        AtlasEntity entityFromStore = this.getEntityFromStore(entityCreated);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)this.mapAttributesEntity, entityFromStore);
        AtlasEntity attrEntity = this.getEntityFromStore(this.mapAttributesEntity.getEntity().getGuid());
        HashMap<String, String> map1 = new HashMap<String, String>(){
            {
                this.put("map1Key11", "value11");
                this.put("map1Key22", "value22");
                this.put("map1Key33", "value33");
            }
        };
        HashMap<String, Integer> map2 = new HashMap<String, Integer>(){
            {
                this.put("map2Key11", 1100);
                this.put("map2Key22", 2200);
                this.put("map2Key33", 3300);
            }
        };
        HashMap<String, Boolean> map3 = new HashMap<String, Boolean>(){
            {
                this.put("map3Key11", true);
                this.put("map3Key22", false);
                this.put("map3Key33", true);
            }
        };
        HashMap<String, Float> map4 = new HashMap<String, Float>(){
            {
                this.put("map4Key11", Float.valueOf(11.0f));
                this.put("map4Key22", Float.valueOf(22.0f));
                this.put("map4Key33", Float.valueOf(33.0f));
            }
        };
        HashMap<String, Date> map5 = new HashMap<String, Date>(){
            {
                this.put("map5Key11", DateUtils.addHours((Date)new Date(), (int)1));
                this.put("map5Key22", DateUtils.addHours((Date)new Date(), (int)2));
                this.put("map5Key33", DateUtils.addHours((Date)new Date(), (int)3));
            }
        };
        this.updateEntityMapAttributes(attrEntity, (Map<String, String>)map1, (Map<String, Integer>)map2, (Map<String, Boolean>)map3, (Map<String, Float>)map4, (Map<String, Date>)map5);
        AtlasEntity.AtlasEntitiesWithExtInfo attrEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(attrEntity);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(attrEntitiesInfo), false);
        AtlasEntityHeader updatedAttrEntity = response.getFirstUpdatedEntityByTypeName("map_entity_type");
        AtlasEntity updatedFromStore = this.getEntityFromStore(updatedAttrEntity);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)attrEntitiesInfo, updatedFromStore);
        map1.put("map1Key44", "value44");
        map2.put("map2Key44", 4400);
        map3.put("map3Key44", false);
        map4.put("map4Key44", Float.valueOf(44.0f));
        map5.put("map5Key44", DateUtils.addHours((Date)new Date(), (int)4));
        this.updateEntityMapAttributes(attrEntity, (Map<String, String>)map1, (Map<String, Integer>)map2, (Map<String, Boolean>)map3, (Map<String, Float>)map4, (Map<String, Date>)map5);
        attrEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(attrEntity);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(attrEntitiesInfo), false);
        updatedAttrEntity = response.getFirstUpdatedEntityByTypeName("map_entity_type");
        updatedFromStore = this.getEntityFromStore(updatedAttrEntity);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)attrEntitiesInfo, updatedFromStore);
        map1.remove("map1Key11");
        map2.remove("map2Key11");
        map3.remove("map3Key11");
        map4.remove("map4Key11");
        map5.remove("map5Key11");
        this.updateEntityMapAttributes(attrEntity, (Map<String, String>)map1, (Map<String, Integer>)map2, (Map<String, Boolean>)map3, (Map<String, Float>)map4, (Map<String, Date>)map5);
        attrEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(attrEntity);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(attrEntitiesInfo), false);
        updatedAttrEntity = response.getFirstUpdatedEntityByTypeName("map_entity_type");
        updatedFromStore = this.getEntityFromStore(updatedAttrEntity);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)attrEntitiesInfo, updatedFromStore);
        map1.put("map1Key44", "value44-edit");
        map2.put("map2Key44", 5555);
        map3.put("map3Key44", true);
        map4.put("map4Key44", Float.valueOf(55.5f));
        map5.put("map5Key44", DateUtils.addHours((Date)new Date(), (int)5));
        this.updateEntityMapAttributes(attrEntity, (Map<String, String>)map1, (Map<String, Integer>)map2, (Map<String, Boolean>)map3, (Map<String, Float>)map4, (Map<String, Date>)map5);
        attrEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(attrEntity);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(attrEntitiesInfo), false);
        updatedAttrEntity = response.getFirstUpdatedEntityByTypeName("map_entity_type");
        updatedFromStore = this.getEntityFromStore(updatedAttrEntity);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)attrEntitiesInfo, updatedFromStore);
        map1.clear();
        map2.clear();
        map3.clear();
        map4.clear();
        map5.clear();
        this.updateEntityMapAttributes(attrEntity, (Map<String, String>)map1, (Map<String, Integer>)map2, (Map<String, Boolean>)map3, (Map<String, Float>)map4, (Map<String, Date>)map5);
        attrEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(attrEntity);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(attrEntitiesInfo), false);
        updatedAttrEntity = response.getFirstUpdatedEntityByTypeName("map_entity_type");
        updatedFromStore = this.getEntityFromStore(updatedAttrEntity);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)attrEntitiesInfo, updatedFromStore);
    }

    private void updateEntityMapAttributes(AtlasEntity attrEntity, Map<String, String> map1, Map<String, Integer> map2, Map<String, Boolean> map3, Map<String, Float> map4, Map<String, Date> map5) {
        attrEntity.setAttribute("mapAttr1", map1);
        attrEntity.setAttribute("mapAttr2", map2);
        attrEntity.setAttribute("mapAttr3", map3);
        attrEntity.setAttribute("mapAttr4", map4);
        attrEntity.setAttribute("mapAttr5", map5);
    }

    @Test
    public void testArrayAttribute() throws Exception {
        this.init();
        AtlasEntity.AtlasEntityWithExtInfo simpleEntity = TestUtilsV2.createSimpleAttrTypeEntity();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(simpleEntity), false);
        AtlasEntityHeader simpleEntityHeader = response.getFirstCreatedEntityByTypeName("entity_with_simple_attr");
        AtlasEntity createdSimpleEntity = this.getEntityFromStore(simpleEntityHeader);
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)simpleEntity, createdSimpleEntity);
        createdSimpleEntity.setAttribute("stringAtrr", null);
        createdSimpleEntity.setAttribute("mapOfStrings", Collections.emptyMap());
        createdSimpleEntity.setAttribute("arrayOfStrings", Collections.emptyList());
        createdSimpleEntity.setAttribute("puArray", Collections.emptyList());
        createdSimpleEntity.setAttribute("puMap", Collections.emptyMap());
        EntityMutationResponse responseUpdated = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(createdSimpleEntity), false);
        AtlasEntityHeader simpleEntityUpdatedHeader = responseUpdated.getFirstUpdatedEntityByTypeName("entity_with_simple_attr");
        AtlasEntity updatedSimpleEntity = this.getEntityFromStore(simpleEntityUpdatedHeader);
        org.testng.Assert.assertNull((Object)updatedSimpleEntity.getAttribute("stringAtrr"));
        org.testng.Assert.assertEquals((Object)updatedSimpleEntity.getAttribute("mapOfStrings"), Collections.emptyMap());
        org.testng.Assert.assertEquals((Object)updatedSimpleEntity.getAttribute("arrayOfStrings"), Collections.emptyList());
        org.testng.Assert.assertEquals((Object)updatedSimpleEntity.getAttribute("puArray"), Collections.emptyList());
        org.testng.Assert.assertEquals((Object)updatedSimpleEntity.getAttribute("puMap"), Collections.emptyMap());
        updatedSimpleEntity.setAttribute("stringAtrr", (Object)"");
        updatedSimpleEntity.setAttribute("mapOfStrings", null);
        updatedSimpleEntity.setAttribute("arrayOfStrings", null);
        updatedSimpleEntity.setAttribute("puArray", null);
        updatedSimpleEntity.setAttribute("puMap", null);
        EntityMutationResponse responseUpdatedAgain = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(updatedSimpleEntity), false);
        AtlasEntityHeader simpleEntityUpdatedAgainHeader = responseUpdatedAgain.getFirstUpdatedEntityByTypeName("entity_with_simple_attr");
        AtlasEntity updatedAgainSimpleEntity = this.getEntityFromStore(simpleEntityUpdatedAgainHeader);
        org.testng.Assert.assertEquals((Object)updatedAgainSimpleEntity.getAttribute("stringAtrr"), (Object)"");
        org.testng.Assert.assertNull((Object)updatedAgainSimpleEntity.getAttribute("arrayOfStrings"));
        org.testng.Assert.assertNull((Object)updatedAgainSimpleEntity.getAttribute("mapOfStrings"));
        org.testng.Assert.assertNull((Object)updatedAgainSimpleEntity.getAttribute("puArray"));
        org.testng.Assert.assertNull((Object)updatedAgainSimpleEntity.getAttribute("puMap"));
        updatedAgainSimpleEntity.setAttribute("stringAtrr", (Object)"Dummy String Test 3");
        updatedAgainSimpleEntity.setAttribute("mapOfStrings", Collections.singletonMap("key1", "val1"));
        updatedAgainSimpleEntity.setAttribute("arrayOfStrings", Arrays.asList("DummyTest3", "DummyTest4"));
        updatedAgainSimpleEntity.setAttribute("puArray", Arrays.asList("1"));
        updatedAgainSimpleEntity.setAttribute("puMap", Collections.singletonMap("1", "1"));
        EntityMutationResponse updateRes = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(updatedAgainSimpleEntity), false);
        AtlasEntityHeader updateHeader = updateRes.getFirstUpdatedEntityByTypeName("entity_with_simple_attr");
        AtlasEntity updateEntity = this.getEntityFromStore(updateHeader);
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("stringAtrr"), (Object)"Dummy String Test 3");
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("arrayOfStrings"), Arrays.asList("DummyTest3", "DummyTest4"));
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("mapOfStrings"), Collections.singletonMap("key1", "val1"));
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("puArray"), Arrays.asList("1"));
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("puMap"), Collections.singletonMap("1", "1"));
        updatedAgainSimpleEntity.setAttribute("stringAtrr", (Object)"Dummy String Test 3");
        updatedAgainSimpleEntity.setAttribute("mapOfStrings", Collections.singletonMap("key1", "val1"));
        updatedAgainSimpleEntity.setAttribute("arrayOfStrings", Arrays.asList("DummyTest3", "DummyTest4"));
        updatedAgainSimpleEntity.setAttribute("puArray", Arrays.asList("10"));
        updatedAgainSimpleEntity.setAttribute("puMap", Collections.singletonMap("10", "10"));
        updateRes = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(updatedAgainSimpleEntity), false);
        updateHeader = updateRes.getFirstUpdatedEntityByTypeName("entity_with_simple_attr");
        updateEntity = this.getEntityFromStore(updateHeader);
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("stringAtrr"), (Object)"Dummy String Test 3");
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("arrayOfStrings"), Arrays.asList("DummyTest3", "DummyTest4"));
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("mapOfStrings"), Collections.singletonMap("key1", "val1"));
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("puArray"), Arrays.asList("10"));
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("puMap"), Collections.singletonMap("10", "10"));
        updatedAgainSimpleEntity.setAttribute("stringAtrr", (Object)"Dummy String Test 3");
        updatedAgainSimpleEntity.setAttribute("mapOfStrings", Collections.singletonMap("key1", "val1"));
        updatedAgainSimpleEntity.setAttribute("arrayOfStrings", Arrays.asList("DummyTest3", "DummyTest4"));
        updatedAgainSimpleEntity.setAttribute("puArray", null);
        updatedAgainSimpleEntity.setAttribute("puMap", null);
        updateRes = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(updatedAgainSimpleEntity), false);
        updateHeader = updateRes.getFirstUpdatedEntityByTypeName("entity_with_simple_attr");
        updateEntity = this.getEntityFromStore(updateHeader);
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("stringAtrr"), (Object)"Dummy String Test 3");
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("arrayOfStrings"), Arrays.asList("DummyTest3", "DummyTest4"));
        org.testng.Assert.assertEquals((Object)updateEntity.getAttribute("mapOfStrings"), Collections.singletonMap("key1", "val1"));
        org.testng.Assert.assertNull((Object)updateEntity.getAttribute("puArray"));
        org.testng.Assert.assertNull((Object)updateEntity.getAttribute("puMap"));
        ArrayList<String> puArray = new ArrayList<String>();
        HashMap<String, String> puMap = new HashMap<String, String>();
        updatedAgainSimpleEntity.getAttributes().clear();
        updatedAgainSimpleEntity.setAttribute("puArray", Collections.singletonList("1"));
        updatedAgainSimpleEntity.setAttribute("puMap", Collections.singletonMap("1", "1"));
        updateRes = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(updatedAgainSimpleEntity), true);
        updateHeader = updateRes.getFirstPartialUpdatedEntityByTypeName("entity_with_simple_attr");
        updateEntity = this.getEntityFromStore(updateHeader);
        puArray.addAll(Collections.singletonList("1"));
        puMap.putAll(Collections.singletonMap("1", "1"));
        Assert.equals((Object)updateEntity.getAttribute("puArray"), puArray);
        Assert.equals((Object)updateEntity.getAttribute("puMap"), puMap);
        updatedAgainSimpleEntity.getAttributes().clear();
        updatedAgainSimpleEntity.setAttribute("puArray", Collections.singletonList("2"));
        updatedAgainSimpleEntity.setAttribute("puMap", Collections.singletonMap("2", "2"));
        updateRes = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(updatedAgainSimpleEntity), true);
        updateHeader = updateRes.getFirstPartialUpdatedEntityByTypeName("entity_with_simple_attr");
        updateEntity = this.getEntityFromStore(updateHeader);
        puArray.addAll(Collections.singletonList("2"));
        puMap.putAll(Collections.singletonMap("2", "2"));
        Assert.equals((Object)updateEntity.getAttribute("puArray"), puArray);
        Assert.equals((Object)updateEntity.getAttribute("puMap"), puMap);
        updatedAgainSimpleEntity.getAttributes().clear();
        updatedAgainSimpleEntity.setAttribute("puArray", null);
        updatedAgainSimpleEntity.setAttribute("puMap", null);
        updateRes = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(updatedAgainSimpleEntity), true);
        updateHeader = updateRes.getFirstPartialUpdatedEntityByTypeName("entity_with_simple_attr");
        updateEntity = this.getEntityFromStore(updateHeader);
        Assert.equals((Object)updateEntity.getAttribute("puArray"), puArray);
        Assert.equals((Object)updateEntity.getAttribute("puMap"), puMap);
        updatedAgainSimpleEntity.getAttributes().clear();
        updatedAgainSimpleEntity.setAttribute("puArray", Collections.emptyList());
        updatedAgainSimpleEntity.setAttribute("puMap", Collections.emptyMap());
        updateRes = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(updatedAgainSimpleEntity), true);
        updateHeader = updateRes.getFirstPartialUpdatedEntityByTypeName("entity_with_simple_attr");
        updateEntity = this.getEntityFromStore(updateHeader);
        Assert.equals((Object)updateEntity.getAttribute("puArray"), puArray);
        Assert.equals((Object)updateEntity.getAttribute("puMap"), puMap);
    }

    @Test(dependsOnMethods={"testCreateComplexAttributeEntity"})
    public void testStructArray() throws Exception {
        this.init();
        AtlasEntity complexEntity = this.getEntityFromStore(this.complexCollectionAttrEntity.getEntity().getGuid());
        AtlasEntity.AtlasEntitiesWithExtInfo complexEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(complexEntity);
        ArrayList<AtlasStruct> structList = new ArrayList<AtlasStruct>(Arrays.asList(new AtlasStruct("struct_type", "name", (Object)"structArray00"), new AtlasStruct("struct_type", "name", (Object)"structArray11"), new AtlasStruct("struct_type", "name", (Object)"structArray22")));
        complexEntity.setAttribute("listOfStructs", structList);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        AtlasEntityHeader updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        structList.add(new AtlasStruct("struct_type", "name", (Object)"structArray33"));
        complexEntity.setAttribute("listOfStructs", structList);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        structList.remove(0);
        complexEntity.setAttribute("listOfStructs", structList);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        ((AtlasStruct)structList.get(0)).setAttribute("name", (Object)"structArray11-edit");
        complexEntity.setAttribute("listOfStructs", structList);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        structList.add(new AtlasStruct("struct_type", "name", (Object)"structArray33"));
        complexEntity.setAttribute("listOfStructs", structList);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        structList.clear();
        complexEntity.setAttribute("listOfStructs", structList);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
    }

    @Test(dependsOnMethods={"testStructArray"})
    public void testEntityArray() throws Exception {
        this.init();
        AtlasEntity complexEntity = this.getEntityFromStore(this.complexCollectionAttrEntity.getEntity().getGuid());
        AtlasEntity.AtlasEntitiesWithExtInfo complexEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(complexEntity);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName("entity_type");
        AtlasEntity e0Array = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray00");
                this.put("isReplicated", true);
            }
        });
        AtlasEntity e1Array = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray11");
                this.put("isReplicated", false);
            }
        });
        AtlasEntity e2Array = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray22");
                this.put("isReplicated", true);
            }
        });
        ArrayList<AtlasObjectId> entityList = new ArrayList<AtlasObjectId>(Arrays.asList(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e0Array), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e1Array), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e2Array)));
        complexEntity.setAttribute("listOfEntities", entityList);
        complexEntitiesInfo.addReferredEntity(e0Array);
        complexEntitiesInfo.addReferredEntity(e1Array);
        complexEntitiesInfo.addReferredEntity(e2Array);
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        AtlasEntityHeader updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        e0Array = this.entityStore.getByUniqueAttributes(entityType, (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray00");
                this.put("isReplicated", true);
            }
        }).getEntity();
        e1Array = this.entityStore.getByUniqueAttributes(entityType, (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray11");
                this.put("isReplicated", false);
            }
        }).getEntity();
        e2Array = this.entityStore.getByUniqueAttributes(entityType, (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray22");
                this.put("isReplicated", true);
            }
        }).getEntity();
        AtlasEntity e3Array = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray33");
                this.put("isReplicated", true);
            }
        });
        entityList = new ArrayList<AtlasObjectId>(Arrays.asList(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e0Array), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e1Array), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e2Array), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e3Array)));
        complexEntity.setAttribute("listOfEntities", entityList);
        complexEntitiesInfo.getReferredEntities().clear();
        complexEntitiesInfo.addReferredEntity(e3Array);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        e3Array = this.entityStore.getByUniqueAttributes(entityType, (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray33");
                this.put("isReplicated", true);
            }
        }).getEntity();
        entityList = new ArrayList<AtlasObjectId>(Arrays.asList(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e1Array), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e2Array), AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e3Array)));
        complexEntity.setAttribute("listOfEntities", entityList);
        complexEntitiesInfo.getReferredEntities().clear();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        e1Array.setAttribute("name", (Object)"entityArray11-edit");
        complexEntity.setAttribute("listOfEntities", entityList);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        AtlasEntity e3Array_duplicate = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityArray33");
                this.put("isReplicated", true);
            }
        });
        entityList.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e3Array_duplicate));
        complexEntity.setAttribute("listOfEntities", entityList);
        complexEntitiesInfo.getReferredEntities().clear();
        complexEntitiesInfo.addReferredEntity(e3Array_duplicate);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        entityList.clear();
        complexEntity.setAttribute("listOfEntities", entityList);
        complexEntitiesInfo.getReferredEntities().clear();
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
    }

    @Test(dependsOnMethods={"testEntityArray"})
    public void testStructMap() throws Exception {
        this.init();
        AtlasEntity complexEntity = this.getEntityFromStore(this.complexCollectionAttrEntity.getEntity().getGuid());
        AtlasEntity.AtlasEntitiesWithExtInfo complexEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(complexEntity);
        HashMap<String, AtlasStruct> structMap = new HashMap<String, AtlasStruct>(){
            {
                this.put("key00", new AtlasStruct("struct_type", "name", (Object)"structMap00"));
                this.put("key11", new AtlasStruct("struct_type", "name", (Object)"structMap11"));
                this.put("key22", new AtlasStruct("struct_type", "name", (Object)"structMap22"));
            }
        };
        complexEntity.setAttribute("mapOfStructs", (Object)structMap);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        AtlasEntityHeader updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        structMap.put("key33", new AtlasStruct("struct_type", "name", (Object)"structMap33"));
        complexEntity.setAttribute("mapOfStructs", (Object)structMap);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        structMap.remove("key00");
        complexEntity.setAttribute("mapOfStructs", (Object)structMap);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        ((AtlasStruct)structMap.get("key11")).setAttribute("name", (Object)"structMap11-edit");
        complexEntity.setAttribute("mapOfStructs", (Object)structMap);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        structMap.put("key33", new AtlasStruct("struct_type", "name", (Object)"structMap33"));
        complexEntity.setAttribute("mapOfStructs", (Object)structMap);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        org.testng.Assert.assertNull((Object)updatedComplexEntity);
        this.init();
        structMap.clear();
        complexEntity.setAttribute("mapOfStructs", (Object)structMap);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
    }

    @Test(dependsOnMethods={"testStructMap"})
    public void testEntityMap() throws Exception {
        this.init();
        AtlasEntity complexEntity = this.getEntityFromStore(this.complexCollectionAttrEntity.getEntity().getGuid());
        AtlasEntity.AtlasEntitiesWithExtInfo complexEntitiesInfo = new AtlasEntity.AtlasEntitiesWithExtInfo(complexEntity);
        final AtlasEntity e0MapValue = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityMapValue00");
                this.put("isReplicated", false);
            }
        });
        final AtlasEntity e1MapValue = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityMapValue11");
                this.put("isReplicated", true);
            }
        });
        final AtlasEntity e2MapValue = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityMapValue22");
                this.put("isReplicated", false);
            }
        });
        HashMap<String, Object> entityMap = new HashMap<String, Object>(){
            {
                this.put("key00", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e0MapValue));
                this.put("key11", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e1MapValue));
                this.put("key22", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e2MapValue));
            }
        };
        complexEntity.setAttribute("mapOfEntities", (Object)entityMap);
        complexEntitiesInfo.addReferredEntity(e0MapValue);
        complexEntitiesInfo.addReferredEntity(e1MapValue);
        complexEntitiesInfo.addReferredEntity(e2MapValue);
        this.init();
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        AtlasEntityHeader updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        AtlasEntity e3MapValue = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityMapValue33");
                this.put("isReplicated", false);
            }
        });
        entityMap.put("key33", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e3MapValue));
        complexEntity.setAttribute("mapOfEntities", (Object)entityMap);
        complexEntitiesInfo.addReferredEntity(e3MapValue);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        entityMap.remove("key00");
        complexEntity.setAttribute("mapOfEntities", (Object)entityMap);
        complexEntitiesInfo.addReferredEntity(e3MapValue);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        AtlasEntity e1MapValueEdit = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityMapValue11-edit");
                this.put("isReplicated", false);
            }
        });
        entityMap.clear();
        entityMap.put("key11", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e1MapValueEdit));
        entityMap.put("key22", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e2MapValue));
        entityMap.put("key33", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e3MapValue));
        complexEntity.setAttribute("mapOfEntities", (Object)entityMap);
        complexEntitiesInfo.addReferredEntity(e1MapValueEdit);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        e3MapValue = new AtlasEntity("entity_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "entityMapValue33");
                this.put("isReplicated", false);
            }
        });
        entityMap.put("key33", AtlasTypeUtil.getAtlasObjectId((AtlasEntity)e3MapValue));
        complexEntity.setAttribute("mapOfEntities", (Object)entityMap);
        complexEntitiesInfo.addReferredEntity(e3MapValue);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
        this.init();
        entityMap.clear();
        complexEntity.setAttribute("mapOfEntities", (Object)entityMap);
        complexEntitiesInfo.addReferredEntity(e3MapValue);
        response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(complexEntitiesInfo), false);
        updatedComplexEntity = response.getFirstUpdatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)complexEntitiesInfo, this.getEntityFromStore(updatedComplexEntity));
    }

    @Test(dependsOnMethods={"testEntityMap"})
    public void testDeleteEntityRemoveReferences() throws Exception {
        AtlasEntity entity;
        this.init();
        this.complexCollectionAttrEntityForDelete.getEntity().setAttribute("name", (Object)"entity_with_complex_collection_attr_delete");
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(this.complexCollectionAttrEntityForDelete), false);
        AtlasEntityHeader entityCreated = response.getFirstCreatedEntityByTypeName("entity_with_complex_collection_attr");
        this.validateEntity((AtlasEntity.AtlasEntityExtInfo)this.complexCollectionAttrEntityForDelete, this.getEntityFromStore(entityCreated));
        response = this.entityStore.deleteById(entityCreated.getGuid());
        AtlasEntityHeader entityDeleted = response.getFirstDeletedEntityByTypeName("entity_with_complex_collection_attr");
        GraphTransactionInterceptor.clearCache();
        AtlasEntity.AtlasEntityWithExtInfo deletedEntityWithExtInfo = this.entityStore.getById(entityDeleted.getGuid());
        AtlasVertex deletedEntityVertex = AtlasGraphUtilsV2.findByGuid((String)entityDeleted.getGuid());
        Iterator edges = deletedEntityVertex.getEdges(AtlasEdgeDirection.OUT).iterator();
        while (edges != null && edges.hasNext()) {
            org.testng.Assert.assertEquals((Object)GraphHelper.getStatus((AtlasEdge)((AtlasEdge)edges.next())), (Object)AtlasEntity.Status.DELETED);
        }
        AtlasEntity deletedEntity = deletedEntityWithExtInfo.getEntity();
        List listOfEntities = (List)deletedEntity.getAttribute("listOfEntities");
        Map mapOfEntities = (Map)deletedEntity.getAttribute("mapOfEntities");
        for (AtlasObjectId o : listOfEntities) {
            entity = deletedEntityWithExtInfo.getEntity(o.getGuid());
            org.testng.Assert.assertEquals((Object)entity.getStatus(), (Object)AtlasEntity.Status.DELETED);
        }
        for (AtlasObjectId o : mapOfEntities.values()) {
            entity = deletedEntityWithExtInfo.getEntity(o.getGuid());
            org.testng.Assert.assertEquals((Object)entity.getStatus(), (Object)AtlasEntity.Status.DELETED);
        }
    }
}

