/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasClassificationDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasClassificationDefStoreV2Test {
    private AtlasClassificationDefStoreV2 classificationDefStore;
    @Inject
    AtlasTypeRegistry atlasTypeRegistry;
    @Inject
    AtlasTypeDefGraphStoreV2 typeDefStore;

    @BeforeClass
    public void setUp() {
        this.classificationDefStore = new AtlasClassificationDefStoreV2(this.typeDefStore, this.atlasTypeRegistry);
    }

    @DataProvider
    public Object[][] traitRegexString() {
        return new Object[][]{{"test1", true}, {"\u597d", true}, {"\u597d\u597d", true}, {"\u597d \u597d", true}, {"\u597d_\u597d", true}, {"\u597d.\u597d", true}, {"class1.attr1", true}, {"1test", false}, {"_test1", false}};
    }

    @Test(dataProvider="traitRegexString")
    public void testIsValidName(String data, boolean expected) {
        Assert.assertEquals((boolean)this.classificationDefStore.isValidName(data), (boolean)expected);
    }

    @Test
    public void testDeleteReferencedTraitFail() {
        AtlasVertex typeVertex = (AtlasVertex)Mockito.mock(AtlasVertex.class);
        Mockito.when((Object)((String)typeVertex.getProperty(Constants.TYPENAME_PROPERTY_KEY, String.class))).thenReturn((Object)"Tag11");
        Mockito.when((Object)typeVertex.getEdges(AtlasEdgeDirection.IN)).thenReturn(() -> {
            ArrayList<AtlasEdge> list = new ArrayList<AtlasEdge>();
            list.add((AtlasEdge)Mockito.mock(AtlasEdge.class));
            return list.iterator();
        });
        try {
            this.classificationDefStore.deleteByName("Tag11", typeVertex);
        }
        catch (AtlasBaseException abe) {
            Assert.assertEquals((String)abe.getMessage(), (String)AtlasErrorCode.TYPE_HAS_REFERENCES.getFormattedErrorMessage(new String[]{"Tag11"}));
            Assert.assertEquals((Object)abe.getAtlasErrorCode(), (Object)AtlasErrorCode.TYPE_HAS_REFERENCES);
        }
    }
}

