/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v1;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.DeleteType;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class SoftReferenceTest {
    private static final String TYPE_RDBMS_DB = "rdbms_db";
    private static final String RDBMS_DB_FILE = "rdbms-db";
    private static final String TYPE_RDBMS_STORAGE = "rdbms_storage";
    private static final String TYPESDEF_FILE_NAME = "typesDef-soft-ref";
    private static final String RDBMS_DB_STORAGE_PROPERTY = "sd";
    private static final String RDBMS_DB_TABLES_PROPERTY = "tables";
    private static final String RDBMS_DB_REGIONS_PROPERTY = "regions";
    private static final String RDBMS_SD_PROPERTY = "rdbms_db.sd";
    private static final String TYPE_RDBMS_TABLES = "rdbms_table";
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasEntityStore entityStore;
    private AtlasType dbType;
    private String dbGuid;
    private String storageGuid;

    @BeforeMethod
    public void init() throws Exception {
        RequestContext.get().setUser("testUser", null);
        RequestContext.get().setDeleteType(DeleteType.SOFT);
    }

    @Test
    public void typeCreationFromFile() throws IOException, AtlasBaseException {
        String typesDefJson = TestResourceFileUtils.getJson(TYPESDEF_FILE_NAME);
        AtlasTypesDef typesDef = (AtlasTypesDef)AtlasType.fromJson((String)typesDefJson, AtlasTypesDef.class);
        Assert.assertNotNull((Object)typesDef);
        this.typeDefStore.createTypesDef(typesDef);
        this.dbType = this.typeRegistry.getType(TYPE_RDBMS_DB);
        Assert.assertNotNull((Object)this.dbType);
        AtlasEntityDef dbType = this.typeRegistry.getEntityDefByName(TYPE_RDBMS_DB);
        Assert.assertNotNull((Object)dbType);
        Assert.assertTrue((boolean)dbType.getAttribute(RDBMS_DB_STORAGE_PROPERTY).isSoftReferenced());
        Assert.assertTrue((boolean)dbType.getAttribute(RDBMS_DB_TABLES_PROPERTY).isSoftReferenced());
        Assert.assertTrue((boolean)dbType.getAttribute(RDBMS_DB_REGIONS_PROPERTY).isSoftReferenced());
        Assert.assertNotNull((Object)this.typeRegistry.getEntityDefByName(TYPE_RDBMS_STORAGE));
        Assert.assertNotNull((Object)this.typeRegistry.getEntityDefByName(TYPE_RDBMS_TABLES));
    }

    @Test(dependsOnMethods={"typeCreationFromFile"})
    public void entityCreationUsingSoftRef() throws IOException, AtlasBaseException {
        int EXPECTED_ENTITY_COUNT = 6;
        AtlasEntity.AtlasEntityWithExtInfo dbEntity = (AtlasEntity.AtlasEntityWithExtInfo)AtlasType.fromJson((String)TestResourceFileUtils.getJson(RDBMS_DB_FILE), AtlasEntity.AtlasEntityWithExtInfo.class);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(dbEntity), false);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((response.getCreatedEntities().size() == 6 ? 1 : 0) != 0);
        this.assertGraphStructure(((AtlasEntityHeader)response.getCreatedEntities().get(0)).getGuid(), ((AtlasEntityHeader)response.getCreatedEntities().get(1)).getGuid(), RDBMS_SD_PROPERTY);
        this.dbGuid = ((AtlasEntityHeader)response.getCreatedEntities().get(0)).getGuid();
        this.storageGuid = ((AtlasEntityHeader)response.getCreatedEntities().get(1)).getGuid();
    }

    @Test(dependsOnMethods={"entityCreationUsingSoftRef"})
    public void deletetingCollections() throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getById(this.dbGuid);
        Assert.assertNotNull((Object)entityWithExtInfo);
        List list = (List)entityWithExtInfo.getEntity().getAttribute(RDBMS_DB_TABLES_PROPERTY);
        list.remove(1);
        Map map = (Map)entityWithExtInfo.getEntity().getAttribute(RDBMS_DB_REGIONS_PROPERTY);
        map.remove("east");
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entityWithExtInfo), true);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((response.getPartialUpdatedEntities().size() > 0 ? 1 : 0) != 0);
        this.assertAttribute(this.dbGuid, this.storageGuid, 1, 1);
    }

    @Test(dependsOnMethods={"deletetingCollections"})
    public void addingCollections() throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getById(this.dbGuid);
        Assert.assertNotNull((Object)entityWithExtInfo);
        this.addNewTables(entityWithExtInfo);
        this.addNewRegions(entityWithExtInfo);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(entityWithExtInfo), true);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((response.getPartialUpdatedEntities().size() > 0 ? 1 : 0) != 0);
        this.assertAttribute(this.dbGuid, this.storageGuid, 3, 3);
    }

    private void addNewRegions(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) throws AtlasBaseException {
        Map map = (Map)entityWithExtInfo.getEntity().getAttribute(RDBMS_DB_REGIONS_PROPERTY);
        AtlasEntity region1 = this.getDefaultTableEntity("r1");
        AtlasEntity region2 = this.getDefaultTableEntity("r2");
        map.put("north", new AtlasObjectId(region1.getGuid(), region1.getTypeName()));
        map.put("south", new AtlasObjectId(region2.getGuid(), region2.getTypeName()));
        entityWithExtInfo.addReferredEntity(region1);
        entityWithExtInfo.addReferredEntity(region2);
    }

    private void addNewTables(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) throws AtlasBaseException {
        List list = (List)entityWithExtInfo.getEntity().getAttribute(RDBMS_DB_TABLES_PROPERTY);
        AtlasEntity table1 = this.getDefaultTableEntity("newTable-1");
        AtlasEntity table2 = this.getDefaultTableEntity("newTable-2");
        entityWithExtInfo.addReferredEntity(table1);
        entityWithExtInfo.addReferredEntity(table2);
        list.add(new AtlasObjectId(table1.getGuid(), table1.getTypeName()));
        list.add(new AtlasObjectId(table2.getGuid(), table2.getTypeName()));
    }

    private AtlasEntity getDefaultTableEntity(String name) throws AtlasBaseException {
        AtlasEntityType type = (AtlasEntityType)this.typeRegistry.getType(TYPE_RDBMS_TABLES);
        AtlasEntity ret = type.createDefaultValue();
        ret.setAttribute("name", (Object)name);
        return ret;
    }

    private void assertGraphStructure(String dbGuid, String storageGuid, String propertyName) throws AtlasBaseException {
        AtlasVertex vertex = AtlasGraphUtilsV2.findByGuid((String)dbGuid);
        Iterator edgesOut = vertex.getEdges(AtlasEdgeDirection.OUT).iterator();
        Iterator edgesIn = vertex.getEdges(AtlasEdgeDirection.IN).iterator();
        String sd = (String)AtlasGraphUtilsV2.getProperty((AtlasElement)vertex, (String)propertyName, String.class);
        Assert.assertNotNull((Object)sd);
        this.assertAttribute(dbGuid, storageGuid, 2, 2);
        Assert.assertFalse((boolean)edgesOut.hasNext());
        Assert.assertFalse((boolean)edgesIn.hasNext());
        Assert.assertNotNull((Object)vertex);
    }

    private void assertAttribute(String dbGuid, String storageGuid, int expectedTableCount, int expectedRegionCount) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getById(dbGuid);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Object val = entity.getAttribute(RDBMS_DB_STORAGE_PROPERTY);
        Assert.assertTrue((boolean)(val instanceof AtlasObjectId));
        Assert.assertEquals((String)((AtlasObjectId)val).getTypeName(), (String)TYPE_RDBMS_STORAGE);
        Assert.assertEquals((String)((AtlasObjectId)val).getGuid(), (String)storageGuid);
        Assert.assertNotNull((Object)entity.getAttribute(RDBMS_DB_TABLES_PROPERTY));
        Assert.assertEquals((int)((List)entity.getAttribute(RDBMS_DB_TABLES_PROPERTY)).size(), (int)expectedTableCount);
        Assert.assertNotNull((Object)entity.getAttribute(RDBMS_DB_REGIONS_PROPERTY));
        Assert.assertEquals((int)((Map)entity.getAttribute(RDBMS_DB_REGIONS_PROPERTY)).size(), (int)expectedRegionCount);
    }
}

