/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.repository.graphdb.janus.migration.RelationshipCacheGenerator;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class RelationshipCacheGeneratorTest {
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasTypeRegistry typeRegistry;

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("0000-Area0/0010-base_model.json", this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1030-hive_model.json", this.typeDefStore, this.typeRegistry);
    }

    @Test
    public void createLookup() {
        String PROCESS_INPUT_KEY = "__Process.inputs";
        String PROCESS_OUTPUT_KEY = "__Process.outputs";
        Map cache = RelationshipCacheGenerator.get((AtlasTypeRegistry)this.typeRegistry);
        Assert.assertEquals((int)cache.size(), (int)(this.getLegacyAttributeCount() - 1));
        for (Map.Entry entry : cache.entrySet()) {
            Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)((String)entry.getKey())));
            Assert.assertTrue((boolean)((String)entry.getKey()).startsWith("__"), (String)((String)entry.getKey()));
        }
        Assert.assertEquals((String)((RelationshipCacheGenerator.TypeInfo)cache.get("__Process.inputs")).getTypeName(), (String)"dataset_process_inputs");
        Assert.assertEquals((Object)((RelationshipCacheGenerator.TypeInfo)cache.get("__Process.inputs")).getPropagateTags(), (Object)AtlasRelationshipDef.PropagateTags.TWO_TO_ONE);
        Assert.assertEquals((String)((RelationshipCacheGenerator.TypeInfo)cache.get("__Process.outputs")).getTypeName(), (String)"process_dataset_outputs");
        Assert.assertEquals((Object)((RelationshipCacheGenerator.TypeInfo)cache.get("__Process.outputs")).getPropagateTags(), (Object)AtlasRelationshipDef.PropagateTags.ONE_TO_TWO);
    }

    private int getLegacyAttributeCount() {
        int count = 0;
        for (AtlasRelationshipType rt : this.typeRegistry.getAllRelationshipTypes()) {
            AtlasRelationshipDef rd = rt.getRelationshipDef();
            if (rd.getEndDef1().getIsLegacyAttribute()) {
                ++count;
            }
            if (!rd.getEndDef2().getIsLegacyAttribute()) continue;
            ++count;
        }
        return count;
    }
}

