/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import com.google.inject.Inject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.migration.MigrationBaseAsserts;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class PathTest
extends MigrationBaseAsserts {
    @Inject
    public PathTest(AtlasGraph graph, GraphDBMigrator migrator) {
        super(graph, migrator);
    }

    @Test
    public void migrationImport() throws IOException, AtlasBaseException {
        int EXPECTED_TOTAL_COUNT = 92;
        this.runFileImporter("path_db");
        AtlasVertex v = this.assertHdfsPathVertices(1);
        this.assertVertexProperties(v);
        this.assertMigrationStatus(92);
    }

    private void assertVertexProperties(AtlasVertex v) {
        String HASH_CODE_PROPERTY = "hdfs_path.hashCode";
        String RETENTION_PROPERTY = "hdfs_path.retention";
        AtlasBuiltInTypes.AtlasBigIntegerType bitRef = new AtlasBuiltInTypes.AtlasBigIntegerType();
        AtlasBuiltInTypes.AtlasBigDecimalType bdtRef = new AtlasBuiltInTypes.AtlasBigDecimalType();
        BigInteger bitExpected = bitRef.getNormalizedValue((Object)612361213421234L);
        BigDecimal bdtExpected = bdtRef.getNormalizedValue((Object)125353);
        BigInteger bit = (BigInteger)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)v, (String)"hdfs_path.hashCode", BigInteger.class);
        BigDecimal bdt = (BigDecimal)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)v, (String)"hdfs_path.retention", BigDecimal.class);
        Assert.assertEquals((Object)bit, (Object)bitExpected);
        Assert.assertEquals((int)bdt.compareTo(bdtExpected), (int)0);
    }

    protected AtlasVertex assertHdfsPathVertices(int expectedCount) {
        Iterator<AtlasVertex> results;
        int i = 0;
        AtlasVertex vertex = null;
        Iterator<AtlasVertex> it = results = this.getVertices("hdfs_path", null);
        while (it.hasNext()) {
            vertex = it.next();
            Assert.assertNotNull((Object)vertex);
            ++i;
        }
        Assert.assertEquals((int)i, (int)expectedCount);
        return vertex;
    }
}

