/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import org.apache.atlas.model.impexp.MigrationStatus;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.graphdb.janus.migration.ReaderStatusManager;
import org.apache.atlas.repository.impexp.MigrationProgressService;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MigrationProgressServiceTest {
    private final long currentIndex = 100L;
    private final long totalIndex = 1000L;
    private final long increment = 1001L;
    private final String statusSuccess = "SUCCESS";

    private GraphDBMigrator createMigrator(TinkerGraph tg) {
        GraphDBMigrator gdm = (GraphDBMigrator)Mockito.mock(GraphDBMigrator.class);
        Mockito.when((Object)gdm.getMigrationStatus()).thenAnswer(invocation -> ReaderStatusManager.get((Graph)tg));
        return gdm;
    }

    @Test
    public void absentStatusNodeReturnsDefaultStatus() {
        MigrationProgressService mps = this.getMigrationStatusForTest(null, null);
        MigrationStatus ms = mps.getStatus();
        Assert.assertNotNull((Object)ms);
        Assert.assertTrue((boolean)StringUtils.isEmpty((String)ms.getOperationStatus()));
        Assert.assertEquals((long)ms.getCurrentIndex(), (long)0L);
        Assert.assertEquals((long)ms.getTotalCount(), (long)0L);
    }

    @Test
    public void existingStatusNodeRetrurnStatus() {
        long currentIndex = 100L;
        long totalIndex = 1000L;
        String status = "SUCCESS";
        TinkerGraph tg = this.createUpdateStatusNode(null, 100L, 1000L, "SUCCESS");
        MigrationProgressService mps = this.getMigrationStatusForTest(null, tg);
        MigrationStatus ms = mps.getStatus();
        this.assertMigrationStatus(1000L, "SUCCESS", ms);
    }

    @Test
    public void cachedStatusReturnedIfQueriedBeforeCacheExpiration() {
        TinkerGraph tg = this.createUpdateStatusNode(null, 100L, 1000L, "SUCCESS");
        MigrationProgressService mps = this.getMigrationStatusForTest(null, tg);
        MigrationStatus ms = mps.getStatus();
        this.createUpdateStatusNode(tg, 1101L, 2001L, "FAILED");
        MigrationStatus ms2 = mps.getStatus();
        Assert.assertEquals((int)ms.hashCode(), (int)ms2.hashCode());
        this.assertMigrationStatus(1000L, "SUCCESS", ms);
    }

    private MigrationProgressService getMigrationStatusForTest(Configuration cfg, TinkerGraph tg) {
        return new MigrationProgressService(cfg, this.createMigrator(tg));
    }

    @Test
    public void cachedUpdatedIfQueriedAfterCacheExpiration() throws InterruptedException {
        String statusFailed = "FAILED";
        TinkerGraph tg = this.createUpdateStatusNode(null, 100L, 1000L, "SUCCESS");
        long cacheTTl = 100L;
        MigrationProgressService mps = this.getMigrationStatusForTest(this.getStubConfiguration(cacheTTl), tg);
        MigrationStatus ms = mps.getStatus();
        this.assertMigrationStatus(1000L, "SUCCESS", ms);
        this.createUpdateStatusNode(tg, 1101L, 2001L, "FAILED");
        Thread.sleep(2L * cacheTTl);
        MigrationStatus ms2 = mps.getStatus();
        Assert.assertNotEquals((Object)ms.hashCode(), (Object)ms2.hashCode());
        this.assertMigrationStatus(2001L, "FAILED", ms2);
    }

    private Configuration getStubConfiguration(long ttl) {
        Configuration cfg = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)cfg.getLong(Matchers.anyString(), Matchers.anyLong())).thenReturn((Object)ttl);
        return cfg;
    }

    private TinkerGraph createUpdateStatusNode(TinkerGraph tg, long currentIndex, long totalIndex, String status) {
        if (tg == null) {
            tg = TinkerGraph.open();
        }
        ReaderStatusManager rsm = new ReaderStatusManager((Graph)tg, (Graph)tg);
        rsm.update((Graph)tg, Long.valueOf(currentIndex), false);
        rsm.end((Graph)tg, Long.valueOf(totalIndex), status);
        return tg;
    }

    private void assertMigrationStatus(long totalIndex, String status, MigrationStatus ms) {
        Assert.assertNotNull((Object)ms);
        Assert.assertEquals((String)ms.getOperationStatus(), (String)status);
        Assert.assertEquals((long)ms.getCurrentIndex(), (long)totalIndex);
        Assert.assertEquals((long)ms.getTotalCount(), (long)totalIndex);
    }
}

