/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Iterator;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.migration.DataMigrationService;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class MigrationBaseAsserts
extends AtlasTestBase {
    private static final String TYPE_NAME_PROPERTY = "__typeName";
    private static final String R_GUID_PROPERTY_NAME = "_r__guid";
    protected static final String ASSERT_NAME_PROPERTY = "Asset.name";
    private final GraphDBMigrator migrator;
    private final AtlasGraph graph;
    @Inject
    protected AtlasTypeDefStore typeDefStore;
    @Inject
    protected AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStoreInitializer storeInitializer;
    @Inject
    private GraphBackedSearchIndexer indexer;

    protected MigrationBaseAsserts(AtlasGraph graph, GraphDBMigrator migrator) {
        this.graph = graph;
        this.migrator = migrator;
    }

    @Override
    @BeforeClass
    public void initialize() throws Exception {
        super.initialize();
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    protected void loadTypesFromJson() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("0000-Area0/0010-base_model.json", this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1020-fs_model.json", this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1030-hive_model.json", this.typeDefStore, this.typeRegistry);
    }

    protected void runFileImporter(String directoryToImport) throws IOException, AtlasBaseException {
        this.loadTypesFromJson();
        String directoryName = TestResourceFileUtils.getDirectory(directoryToImport);
        DataMigrationService.FileImporter fi = new DataMigrationService.FileImporter(this.migrator, this.typeDefStore, this.typeRegistry, this.storeInitializer, directoryName, this.indexer);
        fi.run();
    }

    protected void assertHiveVertices(int dbCount, int tableCount, int columnCount) {
        Iterator<AtlasVertex> results;
        int i = 0;
        Iterator<AtlasVertex> it = results = this.getVertices("hive_db", null);
        while (it.hasNext()) {
            Assert.assertNotNull((Object)it.next());
            ++i;
        }
        Assert.assertEquals((int)i, (int)dbCount);
        i = 0;
        it = results = this.getVertices("hive_table", null);
        while (it.hasNext()) {
            Assert.assertNotNull((Object)it.next());
            ++i;
        }
        Assert.assertEquals((int)i, (int)tableCount);
        i = 0;
        it = results = this.getVertices("hive_column", null);
        while (it.hasNext()) {
            Assert.assertNotNull((Object)it.next());
            ++i;
        }
        Assert.assertTrue((i > 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)i, (int)columnCount);
    }

    protected Iterator<AtlasVertex> getVertices(String typeName, String name) {
        AtlasGraphQuery query = this.graph.query().has(TYPE_NAME_PROPERTY, (Object)typeName);
        if (!StringUtils.isEmpty((String)name)) {
            query = query.has(ASSERT_NAME_PROPERTY, (Object)name);
        }
        return query.vertices().iterator();
    }

    protected AtlasVertex getVertex(String typeName, String name) {
        Iterator<AtlasVertex> iterator = this.getVertices(typeName, name);
        return iterator.hasNext() ? iterator.next() : null;
    }

    protected void assertEdges(String typeName, String assetName, AtlasEdgeDirection edgeDirection, int expectedItems, String edgeTypeName) {
        Iterator<AtlasEdge> edgeIterator = this.getVertex(typeName, assetName).getEdges(edgeDirection).iterator();
        this.assertEdges(edgeIterator, expectedItems, edgeTypeName);
    }

    protected void assertEdges(Iterator<AtlasEdge> results, int expectedItems, String edgeTypeNameExpected) {
        int count = 0;
        AtlasEdge e = null;
        boolean searchedEdgeFound = false;
        Iterator<AtlasEdge> it = results;
        while (it.hasNext()) {
            e = it.next();
            String typeName = (String)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)e, (String)TYPE_NAME_PROPERTY, String.class);
            searchedEdgeFound = StringUtils.isEmpty((String)edgeTypeNameExpected) || typeName.equals(edgeTypeNameExpected);
            if (!searchedEdgeFound) continue;
            ++count;
            break;
        }
        Assert.assertNotNull((Object)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)e, (String)R_GUID_PROPERTY_NAME, Object.class));
        Assert.assertNotNull((Object)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)e, (String)"tagPropagation", Object.class));
        if (StringUtils.isNotEmpty((String)edgeTypeNameExpected)) {
            Assert.assertTrue((boolean)searchedEdgeFound, (String)edgeTypeNameExpected);
        }
        Assert.assertEquals((int)count, (int)expectedItems, (String)String.format("%s", edgeTypeNameExpected));
    }

    protected void assertEdgesWithLabel(Iterator<AtlasEdge> results, int startIdx, String edgeTypeName) {
        AtlasEdge e = null;
        Iterator<AtlasEdge> it = results;
        for (int count = 0; it.hasNext() && count < startIdx; ++count) {
            e = it.next();
        }
        Assert.assertNotNull((Object)AtlasGraphUtilsV2.getEncodedProperty(e, (String)R_GUID_PROPERTY_NAME, Object.class));
        Assert.assertNotNull((Object)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)e, (String)"tagPropagation", Object.class));
        if (StringUtils.isNotEmpty((String)edgeTypeName)) {
            Assert.assertEquals((String)e.getLabel(), (String)edgeTypeName, (String)edgeTypeName);
        }
    }

    protected void assertTypeCountNameGuid(String typeName, int expectedItems, String name, String guid) {
        Iterator<AtlasVertex> results = this.getVertices(typeName, name);
        int count = 0;
        Iterator<AtlasVertex> it = results;
        while (it.hasNext()) {
            AtlasVertex v = it.next();
            Assert.assertEquals((String)GraphHelper.getTypeName((AtlasElement)v), (String)typeName);
            if (StringUtils.isNotEmpty((String)guid)) {
                Assert.assertEquals((String)GraphHelper.getGuid((AtlasVertex)v), (String)guid, (String)name);
            }
            if (StringUtils.isNotEmpty((String)name)) {
                Assert.assertEquals((String)((String)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)v, (String)ASSERT_NAME_PROPERTY, String.class)), (String)name, (String)name);
            }
            ++count;
        }
        Assert.assertEquals((int)count, (int)expectedItems, (String)String.format("%s:%s", typeName, name));
    }

    protected void assertMigrationStatus(int expectedTotalCount) {
        AtlasVertex v = this.getVertex("__MigrationStatus", "");
        Assert.assertTrue((((Number)AtlasGraphUtilsV2.getEncodedProperty((AtlasElement)v, (String)"currentIndex", Number.class)).intValue() >= expectedTotalCount ? 1 : 0) != 0);
    }
}

