/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.migration.MigrationBaseAsserts;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class HiveStocksTest
extends MigrationBaseAsserts {
    @Inject
    public HiveStocksTest(AtlasGraph graph, GraphDBMigrator migrator) {
        super(graph, migrator);
    }

    @Test
    public void migrateStocks() throws AtlasBaseException, IOException {
        int EXPECTED_TOTAL_COUNT = 191;
        boolean EXPECTED_DB_COUNT = true;
        boolean EXPECTED_TABLE_COUNT = true;
        int EXPECTED_COLUMN_COUNT = 7;
        this.runFileImporter("stocks_db");
        this.assertHiveVertices(1, 1, 7);
        this.assertTypeCountNameGuid("hive_db", 1, "stocks", "4e13b36b-9c54-4616-9001-1058221165d0");
        this.assertTypeCountNameGuid("hive_table", 1, "stocks_daily", "5cfc2540-9947-40e0-8905-367e07481774");
        this.assertTypeCountNameGuid("hive_column", 1, "high", "d72ce4fb-6f17-4e68-aa85-967366c9e891");
        this.assertTypeCountNameGuid("hive_column", 1, "open", "788ba8fe-b7d8-41ba-84ef-c929732924ec");
        this.assertTypeCountNameGuid("hive_column", 1, "dt", "643a0a71-0d97-477d-a43b-7ca433f85160");
        this.assertTypeCountNameGuid("hive_column", 1, "low", "38caeaf7-49e6-4d6d-8727-231406a46821");
        this.assertTypeCountNameGuid("hive_column", 1, "close", "3bae9b76-f812-4745-b4d2-2a72d2773d07");
        this.assertTypeCountNameGuid("hive_column", 1, "volume", "bee376a4-3d8d-4943-b7e8-9bce042c2657");
        this.assertTypeCountNameGuid("hive_column", 1, "adj_close", "fcba2002-cb38-4c2e-b853-68d421d66703");
        this.assertTypeCountNameGuid("hive_process", 0, "", "");
        this.assertTypeCountNameGuid("hive_storagedesc", 1, "", "294290d8-4498-4677-973c-c266d594b039");
        this.assertTypeCountNameGuid("Tag1", 1, "", "");
        this.assertEdges(this.getVertex("hive_db", "stocks").getEdges(AtlasEdgeDirection.IN).iterator(), 1, "");
        this.assertEdges(this.getVertex("hive_table", "stocks_daily").getEdges(AtlasEdgeDirection.OUT).iterator(), 1, "hive_table_db");
        this.assertEdges(this.getVertex("hive_column", "high").getEdges(AtlasEdgeDirection.OUT).iterator(), 1, "hive_table_columns");
        this.assertMigrationStatus(191);
    }
}

