/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipSink;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.impexp.ZipSourceWithBackingDirectory;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.SkipException;

public class ZipFileResourceTestUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ZipFileResourceTestUtils.class);

    public static FileInputStream getFileInputStream(String fileName) {
        return TestResourceFileUtils.getFileInputStream(fileName);
    }

    public static Object[][] getZipSource(String fileName) throws IOException, AtlasBaseException {
        return new Object[][]{{ZipFileResourceTestUtils.getInputStreamFrom(fileName)}};
    }

    public static InputStream getInputStreamFrom(String fileName) {
        return ZipFileResourceTestUtils.getFileInputStream(fileName);
    }

    public static void verifyImportedEntities(List<String> creationOrder, List<String> processedEntities) {
        HashSet lhs = Sets.newHashSet(creationOrder);
        HashSet rhs = Sets.newHashSet(processedEntities);
        Sets.SetView difference = Sets.difference((Set)lhs, (Set)rhs);
        Assert.assertNotNull((Object)difference);
        Assert.assertEquals((int)difference.size(), (int)0);
    }

    public static void verifyImportedMetrics(AtlasExportResult exportResult, AtlasImportResult importResult) {
        Map<String, Integer> metricsForCompare = ZipFileResourceTestUtils.getImportMetricsForCompare(importResult);
        for (Map.Entry entry : exportResult.getMetrics().entrySet()) {
            if (!((String)entry.getKey()).startsWith("entity") || ((String)entry.getKey()).contains("withExtInfo") || ((String)entry.getKey()).contains("Column") || ((String)entry.getKey()).contains("StorageDesc")) continue;
            Assert.assertTrue((boolean)metricsForCompare.containsKey(entry.getKey()), (String)((String)entry.getKey()));
            Assert.assertEquals(entry.getValue(), (Object)metricsForCompare.get(entry.getKey()), (String)((String)entry.getKey()));
        }
    }

    public static InputStream runExportWithParameters(ExportService exportService, AtlasExportRequest request) {
        String requestingIP = "1.0.0.0";
        String hostName = "localhost";
        String userName = "admin";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipSink zipSink = new ZipSink((OutputStream)baos);
            AtlasExportResult result = exportService.run(zipSink, request, "admin", "localhost", "1.0.0.0");
            Assert.assertEquals((Object)result.getOperationStatus(), (Object)AtlasExportResult.OperationStatus.SUCCESS);
            zipSink.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception ex) {
            throw new SkipException(String.format("runExportWithParameters: %s: failed!", request.toString()));
        }
    }

    private static Map<String, Integer> getImportMetricsForCompare(AtlasImportResult result) {
        HashMap<String, Integer> r = new HashMap<String, Integer>();
        for (Map.Entry entry : result.getMetrics().entrySet()) {
            r.put(((String)entry.getKey()).replace(":updated", "").replace(":created", ""), (Integer)entry.getValue());
        }
        return r;
    }

    public static AtlasEntity.AtlasEntityWithExtInfo getEntities(ZipSource source, int expectedCount) {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = new AtlasEntity.AtlasEntityWithExtInfo();
        int count = 0;
        for (String s : source.getCreationOrder()) {
            AtlasEntity entity = source.getByGuid(s);
            entityWithExtInfo.addReferredEntity(s, entity);
            ++count;
        }
        Assert.assertEquals((int)count, (int)expectedCount);
        return entityWithExtInfo;
    }

    public static AtlasImportRequest getDefaultImportRequest() {
        return new AtlasImportRequest();
    }

    public static AtlasImportResult runImportWithParameters(ImportService importService, AtlasImportRequest request, InputStream inputStream) throws AtlasBaseException, IOException {
        String requestingIP = "1.0.0.0";
        String hostName = "localhost";
        String userName = "admin";
        AtlasImportResult result = importService.run(inputStream, request, "admin", "localhost", "1.0.0.0");
        Assert.assertEquals((Object)result.getOperationStatus(), (Object)AtlasImportResult.OperationStatus.SUCCESS);
        return result;
    }

    public static AtlasImportResult runImportWithNoParameters(ImportService importService, InputStream inputStream) throws AtlasBaseException, IOException {
        String requestingIP = "1.0.0.0";
        String hostName = "localhost";
        String userName = "admin";
        AtlasImportResult result = importService.run(inputStream, "admin", "localhost", "1.0.0.0");
        Assert.assertEquals((Object)result.getOperationStatus(), (Object)AtlasImportResult.OperationStatus.SUCCESS);
        return result;
    }

    public static AtlasImportResult runImportWithNoParametersUsingBackingDirectory(ImportService importService, InputStream inputStream) throws AtlasBaseException, IOException {
        String requestingIP = "1.0.0.0";
        String hostName = "localhost";
        String userName = "admin";
        ZipSourceWithBackingDirectory sourceWithBackingDirectory = new ZipSourceWithBackingDirectory(inputStream, Files.createTempDirectory("temp", new FileAttribute[0]).toString());
        AtlasImportResult result = importService.run((EntityImportStream)sourceWithBackingDirectory, new AtlasImportRequest(), "admin", "localhost", "1.0.0.0");
        Assert.assertEquals((Object)result.getOperationStatus(), (Object)AtlasImportResult.OperationStatus.SUCCESS);
        return result;
    }

    public static void runAndVerifyQuickStart_v1_Import(ImportService importService, InputStream is) throws AtlasBaseException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)baos);
        ZipSource zipSource = new ZipSource((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        AtlasExportResult exportResult = zipSource.getExportResult();
        List creationOrder = zipSource.getCreationOrder();
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        AtlasImportRequest request = ZipFileResourceTestUtils.getDefaultImportRequest();
        AtlasImportResult result = ZipFileResourceTestUtils.runImportWithParameters(importService, request, new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertNotNull((Object)result);
        ZipFileResourceTestUtils.verifyImportedMetrics(exportResult, result);
        ZipFileResourceTestUtils.verifyImportedEntities(creationOrder, result.getProcessedEntities());
    }
}

