/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.impexp.AtlasServerService;
import org.apache.atlas.repository.impexp.AuditsWriter;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.apache.commons.io.IOUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ReplicationEntityAttributeTest
extends AtlasTestBase {
    private final String ENTITIES_SUB_DIR = "stocksDB-Entities";
    private final String EXPORT_REQUEST_FILE = "export-replicatedTo";
    private final String IMPORT_REQUEST_FILE = "import-replicatedFrom";
    private String REPLICATED_TO_CLUSTER_NAME = "";
    private String REPLICATED_FROM_CLUSTER_NAME = "";
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private EntityGraphMapper graphMapper;
    @Inject
    ExportService exportService;
    @Inject
    ImportService importService;
    @Inject
    AtlasServerService atlasServerService;
    @Inject
    private AtlasEntityStoreV2 entityStore;
    private InputStream inputStream;

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        this.basicSetup(this.typeDefStore, this.typeRegistry);
        this.createEntities(this.entityStore, "stocksDB-Entities", new String[]{"db", "table-columns"});
        AtlasType refType = this.typeRegistry.getType("Referenceable");
        AtlasEntityDef entityDef = (AtlasEntityDef)this.typeDefStore.getByName(refType.getTypeName());
        Assert.assertNotNull((Object)entityDef);
    }

    @BeforeMethod
    public void setupTest() {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
    }

    @Test
    public void exportWithReplicationToOption_AddsClusterObjectIdToReplicatedFromAttribute() throws AtlasBaseException, IOException {
        int expectedEntityCount = 2;
        AtlasExportRequest request = this.getUpdateMetaInfoUpdateRequest();
        InputStream inputStream = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, request);
        Assert.assertNotNull((Object)inputStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
        this.inputStream = new ByteArrayInputStream(baos.toByteArray());
        ZipSource zipSource = new ZipSource((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertNotNull((Object)zipSource.getCreationOrder());
        Assert.assertEquals((int)zipSource.getCreationOrder().size(), (int)2);
        this.assertCluster(AuditsWriter.getServerNameFromFullName((String)this.REPLICATED_TO_CLUSTER_NAME), this.REPLICATED_TO_CLUSTER_NAME, null);
        this.assertReplicationAttribute("replicatedTo");
    }

    @Test
    public void fullServerName() {
        String expectedClusterName = "cl1";
        Assert.assertEquals((String)AuditsWriter.getServerNameFromFullName((String)""), (String)"");
        Assert.assertEquals((String)AuditsWriter.getServerNameFromFullName((String)"cl1"), (String)"cl1");
        Assert.assertEquals((String)AuditsWriter.getServerNameFromFullName((String)"SFO$cl1"), (String)"cl1");
        Assert.assertEquals((String)AuditsWriter.getServerNameFromFullName((String)"cl1$"), (String)"cl1");
        Assert.assertEquals((String)AuditsWriter.getServerNameFromFullName((String)"$cl1"), (String)"cl1");
    }

    @Test(dependsOnMethods={"exportWithReplicationToOption_AddsClusterObjectIdToReplicatedFromAttribute"})
    public void importWithReplicationFromOption_AddsClusterObjectIdToReplicatedFromAttribute() throws AtlasBaseException, IOException {
        AtlasImportRequest request = this.getImportRequestWithReplicationOption();
        AtlasImportResult importResult = ZipFileResourceTestUtils.runImportWithParameters(this.importService, request, this.inputStream);
        this.assertCluster(AuditsWriter.getServerNameFromFullName((String)this.REPLICATED_FROM_CLUSTER_NAME), this.REPLICATED_FROM_CLUSTER_NAME, importResult);
        this.assertReplicationAttribute("replicatedFrom");
    }

    @Test
    public void replKeyGuidFinder() {
        String expectedDBQualifiedName = "largedb@cl1";
        Assert.assertEquals((String)AuditsWriter.ReplKeyGuidFinder.extractHiveDBQualifiedName((String)"largedb.testtable_0.col101@cl1"), (String)expectedDBQualifiedName);
        Assert.assertEquals((String)AuditsWriter.ReplKeyGuidFinder.extractHiveDBQualifiedName((String)"largedb.testtable_0@cl1"), (String)expectedDBQualifiedName);
    }

    private void assertReplicationAttribute(String attrNameReplication) throws AtlasBaseException {
        this.pauseForIndexCreation();
        AtlasEntity.AtlasEntitiesWithExtInfo entities = this.entityStore.getByIds((List)ImmutableList.of((Object)"1637a33e-6512-447b-ade7-249c8cb5344b", (Object)"df122fc3-5555-40f8-a30f-3090b8a622f8"));
        for (AtlasEntity e : entities.getEntities()) {
            Object ex = e.getAttribute(attrNameReplication);
            Assert.assertNotNull((Object)ex);
            List attrValue = (List)ex;
            Assert.assertEquals((int)attrValue.size(), (int)1);
        }
    }

    private void assertCluster(String name, String fullName, AtlasImportResult importResult) throws AtlasBaseException {
        AtlasServer actual = this.atlasServerService.get(new AtlasServer(name, fullName));
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)actual.getName(), (String)name);
        Assert.assertEquals((String)actual.getFullName(), (String)fullName);
        if (importResult != null) {
            this.assertClusterAdditionalInfo(actual, importResult);
        }
    }

    private void assertClusterAdditionalInfo(AtlasServer cluster, AtlasImportResult importResult) throws AtlasBaseException {
        AtlasExportRequest request = importResult.getExportResult().getRequest();
        AtlasEntityType type = (AtlasEntityType)this.typeRegistry.getType(((AtlasObjectId)request.getItemsToExport().get(0)).getTypeName());
        AtlasEntity.AtlasEntityWithExtInfo entity = this.entityStore.getByUniqueAttributes(type, ((AtlasObjectId)request.getItemsToExport().get(0)).getUniqueAttributes());
        long actualLastModifiedTimestamp = (Long)cluster.getAdditionalInfoRepl(entity.getEntity().getGuid());
        Assert.assertTrue((cluster.getAdditionalInfo().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)actualLastModifiedTimestamp, (long)importResult.getExportResult().getChangeMarker());
    }

    private AtlasExportRequest getUpdateMetaInfoUpdateRequest() {
        AtlasExportRequest request = this.getExportRequestWithReplicationOption();
        request.getOptions().put("replicatedTo", this.REPLICATED_TO_CLUSTER_NAME);
        return request;
    }

    private AtlasExportRequest getExportRequestWithReplicationOption() {
        try {
            AtlasExportRequest request = TestResourceFileUtils.readObjectFromJson("stocksDB-Entities", "export-replicatedTo", AtlasExportRequest.class);
            this.REPLICATED_TO_CLUSTER_NAME = (String)request.getOptions().get("replicatedTo");
            return request;
        }
        catch (IOException e) {
            throw new SkipException(String.format("getExportRequestWithReplicationOption: '%s' could not be loaded.", "export-replicatedTo"));
        }
    }

    private AtlasImportRequest getImportRequestWithReplicationOption() {
        try {
            AtlasImportRequest request = TestResourceFileUtils.readObjectFromJson("stocksDB-Entities", "import-replicatedFrom", AtlasImportRequest.class);
            this.REPLICATED_FROM_CLUSTER_NAME = (String)request.getOptions().get("replicatedFrom");
            return request;
        }
        catch (IOException e) {
            throw new SkipException(String.format("getExportRequestWithReplicationOption: '%s' could not be loaded.", "import-replicatedFrom"));
        }
    }
}

