/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ImportTransformsShaperTest
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private ImportService importService;
    @Inject
    private AtlasEntityStore entityStore;
    private final String TAG_NAME = "REPLICATED";

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        this.basicSetup(this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadFsModel(this.typeDefStore, this.typeRegistry);
    }

    @Test
    public void newTagIsCreatedAndEntitiesAreTagged() throws AtlasBaseException, IOException {
        AtlasImportResult result = ZipFileResourceTestUtils.runImportWithParameters(this.importService, this.getImporRequest(), ZipFileResourceTestUtils.getInputStreamFrom("stocks.zip"));
        AtlasClassificationType classification = this.typeRegistry.getClassificationTypeByName("REPLICATED");
        AssertJUnit.assertNotNull((Object)classification);
        this.assertEntities(result.getProcessedEntities(), "REPLICATED");
    }

    private void assertEntities(List<String> entityGuids, String tagName) throws AtlasBaseException {
        for (String guid : entityGuids) {
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getById(guid);
            AssertJUnit.assertNotNull((Object)entityWithExtInfo);
            this.assertTag(entityWithExtInfo, tagName);
        }
    }

    private void assertTag(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, String tagName) {
        if (entityWithExtInfo.getReferredEntities() == null || entityWithExtInfo.getReferredEntities().size() == 0) {
            return;
        }
        for (AtlasEntity entity : entityWithExtInfo.getReferredEntities().values()) {
            this.assertTag(entity, tagName);
        }
    }

    private void assertTag(AtlasEntity entity, String tagName) {
        Assert.assertTrue((entity.getClassifications().size() > 0 ? 1 : 0) != 0, (String)String.format("%s not tagged", entity.getTypeName()));
        Assert.assertEquals((String)((AtlasClassification)entity.getClassifications().get(0)).getTypeName(), (String)tagName);
    }

    private AtlasImportRequest getImporRequest() {
        AtlasImportRequest request = new AtlasImportRequest();
        request.getOptions().put("transforms", "{ \"Referenceable\": { \"*\":[ \"addClassification:REPLICATED\" ] } }");
        return request;
    }
}

