/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.impexp.ImportTransformer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ImportTransformerTest {
    @Test
    public void createWithCorrectParameters() throws AtlasBaseException, IllegalAccessException {
        String param1 = "@cl1";
        String param2 = "@cl2";
        ImportTransformer e = ImportTransformer.getTransformer((String)String.format("%s:%s:%s", "replace", param1, param2));
        Assert.assertTrue((boolean)(e instanceof ImportTransformer.Replace));
        Assert.assertEquals((String)((ImportTransformer.Replace)e).getToFindStr(), (String)param1);
        Assert.assertEquals((String)((ImportTransformer.Replace)e).getReplaceStr(), (String)param2);
    }

    @Test
    public void createSeveralWithCorrectParameters() throws AtlasBaseException, IllegalAccessException {
        String param1 = "@cl1";
        String param2 = "@cl2";
        ImportTransformer e1 = ImportTransformer.getTransformer((String)String.format("%s:%s:%s", "replace", param1, param2));
        ImportTransformer e2 = ImportTransformer.getTransformer((String)String.format("replace:tt1:tt2", new Object[0]));
        Assert.assertTrue((boolean)(e1 instanceof ImportTransformer.Replace));
        Assert.assertEquals((String)((ImportTransformer.Replace)e1).getToFindStr(), (String)param1);
        Assert.assertEquals((String)((ImportTransformer.Replace)e1).getReplaceStr(), (String)param2);
        Assert.assertTrue((boolean)(e2 instanceof ImportTransformer.Replace));
        Assert.assertEquals((String)((ImportTransformer.Replace)e2).getToFindStr(), (String)"tt1");
        Assert.assertEquals((String)((ImportTransformer.Replace)e2).getReplaceStr(), (String)"tt2");
    }

    @Test
    public void createWithDefaultParameters() throws AtlasBaseException {
        ImportTransformer e1 = ImportTransformer.getTransformer((String)"replace:@cl1");
        ImportTransformer e2 = ImportTransformer.getTransformer((String)"replace");
        Assert.assertTrue((boolean)(e1 instanceof ImportTransformer.Replace));
        Assert.assertEquals((String)((ImportTransformer.Replace)e1).getToFindStr(), (String)"@cl1");
        Assert.assertEquals((String)((ImportTransformer.Replace)e1).getReplaceStr(), (String)"");
        Assert.assertTrue((boolean)(e2 instanceof ImportTransformer.Replace));
        Assert.assertEquals((String)((ImportTransformer.Replace)e2).getToFindStr(), (String)"");
        Assert.assertEquals((String)((ImportTransformer.Replace)e2).getReplaceStr(), (String)"");
    }

    @Test
    public void applyLowercaseTransformer() throws AtlasBaseException {
        ImportTransformer e = ImportTransformer.getTransformer((String)"lowercase");
        Assert.assertEquals((Object)e.apply((Object)"@CL1"), (Object)"@cl1");
        Assert.assertEquals((Object)e.apply((Object)"@cl1"), (Object)"@cl1");
        Assert.assertEquals((Object)e.apply((Object)""), (Object)"");
        Assert.assertEquals((Object)e.apply(null), null);
        Assert.assertEquals((Object)e.apply((Object)5), (Object)5);
    }

    @Test
    public void applyUppercaseTransformer() throws AtlasBaseException {
        ImportTransformer e = ImportTransformer.getTransformer((String)"uppercase");
        Assert.assertEquals((Object)e.apply((Object)"@CL1"), (Object)"@CL1");
        Assert.assertEquals((Object)e.apply((Object)"@cl1"), (Object)"@CL1");
        Assert.assertEquals((Object)e.apply((Object)""), (Object)"");
        Assert.assertEquals((Object)e.apply(null), null);
        Assert.assertEquals((Object)e.apply((Object)5), (Object)5);
    }

    @Test
    public void applyReplaceTransformer1() throws AtlasBaseException {
        ImportTransformer e = ImportTransformer.getTransformer((String)"replace:@cl1:@cl2");
        Assert.assertEquals((Object)e.apply((Object)"@cl1"), (Object)"@cl2");
        Assert.assertEquals((Object)e.apply((Object)"default@cl1"), (Object)"default@cl2");
        Assert.assertEquals((Object)e.apply((Object)"@cl11"), (Object)"@cl21");
        Assert.assertEquals((Object)e.apply((Object)"@cl2"), (Object)"@cl2");
        Assert.assertEquals((Object)e.apply((Object)""), (Object)"");
        Assert.assertEquals((Object)e.apply(null), null);
        Assert.assertEquals((Object)e.apply((Object)5), (Object)5);
    }

    @Test
    public void applyReplaceTransformer2() throws AtlasBaseException {
        ImportTransformer e = ImportTransformer.getTransformer((String)"replace:@cl1");
        Assert.assertEquals((Object)e.apply((Object)"@cl1"), (Object)"");
        Assert.assertEquals((Object)e.apply((Object)"default@cl1"), (Object)"default");
        Assert.assertEquals((Object)e.apply((Object)"@cl11"), (Object)"1");
        Assert.assertEquals((Object)e.apply((Object)"@cl2"), (Object)"@cl2");
        Assert.assertEquals((Object)e.apply((Object)""), (Object)"");
        Assert.assertEquals((Object)e.apply(null), null);
        Assert.assertEquals((Object)e.apply((Object)5), (Object)5);
    }

    @Test
    public void applyReplaceTransformer3() throws AtlasBaseException {
        ImportTransformer e = ImportTransformer.getTransformer((String)"replace");
        Assert.assertEquals((Object)e.apply((Object)"@cl1"), (Object)"@cl1");
        Assert.assertEquals((Object)e.apply((Object)"default@cl1"), (Object)"default@cl1");
        Assert.assertEquals((Object)e.apply((Object)"@cl11"), (Object)"@cl11");
        Assert.assertEquals((Object)e.apply((Object)"@cl2"), (Object)"@cl2");
        Assert.assertEquals((Object)e.apply((Object)""), (Object)"");
        Assert.assertEquals((Object)e.apply(null), null);
        Assert.assertEquals((Object)e.apply((Object)5), (Object)5);
    }
}

