/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.discovery.EntityDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.impexp.ExportImportAuditService;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.commons.lang.StringUtils;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ImportServiceTest
extends AtlasTestBase {
    private static final int DEFAULT_LIMIT = 25;
    private final ImportService importService;
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private EntityDiscoveryService discoveryService;
    @Inject
    AtlasEntityStore entityStore;
    @Inject
    private ExportImportAuditService auditService;

    @Inject
    public ImportServiceTest(ImportService importService) {
        this.importService = importService;
    }

    @Override
    @BeforeClass
    public void initialize() throws Exception {
        super.initialize();
    }

    @BeforeTest
    public void setupTest() {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
    }

    @AfterClass
    public void clear() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @AfterTest
    public void postTest() throws InterruptedException {
        this.assertExportImportAuditEntry(this.auditService);
    }

    @DataProvider(name="sales")
    public static Object[][] getDataFromQuickStart_v1_Sales(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("sales-v1-full.zip");
    }

    @DataProvider(name="dup_col_data")
    public static Object[][] getDataForDuplicateColumn(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("dup_col_deleted.zip");
    }

    @Test(dataProvider="sales")
    public void importDB1(InputStream inputStream) throws AtlasBaseException, IOException {
        this.loadBaseModel();
        ZipFileResourceTestUtils.runAndVerifyQuickStart_v1_Import(this.importService, inputStream);
        this.assertEntityCount("DB_v1", "bfe88eb8-7556-403c-8210-647013f44a44", 1);
        AtlasEntity entity = this.assertEntity("Table_v1", "fe91bf93-eb0c-4638-8361-15937390c810");
        Assert.assertEquals((int)entity.getClassifications().size(), (int)1);
        Assert.assertFalse((boolean)((AtlasClassification)entity.getClassifications().get(0)).isPropagate(), (String)"Default propagate should be false");
    }

    @DataProvider(name="reporting")
    public static Object[][] getDataFromReporting() throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("reporting-v1-full.zip");
    }

    @Test(dataProvider="reporting")
    public void importDB2(InputStream inputStream) throws AtlasBaseException, IOException {
        this.loadBaseModel();
        ZipFileResourceTestUtils.runAndVerifyQuickStart_v1_Import(this.importService, inputStream);
    }

    @DataProvider(name="logging")
    public static Object[][] getDataFromLogging(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("logging-v1-full.zip");
    }

    @Test(dataProvider="logging")
    public void importDB3(InputStream inputStream) throws AtlasBaseException, IOException {
        this.loadBaseModel();
        ZipFileResourceTestUtils.runAndVerifyQuickStart_v1_Import(this.importService, inputStream);
    }

    @DataProvider(name="salesNewTypeAttrs")
    public static Object[][] getDataFromSalesNewTypeAttrs(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("salesNewTypeAttrs.zip");
    }

    @Test(dataProvider="salesNewTypeAttrs", dependsOnMethods={"importDB1"})
    public void importDB4(InputStream inputStream) throws AtlasBaseException, IOException {
        this.loadBaseModel();
        ZipFileResourceTestUtils.runImportWithParameters(this.importService, ZipFileResourceTestUtils.getDefaultImportRequest(), inputStream);
    }

    @DataProvider(name="salesNewTypeAttrs-next")
    public static Object[][] getDataFromSalesNewTypeAttrsNext(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("salesNewTypeAttrs-next.zip");
    }

    @DataProvider(name="zip-direct-3")
    public static Object[][] getZipDirect3(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("zip-direct-3.zip");
    }

    @Test(dataProvider="salesNewTypeAttrs-next", dependsOnMethods={"importDB4"})
    public void importDB5(InputStream inputStream) throws AtlasBaseException, IOException {
        String newEnumDefName = "database_action";
        Assert.assertNotNull((Object)this.typeDefStore.getEnumDefByName("database_action"));
        AtlasImportRequest request = ZipFileResourceTestUtils.getDefaultImportRequest();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("updateTypeDefinition", "false");
        request.setOptions(options);
        ZipFileResourceTestUtils.runImportWithParameters(this.importService, request, inputStream);
        Assert.assertNotNull((Object)this.typeDefStore.getEnumDefByName("database_action"));
        Assert.assertEquals((int)this.typeDefStore.getEnumDefByName("database_action").getElementDefs().size(), (int)4);
    }

    @Test(dataProvider="salesNewTypeAttrs-next", dependsOnMethods={"importDB4"})
    public void importDB6(InputStream inputStream) throws AtlasBaseException, IOException {
        String newEnumDefName = "database_action";
        Assert.assertNotNull((Object)this.typeDefStore.getEnumDefByName("database_action"));
        AtlasImportRequest request = ZipFileResourceTestUtils.getDefaultImportRequest();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("updateTypeDefinition", "true");
        request.setOptions(options);
        ZipFileResourceTestUtils.runImportWithParameters(this.importService, request, inputStream);
        Assert.assertNotNull((Object)this.typeDefStore.getEnumDefByName("database_action"));
        Assert.assertEquals((int)this.typeDefStore.getEnumDefByName("database_action").getElementDefs().size(), (int)8);
    }

    @DataProvider(name="ctas")
    public static Object[][] getDataFromCtas(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("ctas.zip");
    }

    @Test(dataProvider="ctas")
    public void importCTAS(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadHiveModel();
        ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, inputStream);
    }

    @DataProvider(name="stocks-legacy")
    public static Object[][] getDataFromLegacyStocks(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("stocks.zip");
    }

    @Test(dataProvider="stocks-legacy")
    public void importLegacy(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadFsModel();
        this.loadHiveModel();
        ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, inputStream);
        List<AtlasEntityHeader> result = this.getImportedEntities("hive_db", "886c5e9c-3ac6-40be-8201-fb0cebb64783");
        Assert.assertEquals((int)result.size(), (int)1);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getEntity(result.get(0));
        Map relationshipAttributes = entityWithExtInfo.getEntity().getRelationshipAttributes();
        Assert.assertNotNull((Object)relationshipAttributes);
        Assert.assertNotNull(relationshipAttributes.get("tables"));
        List relatedList = (List)relationshipAttributes.get("tables");
        AtlasRelatedObjectId relatedObjectId = (AtlasRelatedObjectId)relatedList.get(0);
        Assert.assertNotNull((Object)relatedObjectId.getRelationshipGuid());
    }

    @Test(dataProvider="tag-prop-2")
    public void importTagProp2(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadFsModel();
        this.loadHiveModel();
        ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, inputStream);
        this.assertEntityCount("hive_db", "7d7d5a18-d992-457e-83c0-e36f5b95ebdb", 1);
        this.assertEntityCount("hive_table", "dbe729bb-c614-4e23-b845-3258efdf7a58", 1);
        AtlasEntity entity = this.assertEntity("hive_table", "092e9888-de96-4908-8be3-925ee72e3395");
        Assert.assertEquals((int)entity.getClassifications().size(), (int)2);
        Assert.assertTrue((boolean)((AtlasClassification)entity.getClassifications().get(0)).isPropagate());
        Assert.assertFalse((boolean)((AtlasClassification)entity.getClassifications().get(0)).getEntityGuid().equalsIgnoreCase(entity.getGuid()));
        Assert.assertFalse((boolean)((AtlasClassification)entity.getClassifications().get(1)).getEntityGuid().equalsIgnoreCase(entity.getGuid()));
    }

    @Test(dataProvider="stocks-legacy")
    public void importExistingTopLevelEntity(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadFsModel();
        this.loadHiveModel();
        AtlasEntity db = new AtlasEntity("hive_db", "name", (Object)"stocks");
        db.setAttribute("clusterName", (Object)"cl1");
        db.setAttribute("qualifiedName", (Object)"stocks@cl1");
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        entitiesWithExtInfo.addEntity(db);
        AtlasEntityStream entityStream = new AtlasEntityStream(entitiesWithExtInfo);
        EntityMutationResponse createResponse = this.entityStore.createOrUpdate((EntityStream)entityStream, false);
        Assert.assertNotNull((Object)createResponse);
        String preImportGuid = ((AtlasEntityHeader)createResponse.getCreatedEntities().get(0)).getGuid();
        ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, inputStream);
        AtlasVertex v = AtlasGraphUtilsV2.findByGuid((String)"886c5e9c-3ac6-40be-8201-fb0cebb64783");
        Assert.assertNotNull((Object)v);
        String postImportGuid = AtlasGraphUtilsV2.getIdFromVertex((AtlasVertex)v);
        Assert.assertNotEquals((Object)preImportGuid, (Object)postImportGuid);
        String historicalGuids = (String)v.getProperty(Constants.HISTORICAL_GUID_PROPERTY_KEY, String.class);
        Assert.assertTrue((boolean)historicalGuids.contains(preImportGuid));
    }

    @DataProvider(name="stocks-glossary")
    public static Object[][] getDataFromGlossary(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("stocks-glossary.zip");
    }

    @Test(dataProvider="stocks-glossary")
    public void importGlossary(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadGlossary();
        ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, inputStream);
        this.assertEntityCount("AtlasGlossary", "40c80052-3129-4f7c-8f2f-391677935416", 1);
        this.assertEntityCount("AtlasGlossaryTerm", "e93ac426-de04-4d54-a7c9-d76c1e96369b", 1);
        this.assertEntityCount("AtlasGlossaryTerm", "93ad3bf6-23dc-4e3f-b70e-f8fad6438203", 1);
        this.assertEntityCount("AtlasGlossaryTerm", "105533b6-c125-4a87-bed5-cdf67fb68c39", 1);
    }

    private List<AtlasEntityHeader> getImportedEntities(String query, String guid) throws AtlasBaseException {
        String q = StringUtils.isEmpty((String)guid) ? query : String.format("%s where __guid = '%s'", query, guid);
        return this.discoveryService.searchUsingDslQuery(q, 25, 0).getEntities();
    }

    @DataProvider(name="hdfs_path1")
    public static Object[][] getDataFromHdfsPath1(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("hdfs_path1.zip");
    }

    @Test(dataProvider="hdfs_path1", expectedExceptions={AtlasBaseException.class})
    public void importHdfs_path1(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadFsModel();
        TestLoadModelUtils.loadModelFromResourcesJson("tag1.json", this.typeDefStore, this.typeRegistry);
        try {
            ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, inputStream);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_IMPORT_ATTRIBUTE_TYPE_CHANGED);
            AtlasClassificationType tag1 = this.typeRegistry.getClassificationTypeByName("tag1");
            Assert.assertNotNull((Object)tag1);
            Assert.assertEquals((int)tag1.getAllAttributes().size(), (int)2);
            throw e;
        }
    }

    @Test(dataProvider="zip-direct-3", expectedExceptions={AtlasBaseException.class})
    public void zipDirectSample(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadFsModel();
        AtlasImportRequest request = new AtlasImportRequest();
        request.setOption("format", "zipDirect");
        ZipFileResourceTestUtils.runImportWithParameters(this.importService, request, inputStream);
    }

    @DataProvider(name="relationshipLineage")
    public static Object[][] getImportWithRelationships(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("rel-lineage.zip");
    }

    @DataProvider(name="tag-prop-2")
    public static Object[][] getImportWithTagProp2(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("tag-prop-2.zip");
    }

    @Test(dataProvider="relationshipLineage")
    public void importDB8(InputStream inputStream) throws AtlasBaseException, IOException {
        this.loadBaseModel();
        this.loadHiveModel();
        AtlasImportRequest request = ZipFileResourceTestUtils.getDefaultImportRequest();
        ZipFileResourceTestUtils.runImportWithParameters(this.importService, request, inputStream);
    }

    @DataProvider(name="relationship")
    public static Object[][] getImportWithRelationshipsWithLineage(ITestContext context) throws IOException, AtlasBaseException {
        return ZipFileResourceTestUtils.getZipSource("stocks-rel-2.zip");
    }

    @Test(dataProvider="relationship")
    public void importDB7(InputStream inputStream) throws AtlasBaseException, IOException {
        this.loadBaseModel();
        this.loadHiveModel();
        AtlasImportRequest request = ZipFileResourceTestUtils.getDefaultImportRequest();
        ZipFileResourceTestUtils.runImportWithParameters(this.importService, request, inputStream);
        this.assertEntityCount("hive_db", "d7dc0848-fbba-4d63-9264-a460798361f5", 1);
        this.assertEntityCount("hive_table", "2fb31eaa-4bb2-4eb8-b333-a888ba7c84fe", 1);
        this.assertEntityCount("hive_column", "13422f0c-9265-4960-91a9-290ffd83b7f1", 1);
        this.assertEntityCount("hive_column", "c1ae870f-ce0c-44ae-832f-ff77035b1f7e", 1);
        this.assertEntityCount("hive_column", "b84baab3-0664-4f13-82f1-e81d043db02f", 1);
        this.assertEntityCount("hive_column", "53ea1991-6ca8-44f2-a75e-61b8d4866fc8", 1);
        this.assertEntityCount("hive_column", "a973c04c-aa42-49f4-877c-66fbe6754fb5", 1);
        this.assertEntityCount("hive_column", "a4550803-f18e-4072-a1e8-1201e6022a58", 1);
        this.assertEntityCount("hive_column", "6c4f196a-4046-493b-8c3a-2b1a9ef255a2", 1);
    }

    private List<AtlasEntityHeader> assertEntityCount(String entityType, String guid, int expectedCount) throws AtlasBaseException {
        List<AtlasEntityHeader> result = this.getImportedEntities(entityType, guid);
        Assert.assertEquals((int)result.size(), (int)expectedCount);
        return result;
    }

    private AtlasEntity assertEntity(String entityType, String guid) throws AtlasBaseException {
        List<AtlasEntityHeader> result = this.getImportedEntities(entityType, guid);
        int expectedCount = 1;
        Assert.assertEquals((int)result.size(), (int)expectedCount);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getEntity(result.get(0));
        Assert.assertNotNull((Object)entityWithExtInfo);
        return entityWithExtInfo.getEntity();
    }

    @Test
    public void importServiceProcessesIOException() {
        ImportService importService = new ImportService(this.typeDefStore, this.typeRegistry, null, null, null, null);
        AtlasImportRequest req = (AtlasImportRequest)Mockito.mock(AtlasImportRequest.class);
        Answer answer = invocationOnMock -> {
            throw new IOException("file is read only");
        };
        Mockito.when((Object)req.getFileName()).thenReturn((Object)"some-file.zip");
        Mockito.when((Object)req.getOptions()).thenAnswer(answer);
        try {
            importService.run(req, "a", "b", "c");
        }
        catch (AtlasBaseException ex) {
            Assert.assertEquals((String)ex.getAtlasErrorCode().getErrorCode(), (String)AtlasErrorCode.INVALID_PARAMETERS.getErrorCode());
        }
    }

    private void loadFsModel() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1020-fs_model.json", this.typeDefStore, this.typeRegistry);
    }

    private void loadHiveModel() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("1000-Hadoop/1030-hive_model.json", this.typeDefStore, this.typeRegistry);
    }

    private void loadBaseModel() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("0000-Area0/0010-base_model.json", this.typeDefStore, this.typeRegistry);
    }

    private void loadGlossary() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadModelFromJson("0000-Area0/0011-glossary_model.json", this.typeDefStore, this.typeRegistry);
    }

    private AtlasEntity.AtlasEntityWithExtInfo getEntity(AtlasEntityHeader header) throws AtlasBaseException {
        return this.entityStore.getById(header.getGuid());
    }

    @Test(dataProvider="salesNewTypeAttrs-next")
    public void transformUpdatesForSubTypes(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadHiveModel();
        String transformJSON = "{ \"Asset\": { \"qualifiedName\":[ \"lowercase\", \"replace:@cl1:@cl2\" ] } }";
        ZipSource zipSource = new ZipSource(inputStream);
        this.importService.setImportTransform((EntityImportStream)zipSource, transformJSON);
        ImportTransforms importTransforms = zipSource.getImportTransform();
        Assert.assertTrue((boolean)importTransforms.getTransforms().containsKey("Asset"));
        Assert.assertTrue((boolean)importTransforms.getTransforms().containsKey("hive_table"));
        Assert.assertTrue((boolean)importTransforms.getTransforms().containsKey("hive_column"));
    }

    @Test(dataProvider="salesNewTypeAttrs-next")
    public void transformUpdatesForSubTypesAddsToExistingTransforms(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadHiveModel();
        String transformJSON = "{ \"Asset\": { \"qualifiedName\":[ \"replace:@cl1:@cl2\" ] }, \"hive_table\": { \"qualifiedName\":[ \"lowercase\" ] } }";
        ZipSource zipSource = new ZipSource(inputStream);
        this.importService.setImportTransform((EntityImportStream)zipSource, transformJSON);
        ImportTransforms importTransforms = zipSource.getImportTransform();
        Assert.assertTrue((boolean)importTransforms.getTransforms().containsKey("Asset"));
        Assert.assertTrue((boolean)importTransforms.getTransforms().containsKey("hive_table"));
        Assert.assertTrue((boolean)importTransforms.getTransforms().containsKey("hive_column"));
        Assert.assertEquals((int)((List)((Map)importTransforms.getTransforms().get("hive_table")).get("qualifiedName")).size(), (int)2);
    }

    @Test(expectedExceptions={AtlasBaseException.class})
    public void importEmptyZip() throws IOException, AtlasBaseException {
        new ZipSource(ZipFileResourceTestUtils.getInputStreamFrom("empty.zip"));
    }

    @Test
    public void testCheckHiveTableIncrementalSkipLineage() {
        AtlasImportRequest importRequest = this.getImportRequest("cl1");
        AtlasExportRequest exportRequest = this.getExportRequest("incremental", "cl2", true, this.getItemsToExport("hive_table", "hive_table"));
        Assert.assertTrue((boolean)this.importService.checkHiveTableIncrementalSkipLineage(importRequest, exportRequest));
        exportRequest = this.getExportRequest("incremental", "cl2", true, this.getItemsToExport("hive_table", "hive_db", "hive_table"));
        Assert.assertFalse((boolean)this.importService.checkHiveTableIncrementalSkipLineage(importRequest, exportRequest));
        exportRequest = this.getExportRequest("full", "cl2", true, this.getItemsToExport("hive_table", "hive_table"));
        Assert.assertFalse((boolean)this.importService.checkHiveTableIncrementalSkipLineage(importRequest, exportRequest));
        exportRequest = this.getExportRequest("full", "", true, this.getItemsToExport("hive_table", "hive_table"));
        Assert.assertFalse((boolean)this.importService.checkHiveTableIncrementalSkipLineage(importRequest, exportRequest));
        importRequest = this.getImportRequest("");
        exportRequest = this.getExportRequest("incremental", "cl2", true, this.getItemsToExport("hive_table", "hive_table"));
        Assert.assertFalse((boolean)this.importService.checkHiveTableIncrementalSkipLineage(importRequest, exportRequest));
    }

    @Test(dataProvider="dup_col_data")
    public void testImportDuplicateColumnsWithDifferentStatus(InputStream inputStream) throws IOException, AtlasBaseException {
        this.loadBaseModel();
        this.loadFsModel();
        this.loadHiveModel();
        ZipFileResourceTestUtils.runImportWithNoParameters(this.importService, inputStream);
        AtlasEntity.AtlasEntityWithExtInfo atlasEntityWithExtInfo = this.entityStore.getById("e18e15de-1810-4724-881a-5cb6b2160077");
        Assert.assertNotNull((Object)atlasEntityWithExtInfo);
        AtlasEntity atlasEntity = atlasEntityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)atlasEntity);
        List columns = (List)atlasEntity.getRelationshipAttribute("columns");
        Assert.assertEquals((int)columns.size(), (int)4);
        for (AtlasRelatedObjectId id : columns) {
            if (id.getGuid().equals("a3de3e3b-4bcd-4e57-a988-1101a2360200")) {
                Assert.assertEquals((Object)id.getEntityStatus(), (Object)AtlasEntity.Status.DELETED);
                Assert.assertEquals((Object)id.getRelationshipStatus(), (Object)AtlasRelationship.Status.DELETED);
            }
            if (!id.getGuid().equals("f7fa3768-f3de-48a8-92a5-38ec4070152c")) continue;
            Assert.assertEquals((Object)id.getEntityStatus(), (Object)AtlasEntity.Status.ACTIVE);
            Assert.assertEquals((Object)id.getRelationshipStatus(), (Object)AtlasRelationship.Status.ACTIVE);
        }
    }

    private AtlasImportRequest getImportRequest(String replicatedFrom) {
        AtlasImportRequest importRequest = ZipFileResourceTestUtils.getDefaultImportRequest();
        if (!StringUtils.isEmpty((String)replicatedFrom)) {
            importRequest.setOption("replicatedFrom", replicatedFrom);
        }
        return importRequest;
    }

    private AtlasExportRequest getExportRequest(String fetchType, String replicatedTo, boolean skipLineage, List<AtlasObjectId> itemsToExport) {
        AtlasExportRequest request = new AtlasExportRequest();
        request.setOptions(this.getOptionsMap(fetchType, replicatedTo, skipLineage));
        request.setItemsToExport(itemsToExport);
        return request;
    }

    private List<AtlasObjectId> getItemsToExport(String ... typeNames) {
        ArrayList<AtlasObjectId> itemsToExport = new ArrayList<AtlasObjectId>();
        for (String typeName : typeNames) {
            itemsToExport.add(new AtlasObjectId(typeName, "qualifiedName", (Object)"db.table@cluster"));
        }
        return itemsToExport;
    }

    private Map<String, Object> getOptionsMap(String fetchType, String replicatedTo, boolean skipLineage) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)fetchType)) {
            options.put("fetchType", fetchType);
        }
        if (!StringUtils.isEmpty((String)replicatedTo)) {
            options.put("replicatedTo", replicatedTo);
        }
        options.put("skipLineage", skipLineage);
        return options;
    }
}

