/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ZipFileResourceTestUtils;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityChangeNotifier;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ExportSkipLineageTest
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private EntityGraphMapper graphMapper;
    @Inject
    ExportService exportService;
    @Inject
    AtlasGraph atlasGraph;
    private DeleteHandlerDelegate deleteDelegate = (DeleteHandlerDelegate)Mockito.mock(DeleteHandlerDelegate.class);
    private AtlasEntityChangeNotifier mockChangeNotifier = (AtlasEntityChangeNotifier)Mockito.mock(AtlasEntityChangeNotifier.class);
    private AtlasEntityStoreV2 entityStore;

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadBaseModel(this.typeDefStore, this.typeRegistry);
        TestLoadModelUtils.loadHiveModel(this.typeDefStore, this.typeRegistry);
        RequestContext.get().setImportInProgress(true);
        this.entityStore = new AtlasEntityStoreV2(this.atlasGraph, this.deleteDelegate, this.typeRegistry, (IAtlasEntityChangeNotifier)this.mockChangeNotifier, this.graphMapper);
        this.createEntities(this.entityStore, "stocksDB-Entities", new String[]{"db", "table-columns", "table-view", "table-table-lineage"});
        String[] entityGuids = new String[]{"1637a33e-6512-447b-ade7-249c8cb5344b", "df122fc3-5555-40f8-a30f-3090b8a622f8", "6f3b305a-c459-4ae4-b651-aee0deb0685f", "56415119-7cb0-40dd-ace8-1e50efd54991"};
        this.verifyCreatedEntities(this.entityStore, entityGuids, 4);
    }

    @BeforeMethod
    public void setupTest() {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
    }

    @Test
    public void exportWithoutLineage() throws IOException, AtlasBaseException {
        int expectedEntityCount = 3;
        AtlasExportRequest request = this.getRequest();
        InputStream inputStream = ZipFileResourceTestUtils.runExportWithParameters(this.exportService, request);
        ZipSource source = new ZipSource(inputStream);
        AtlasEntity.AtlasEntityWithExtInfo entities = ZipFileResourceTestUtils.getEntities(source, 3);
        int count = 0;
        for (Map.Entry entry : entities.getReferredEntities().entrySet()) {
            Assert.assertNotNull(entry.getValue());
            if (((AtlasEntity)entry.getValue()).getTypeName().equals("hive_process")) {
                AssertJUnit.fail((String)"Process entities should not be part of export!");
            }
            ++count;
        }
        Assert.assertEquals((int)count, (int)3);
    }

    private AtlasExportRequest getRequest() {
        String filename = "export-skip-lineage";
        try {
            AtlasExportRequest request = TestResourceFileUtils.readObjectFromJson("stocksDB-Entities", "export-skip-lineage", AtlasExportRequest.class);
            return request;
        }
        catch (IOException e) {
            throw new SkipException(String.format("getRequest: '%s' could not be loaded.", "export-skip-lineage"));
        }
    }
}

