/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.ExportImportAuditEntry;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.impexp.ExportImportAuditService;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ExportImportAuditServiceTest
extends AtlasTestBase {
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    ExportImportAuditService auditService;

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadBaseModel(this.typeDefStore, this.typeRegistry);
    }

    @Test
    public void checkTypeRegistered() throws AtlasBaseException {
        AtlasType auditEntryType = this.typeRegistry.getType("__" + ExportImportAuditEntry.class.getSimpleName());
        Assert.assertNotNull((Object)auditEntryType);
    }

    @Test
    public void saveLogEntry() throws AtlasBaseException {
        String source1 = "clx";
        String target1 = "cly";
        ExportImportAuditEntry entry = this.saveAndGet("clx", "EXPORT", "cly");
        String source2 = "clx2";
        String target2 = "clx1";
        ExportImportAuditEntry entry2 = this.saveAndGet(source2, "EXPORT", target2);
        this.pauseForIndexCreation();
        ExportImportAuditEntry actualEntry = this.retrieveEntry(entry);
        ExportImportAuditEntry actualEntry2 = this.retrieveEntry(entry2);
        Assert.assertNotEquals((Object)actualEntry.getGuid(), (Object)actualEntry2.getGuid());
        Assert.assertNotNull((Object)actualEntry.getGuid());
        Assert.assertEquals((String)actualEntry.getSourceServerName(), (String)entry.getSourceServerName());
        Assert.assertEquals((String)actualEntry.getTargetServerName(), (String)entry.getTargetServerName());
        Assert.assertEquals((String)actualEntry.getOperation(), (String)entry.getOperation());
    }

    @Test
    public void numberOfSavedEntries_Retrieved() throws AtlasBaseException, InterruptedException {
        String source1 = "server1";
        String target1 = "cly";
        int MAX_ENTRIES = 5;
        for (int i = 0; i < MAX_ENTRIES; ++i) {
            this.saveAndGet("server1", "EXPORT", "cly");
        }
        this.pauseForIndexCreation();
        List results = this.auditService.get("", "EXPORT", "", "", "", 10, 0);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
    }

    private ExportImportAuditEntry retrieveEntry(ExportImportAuditEntry entry) throws AtlasBaseException {
        List result = this.auditService.get(entry.getUserName(), entry.getOperation(), entry.getSourceServerName(), Long.toString(entry.getStartTime()), "", 10, 0);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        entry.setGuid(((ExportImportAuditEntry)result.get(0)).getGuid());
        return this.auditService.get(entry);
    }

    private ExportImportAuditEntry saveAndGet(String sourceServerName, String operation, String targetServerName) throws AtlasBaseException {
        ExportImportAuditEntry entry = new ExportImportAuditEntry(sourceServerName, operation);
        entry.setTargetServerName(targetServerName);
        entry.setUserName("default");
        entry.setStartTime(System.currentTimeMillis());
        entry.setEndTime(System.currentTimeMillis() + 1000L);
        this.auditService.save(entry);
        return entry;
    }
}

