/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.atlas.TestModules;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.impexp.AtlasServerService;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasServerServiceTest {
    private final String TOP_LEVEL_ENTITY_NAME = "db1@cl1";
    private final String SERVER_NAME = "testCl1";
    private final String TARGET_SERVER_NAME = "testCl2";
    private final String QUALIFIED_NAME_STOCKS = "stocks@cl1";
    private final String TYPE_HIVE_DB = "hive_db";
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasServerService atlasServerService;
    private String topLevelEntityGuid = "AAA-BBB-CCC";

    @BeforeClass
    public void setup() throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadBaseModel(this.typeDefStore, this.typeRegistry);
    }

    @Test
    public void saveAndRetrieveServerInfo() throws AtlasBaseException {
        AtlasServer expected = this.getServer("testCl1_1", "db1@cl1", "EXPORT", 0L, "testCl2");
        AtlasServer expected2 = this.getServer("testCl2_1", "db1@cl1", "IMPORT", 0L, "testCl2");
        AtlasServer expected3 = this.getServer("testCl2_3", "db1@cl1", "IMPORT", 0L, "testCl2");
        AtlasServer actual = this.atlasServerService.save(expected);
        AtlasServer actual2 = this.atlasServerService.save(expected2);
        AtlasServer actual3 = this.atlasServerService.save(expected3);
        AtlasServer actual2x = this.atlasServerService.get(expected2);
        Assert.assertNotNull((Object)actual.getGuid());
        Assert.assertNotNull((Object)actual2.getGuid());
        Assert.assertNotEquals((Object)actual.getGuid(), (Object)actual2.getGuid());
        Assert.assertNotEquals((Object)actual2.getGuid(), (Object)actual3.getGuid());
        Assert.assertEquals((String)actual2.getGuid(), (String)actual2x.getGuid());
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((String)actual.getFullName(), (String)expected.getFullName());
    }

    private AtlasServer getServer(String serverName, String topLevelEntity, String operation, long nextModifiedTimestamp, String targetServerName) {
        AtlasServer cluster = new AtlasServer(serverName, serverName);
        HashMap<String, String> syncMap = new HashMap<String, String>();
        syncMap.put("topLevelEntity", topLevelEntity);
        syncMap.put("operation", operation);
        syncMap.put("nextModifiedTimestamp", Long.toString(nextModifiedTimestamp));
        syncMap.put("targetCluster", targetServerName);
        cluster.setAdditionalInfo(syncMap);
        return cluster;
    }

    @Test
    public void verifyAdditionalInfo() throws AtlasBaseException {
        long expectedLastModifiedTimestamp = 200L;
        AtlasServer expectedCluster = this.atlasServerService.getCreateAtlasServer("testCl1", "testCl1");
        String qualifiedNameAttr = "Referenceable.qualifiedName".replace("Referenceable.", "");
        AtlasObjectId objectId = new AtlasObjectId("hive_db", qualifiedNameAttr, (Object)"stocks@cl1");
        expectedCluster.setAdditionalInfoRepl(this.topLevelEntityGuid, 200L);
        AtlasServer actualCluster = this.atlasServerService.save(expectedCluster);
        Assert.assertEquals((String)actualCluster.getName(), (String)expectedCluster.getName());
        int actualModifiedTimestamp = (Integer)actualCluster.getAdditionalInfoRepl(this.topLevelEntityGuid);
        Assert.assertEquals((long)actualModifiedTimestamp, (long)200L);
    }
}

