/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.repository.audit.AuditRepositoryTestBase;
import org.apache.atlas.repository.audit.CassandraBasedAuditRepository;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;

public class CassandraAuditRepositoryTest
extends AuditRepositoryTestBase {
    private static final int MAX_RETRIES = 9;
    private final String CLUSTER_HOST = "localhost";
    private final String CLUSTER_NAME_TEST = "Test Cluster";
    private final int CLUSTER_PORT = 9042;
    private final String CLUSTER_USERNAME = "";
    private final String CLUSTER_PASSWORD = "";

    @BeforeClass
    public void setup() {
        try {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra((String)"cassandra_test.yml");
            this.eventRepository = new CassandraBasedAuditRepository();
            MapConfiguration atlasConf = new MapConfiguration(this.getClusterProperties());
            ((CassandraBasedAuditRepository)this.eventRepository).setApplicationProperties((Configuration)atlasConf);
            ((CassandraBasedAuditRepository)this.eventRepository).start();
            this.ensureClusterCreation();
        }
        catch (Exception ex) {
            throw new SkipException("setup: failed!", (Throwable)ex);
        }
    }

    private Map<String, Object> getClusterProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("MANAGE_EMBEDDED_CASSANDRA", Boolean.TRUE);
        props.put("atlas.graph.storage.clustername", "Test Cluster");
        props.put("atlas.graph.storage.hostname", "localhost");
        props.put("atlas.graph.storage.port", 9042);
        props.put("atlas.graph.storage.username", "");
        props.put("atlas.graph.storage.password", "");
        return props;
    }

    private void ensureClusterCreation() throws InterruptedException {
        Cluster.Builder cassandraClusterBuilder = Cluster.builder();
        Cluster cluster = cassandraClusterBuilder.addContactPoint("localhost").withClusterName("Test Cluster").withPort(9042).withCredentials("".trim(), "".trim()).build();
        for (int retryCount = 0; retryCount < 9; ++retryCount) {
            try {
                Session cassSession = cluster.connect();
                if (cassSession.getState().getConnectedHosts().size() <= 0) continue;
                cassSession.close();
                return;
            }
            catch (Exception e) {
                Thread.sleep(1000L);
            }
        }
        throw new SkipException("Unable to connect to embedded Cassandra after 9 seconds.");
    }
}

