/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestModules;
import org.apache.atlas.TestUtilsV2;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.model.audit.AuditSearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.AtlasTestBase;
import org.apache.atlas.repository.audit.AtlasAuditService;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestResourceFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AdminPurgeTest
extends AtlasTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AdminPurgeTest.class);
    private static final String CLIENT_HOST = "127.0.0.0";
    private static final String DEFAULT_USER = "Admin";
    private static final String AUDIT_PARAMETER_RESOURCE_DIR = "auditSearchParameters";
    @Inject
    AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasAuditService auditService;
    @Inject
    private AtlasEntityStoreV2 entityStore;

    @Override
    @BeforeClass
    public void initialize() throws Exception {
        super.initialize();
    }

    @BeforeTest
    public void setupTest() throws IOException, AtlasBaseException {
        RequestContext.clear();
        RequestContext.get().setUser("testUser", null);
        this.basicSetup(this.typeDefStore, this.typeRegistry);
    }

    @AfterClass
    public void clear() throws Exception {
        Thread.sleep(1000L);
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }

    @Test
    public void testDeleteEntitiesDoesNotLookupDeletedEntity() throws Exception {
        AtlasTypesDef sampleTypes = TestUtilsV2.defineDeptEmployeeTypes();
        AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate((AtlasTypesDef)sampleTypes, (AtlasTypeRegistry)this.typeRegistry);
        if (!typesToCreate.isEmpty()) {
            this.typeDefStore.createTypesDef(typesToCreate);
        }
        AtlasEntity.AtlasEntitiesWithExtInfo deptEg2 = TestUtilsV2.createDeptEg2();
        AtlasEntityStream entityStream = new AtlasEntityStream(deptEg2);
        EntityMutationResponse emr = this.entityStore.createOrUpdate((EntityStream)entityStream, false);
        this.pauseForIndexCreation();
        Assert.assertNotNull((Object)emr);
        Assert.assertNotNull((Object)emr.getCreatedEntities());
        Assert.assertTrue((emr.getCreatedEntities().size() > 0 ? 1 : 0) != 0);
        List guids = emr.getCreatedEntities().stream().map(p -> new String(p.getGuid())).collect(Collectors.toList());
        EntityMutationResponse response = this.entityStore.deleteByIds(guids);
        this.pauseForIndexCreation();
        List responseDeletedEntities = response.getDeletedEntities();
        Assert.assertNotNull((Object)responseDeletedEntities);
        responseDeletedEntities.sort((l, r) -> l.getGuid().compareTo(r.getGuid()));
        List toBeDeletedEntities = emr.getCreatedEntities();
        toBeDeletedEntities.sort((l, r) -> l.getGuid().compareTo(r.getGuid()));
        Assert.assertEquals((int)responseDeletedEntities.size(), (int)emr.getCreatedEntities().size());
        for (int index = 0; index < responseDeletedEntities.size(); ++index) {
            Assert.assertEquals((String)((AtlasEntityHeader)responseDeletedEntities.get(index)).getGuid(), (String)((AtlasEntityHeader)emr.getCreatedEntities().get(index)).getGuid());
        }
        Date startTimestamp = new Date();
        response = this.entityStore.purgeByIds(new HashSet(guids));
        this.pauseForIndexCreation();
        List responsePurgedEntities = response.getPurgedEntities();
        responsePurgedEntities.sort((l, r) -> l.getGuid().compareTo(r.getGuid()));
        Assert.assertEquals((int)responsePurgedEntities.size(), (int)responseDeletedEntities.size());
        for (int index = 0; index < responsePurgedEntities.size(); ++index) {
            Assert.assertEquals((String)((AtlasEntityHeader)responsePurgedEntities.get(index)).getGuid(), (String)((AtlasEntityHeader)responseDeletedEntities.get(index)).getGuid());
        }
        this.auditService.add(DEFAULT_USER, AtlasAuditEntry.AuditOperation.PURGE, CLIENT_HOST, startTimestamp, new Date(), guids.toString(), response.getPurgedEntitiesIds(), (long)response.getPurgedEntities().size());
        AuditSearchParameters auditParameterNull = this.createAuditParameter("audit-search-parameter-without-filter");
        this.assertAuditEntry(this.auditService, auditParameterNull);
        AuditSearchParameters auditSearchParameters = this.createAuditParameter("audit-search-parameter-purge");
        this.assertAuditEntry(this.auditService, auditSearchParameters);
    }

    private AuditSearchParameters createAuditParameter(String fileName) {
        try {
            return TestResourceFileUtils.readObjectFromJson(AUDIT_PARAMETER_RESOURCE_DIR, fileName, AuditSearchParameters.class);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private void assertAuditEntry(AtlasAuditService auditService, AuditSearchParameters auditSearchParameters) throws InterruptedException {
        this.pauseForIndexCreation();
        List result = null;
        try {
            result = auditService.get(auditSearchParameters);
        }
        catch (Exception e) {
            throw new SkipException("audit entries not retrieved.");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
    }
}

