/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.graph.GraphSandboxUtil;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.impexp.ExportImportAuditService;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStoreV2;
import org.apache.atlas.runner.LocalSolrRunner;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.testng.Assert;
import org.testng.SkipException;

public class AtlasTestBase {
    protected static final String ENTITIES_SUB_DIR = "stocksDB-Entities";
    protected static final String DB_GUID = "1637a33e-6512-447b-ade7-249c8cb5344b";
    protected static final String TABLE_GUID = "df122fc3-5555-40f8-a30f-3090b8a622f8";
    protected static final String TABLE_TABLE_GUID = "6f3b305a-c459-4ae4-b651-aee0deb0685f";
    protected static final String TABLE_VIEW_GUID = "56415119-7cb0-40dd-ace8-1e50efd54991";
    protected static final String COLUMN_GUID_HIGH = "f87a5320-1529-4369-8d63-b637ebdf2c1c";

    protected void initialize() throws Exception {
        if (GraphSandboxUtil.useLocalSolr()) {
            LocalSolrRunner.start();
        }
    }

    protected void cleanup() throws Exception {
        if (GraphSandboxUtil.useLocalSolr()) {
            LocalSolrRunner.stop();
        }
    }

    protected void basicSetup(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) throws IOException, AtlasBaseException {
        TestLoadModelUtils.loadBaseModel(typeDefStore, typeRegistry);
        TestLoadModelUtils.loadHiveModel(typeDefStore, typeRegistry);
    }

    protected int createEntities(AtlasEntityStoreV2 entityStore, String subDir, String[] entityFileNames) {
        for (String fileName : entityFileNames) {
            TestLoadModelUtils.createAtlasEntity(entityStore, TestLoadModelUtils.loadEntity(subDir, fileName));
        }
        return entityFileNames.length;
    }

    protected void verifyCreatedEntities(AtlasEntityStoreV2 entityStore, String[] entityGuids, int expectedNumberOfEntitiesCreated) {
        try {
            AtlasEntity.AtlasEntitiesWithExtInfo entities = entityStore.getByIds(Arrays.asList(entityGuids));
            Assert.assertEquals((int)entities.getEntities().size(), (int)expectedNumberOfEntitiesCreated);
        }
        catch (AtlasBaseException e) {
            throw new SkipException(String.format("getByIds: could not load '%s'", entityGuids.toString()));
        }
    }

    protected void assertExportImportAuditEntry(ExportImportAuditService auditService) throws InterruptedException {
        this.pauseForIndexCreation();
        List result = null;
        try {
            result = auditService.get("", "", "", "", "", 10, 0);
        }
        catch (Exception e) {
            throw new SkipException("audit entries not retrieved.");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
    }

    protected void pauseForIndexCreation() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            throw new SkipException("pause interrupted.");
        }
    }
}

