/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.query.AtlasDSL;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class DSLParsingTest {
    @DataProvider(name="badDSLProvider")
    public Object[][] getBadDSLQueries() {
        return new Object[][]{{"db orderby(name) orderby(owner)"}, {"db orderby(name) select name, owner orderby(owner)"}, {"db groupby(name) orderby(owner) select name, owner orderby(owner)"}, {"db groupby(name) select name, owner orderby(owner) orderby(owner)"}, {"db select name, owner orderby(owner) orderby(owner)"}, {"db select name, owner orderby(owner) groupby(owner)"}, {"db select name, owner groupby(owner) orderby(owner)"}, {"db groupby(name) groupby(name) select name, owner orderby(owner) orderby(owner)"}};
    }

    @Test(dataProvider="badDSLProvider", expectedExceptions={AtlasBaseException.class})
    public void testInvalidDSL(String query) throws AtlasBaseException {
        AtlasDSL.Parser.parse((String)query);
        Assert.fail((String)"The invalid query parsing should've failed");
    }
}

