/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.query.GremlinQueryComposer;
import org.apache.atlas.query.Lookup;
import org.apache.atlas.query.antlr4.AtlasDSLParser;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.FileAssert;

public class BaseDSLComposer {
    protected final AtlasTypeRegistry registry = (AtlasTypeRegistry)Mockito.mock(AtlasTypeRegistry.class);

    protected AtlasDSLParser.QueryContext getParsedQuery(String query) {
        AtlasDSLParser.QueryContext queryContext = null;
        try {
            queryContext = AtlasDSL.Parser.parse((String)query);
        }
        catch (AtlasBaseException e) {
            FileAssert.fail((String)e.getMessage());
        }
        return queryContext;
    }

    public static class TestLookup
    implements Lookup {
        final AtlasTypeRegistry registry;

        TestLookup(AtlasTypeRegistry typeRegistry) {
            this.registry = typeRegistry;
        }

        public AtlasType getType(String typeName) throws AtlasBaseException {
            AtlasType type;
            if (typeName.equals("PII") || typeName.equals("Dimension")) {
                type = (AtlasType)Mockito.mock(AtlasType.class);
                Mockito.when((Object)type.getTypeCategory()).thenReturn((Object)TypeCategory.CLASSIFICATION);
            } else {
                type = (AtlasType)Mockito.mock(AtlasEntityType.class);
                Mockito.when((Object)type.getTypeCategory()).thenReturn((Object)TypeCategory.ENTITY);
                AtlasStructType.AtlasAttribute attr = (AtlasStructType.AtlasAttribute)Mockito.mock(AtlasStructType.AtlasAttribute.class);
                AtlasStructDef.AtlasAttributeDef def = (AtlasStructDef.AtlasAttributeDef)Mockito.mock(AtlasStructDef.AtlasAttributeDef.class);
                Mockito.when((Object)def.getIndexType()).thenReturn((Object)AtlasStructDef.AtlasAttributeDef.IndexType.DEFAULT);
                Mockito.when((Object)attr.getAttributeDef()).thenReturn((Object)def);
                AtlasStructType.AtlasAttribute attr_s = (AtlasStructType.AtlasAttribute)Mockito.mock(AtlasStructType.AtlasAttribute.class);
                AtlasStructDef.AtlasAttributeDef def_s = (AtlasStructDef.AtlasAttributeDef)Mockito.mock(AtlasStructDef.AtlasAttributeDef.class);
                Mockito.when((Object)def_s.getIndexType()).thenReturn((Object)AtlasStructDef.AtlasAttributeDef.IndexType.STRING);
                Mockito.when((Object)attr_s.getAttributeDef()).thenReturn((Object)def_s);
                Mockito.when((Object)((AtlasEntityType)type).getAttribute(Matchers.anyString())).thenReturn((Object)attr);
                Mockito.when((Object)((AtlasEntityType)type).getAttribute((String)Matchers.eq((Object)"name"))).thenReturn((Object)attr_s);
            }
            if (typeName.equals("PIII")) {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[0]);
            }
            Mockito.when((Object)type.getTypeName()).thenReturn((Object)typeName);
            return type;
        }

        public String getQualifiedName(GremlinQueryComposer.Context context, String name) throws AtlasBaseException {
            if (name.startsWith("__")) {
                return name.equals("__state") || name.equals("__guid") ? name : "";
            }
            if (!this.hasAttribute(context, name)) {
                throw new AtlasBaseException("Invalid attribute");
            }
            if (name.contains(".")) {
                return name;
            }
            if (!context.getActiveTypeName().equals(name)) {
                return String.format("%s.%s", context.getActiveTypeName(), name);
            }
            return name;
        }

        public boolean isPrimitive(GremlinQueryComposer.Context context, String attributeName) {
            return attributeName.equals("name") || attributeName.equals("owner") || attributeName.equals("createTime") || attributeName.equals("clusterName") || attributeName.equals("__guid") || attributeName.equals("__state") || attributeName.equals("partitionSize");
        }

        public String getRelationshipEdgeLabel(GremlinQueryComposer.Context context, String attributeName) {
            if (attributeName.equalsIgnoreCase("columns")) {
                return "__Table.columns";
            }
            if (attributeName.equalsIgnoreCase("db")) {
                return "__Table.db";
            }
            if (attributeName.equalsIgnoreCase("meanings")) {
                return "r:AtlasGlossarySemanticAssignment";
            }
            return "__DB.Table";
        }

        public AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection getRelationshipEdgeDirection(GremlinQueryComposer.Context context, String attributeName) {
            if (attributeName.equalsIgnoreCase("meanings")) {
                return AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.IN;
            }
            return AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT;
        }

        public boolean hasAttribute(GremlinQueryComposer.Context context, String attributeName) {
            return context.getActiveTypeName().equals("Table") && attributeName.equals("db") || context.getActiveTypeName().equals("Table") && attributeName.equals("columns") || context.getActiveTypeName().equals("Table") && attributeName.equals("createTime") || context.getActiveTypeName().equals("Table") && attributeName.equals("name") || context.getActiveTypeName().equals("Table") && attributeName.equals("owner") || context.getActiveTypeName().equals("Table") && attributeName.equals("clusterName") || context.getActiveTypeName().equals("Table") && attributeName.equals("isFile") || context.getActiveTypeName().equals("Table") && attributeName.equals("__guid") || context.getActiveTypeName().equals("Table") && attributeName.equals("__state") || context.getActiveTypeName().equals("Table") && attributeName.equals("partitionSize") || context.getActiveTypeName().equals("Table") && attributeName.equals("meanings") || context.getActiveTypeName().equals("hive_db") && attributeName.equals("name") || context.getActiveTypeName().equals("hive_db") && attributeName.equals("owner") || context.getActiveTypeName().equals("hive_db") && attributeName.equals("createTime") || context.getActiveTypeName().equals("hive_db") && attributeName.equals("description") || context.getActiveTypeName().equals("hive_db") && attributeName.equals("userDescription") || context.getActiveTypeName().equals("hive_column") && attributeName.equals("name") || context.getActiveTypeName().equals("DB") && attributeName.equals("name") || context.getActiveTypeName().equals("DB") && attributeName.equals("owner") || context.getActiveTypeName().equals("DB") && attributeName.equals("clusterName") || context.getActiveTypeName().equals("Asset") && attributeName.equals("name") || context.getActiveTypeName().equals("Asset") && attributeName.equals("owner") || context.getActiveTypeName().equals("AtlasGlossaryTerm") && attributeName.equals("name") || context.getActiveTypeName().equals("AtlasGlossaryTerm") && attributeName.equals("qualifiedName");
        }

        public boolean doesTypeHaveSubTypes(GremlinQueryComposer.Context context) {
            return context.getActiveTypeName().equalsIgnoreCase("Asset");
        }

        public String getTypeAndSubTypes(GremlinQueryComposer.Context context) {
            Object[] str = new String[]{"'Asset'", "'Table'"};
            return StringUtils.join((Object[])str, (String)",");
        }

        public boolean isTraitType(String typeName) {
            return typeName.equals("PII") || typeName.equals("Dimension");
        }

        public String getTypeFromEdge(GremlinQueryComposer.Context context, String item) {
            if (context.getActiveTypeName().equals("DB") && item.equals("Table")) {
                return "Table";
            }
            if (context.getActiveTypeName().equals("Table") && item.equals("Column")) {
                return "Column";
            }
            if (context.getActiveTypeName().equals("Table") && item.equals("db")) {
                return "DB";
            }
            if (context.getActiveTypeName().equals("Table") && item.equals("columns")) {
                return "Column";
            }
            if (context.getActiveTypeName().equals("Table") && item.equals("meanings")) {
                return "AtlasGlossaryTerm";
            }
            if (context.getActiveTypeName().equals(item)) {
                return null;
            }
            return context.getActiveTypeName();
        }

        public boolean isDate(GremlinQueryComposer.Context context, String attributeName) {
            return attributeName.equals("createTime");
        }

        public boolean isNumeric(GremlinQueryComposer.Context context, String attrName) {
            context.setNumericTypeFormatter("f");
            return attrName.equals("partitionSize");
        }

        public String getVertexPropertyName(String typeName, String attrName) {
            if (typeName.equals("Asset") && (attrName.equals("name") || attrName.equals("owner"))) {
                return String.format("%s.__s_%s", typeName, attrName);
            }
            return null;
        }
    }
}

