/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.pc;

import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import org.apache.atlas.pc.WorkItemBuilder;
import org.apache.atlas.pc.WorkItemConsumer;
import org.apache.atlas.pc.WorkItemManager;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class WorkItemManagerWithResultsTest {
    private static final Logger LOG = LoggerFactory.getLogger(WorkItemManagerWithResultsTest.class);

    private WorkItemManager<Integer, WorkItemConsumer> getWorkItemManger(IntegerConsumerBuilder cb, int numWorkers) {
        return new WorkItemManager((WorkItemBuilder)cb, "IntegerConsumer", 5, numWorkers, true);
    }

    @Test
    public void drainTest() throws InterruptedException {
        int maxItems = 50;
        IntegerConsumerBuilder cb = new IntegerConsumerBuilder();
        WorkItemManager<Integer, WorkItemConsumer> wi = this.getWorkItemManger(cb, 5);
        for (int i = 0; i < 50; ++i) {
            wi.produce((Object)i);
        }
        wi.drain();
        Assert.assertEquals((int)wi.getResults().size(), (int)50);
        HashSet set = new HashSet(wi.getResults());
        Assert.assertEquals((int)set.size(), (int)50);
        wi.shutdown();
    }

    @Test
    public void drainCheckProduceTest() throws InterruptedException {
        IntegerConsumerBuilder cb = new IntegerConsumerBuilder();
        WorkItemManager<Integer, WorkItemConsumer> wi = this.getWorkItemManger(cb, 2);
        for (int i = 0; i < 5; ++i) {
            this.repeatedDrainAndProduce(i, wi);
        }
        wi.shutdown();
    }

    private void repeatedDrainAndProduce(int runCount, WorkItemManager<Integer, WorkItemConsumer> wi) {
        int maxItems = 100;
        int halfWay = 50;
        LOG.info("Run: {}", (Object)runCount);
        wi.getResults().clear();
        for (int i = 0; i < 100; ++i) {
            if (i == halfWay) {
                wi.drain();
                HashSet set = new HashSet(wi.getResults());
                Assert.assertEquals((int)wi.getResults().size(), (int)halfWay, (String)"halfWay: total count");
                Assert.assertEquals((int)set.size(), (int)halfWay, (String)"halfWay: set match");
            }
            wi.checkProduce((Object)i);
        }
        wi.drain();
        Assert.assertEquals((int)wi.getResults().size(), (int)100, (String)"total count");
        HashSet set = new HashSet(wi.getResults());
        Assert.assertEquals((int)set.size(), (int)100, (String)"set count");
        for (int i = 100; i < 200; ++i) {
            Assert.assertTrue((boolean)set.contains(i), (String)("Could not test: " + i));
        }
    }

    private class IntegerConsumerBuilder
    implements WorkItemBuilder<IntegerConsumer, Integer> {
        private IntegerConsumerBuilder() {
        }

        public IntegerConsumer build(BlockingQueue<Integer> queue) {
            return new IntegerConsumer(queue);
        }
    }

    private static class IntegerConsumer
    extends WorkItemConsumer<Integer> {
        private static ThreadLocal<Integer> payload = new ThreadLocal();

        public IntegerConsumer(BlockingQueue<Integer> queue) {
            super(queue);
        }

        protected void doCommit() {
            if (this.getPayload() == -1) {
                LOG.debug("Skipping:");
                return;
            }
            this.incrementPayload(100);
            this.addResult(this.getPayload());
            this.setPayload(0);
        }

        protected void processItem(Integer item) {
            try {
                this.setPayload(item);
                Thread.sleep(20 + RandomUtils.nextInt((int)5, (int)7));
                super.commit();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void setPayload(int v) {
            payload.set(v);
        }

        public int getPayload() {
            return payload.get();
        }

        public void incrementPayload(int v) {
            payload.set(payload.get() + v);
        }
    }
}

