/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.glossary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.atlas.glossary.GlossaryService;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PaginationHelperTest {
    @DataProvider
    public Object[][] paginationProvider() {
        return new Object[][]{{10, 0, 5, 5}, {10, 0, -1, 10}, {10, -1, -1, 10}, {10, -1, 5, 5}, {10, -1, 11, 10}, {10, 5, 11, 5}, {10, 2, 11, 8}, {10, 8, 11, 2}, {10, 5, 1, 1}, {10, 9, 1, 1}, {10, 10, 5, 0}, {10, 11, 5, 0}, {10, 20, -1, 0}, {5, 6, -1, 0}, {0, -1, -1, 0}, {0, 5, 10, 0}, {0, 0, 10, 0}, {1, -1, -1, 1}, {1, 5, 10, 0}, {1, 0, 10, 1}};
    }

    @Test(dataProvider="paginationProvider")
    public void testPaginationHelper(int maxSize, int offset, int limit, int expectedSize) {
        List intList = IntStream.range(0, maxSize).boxed().collect(Collectors.toCollection(() -> new ArrayList(maxSize)));
        GlossaryService.PaginationHelper helper = new GlossaryService.PaginationHelper((Collection)intList, offset, limit);
        Assert.assertEquals((int)helper.getPaginatedList().size(), (int)expectedSize);
    }
}

