/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.glossary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.SortOrder;
import org.apache.atlas.TestModules;
import org.apache.atlas.bulkimport.BulkImportResponse;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryService;
import org.apache.atlas.glossary.GlossaryTermUtils;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryCategory;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.enums.AtlasTermRelationshipStatus;
import org.apache.atlas.model.glossary.relations.AtlasGlossaryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedCategoryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.glossary.relations.AtlasTermAssignmentHeader;
import org.apache.atlas.model.glossary.relations.AtlasTermCategorizationHeader;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.FileUtils;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.TestLoadModelUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class GlossaryServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryServiceTest.class);
    @Inject
    private GlossaryService glossaryService;
    @Inject
    private AtlasTypeDefStore typeDefStore;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private AtlasEntityStore entityStore;
    private AtlasGlossary bankGlossary;
    private AtlasGlossary creditUnionGlossary;
    private AtlasGlossary debitUnionGlossary;
    private AtlasGlossaryTerm checkingAccount;
    private AtlasGlossaryTerm savingsAccount;
    private AtlasGlossaryTerm fixedRateMortgage;
    private AtlasGlossaryTerm adjustableRateMortgage;
    private AtlasGlossaryTerm currentAccount;
    private AtlasGlossaryCategory customerCategory;
    private AtlasGlossaryCategory accountCategory;
    private AtlasGlossaryCategory mortgageCategory;
    private AtlasGlossaryCategory loanCategory;
    private AtlasRelatedObjectId relatedObjectId;
    @Inject
    private AtlasDiscoveryService discoveryService;
    public static final String CSV_FILES = "/csvFiles/";
    public static final String EXCEL_FILES = "/excelFiles/";

    @DataProvider
    public static Object[][] getGlossaryTermsProvider() {
        return new Object[][]{{0, -1, 8}, {0, 2, 2}, {2, 6, 6}};
    }

    @BeforeClass
    public void setupSampleGlossary() {
        try {
            TestLoadModelUtils.loadAllModels("0000-Area0", this.typeDefStore, this.typeRegistry);
        }
        catch (IOException | AtlasBaseException e) {
            throw new SkipException("SubjectArea model loading failed");
        }
        try {
            AtlasClassificationDef classificationDef = new AtlasClassificationDef("TestClassification", "Test only classification");
            AtlasTypesDef typesDef = new AtlasTypesDef();
            typesDef.setClassificationDefs(Arrays.asList(classificationDef));
            this.typeDefStore.createTypesDef(typesDef);
        }
        catch (AtlasBaseException e) {
            throw new SkipException("Test classification creation failed");
        }
        this.bankGlossary = new AtlasGlossary();
        this.bankGlossary.setQualifiedName("testBankingGlossary");
        this.bankGlossary.setName("Banking glossary");
        this.bankGlossary.setShortDescription("Short description");
        this.bankGlossary.setLongDescription("Long description");
        this.bankGlossary.setUsage("N/A");
        this.bankGlossary.setLanguage("en-US");
        this.creditUnionGlossary = new AtlasGlossary();
        this.creditUnionGlossary.setQualifiedName("testCreditUnionGlossary");
        this.creditUnionGlossary.setName("Credit union glossary");
        this.creditUnionGlossary.setShortDescription("Short description");
        this.creditUnionGlossary.setLongDescription("Long description");
        this.creditUnionGlossary.setUsage("N/A");
        this.creditUnionGlossary.setLanguage("en-US");
        this.debitUnionGlossary = new AtlasGlossary();
        this.debitUnionGlossary.setName("<Debit union glossary");
        this.debitUnionGlossary.setShortDescription("Short description");
        this.debitUnionGlossary.setLongDescription("Long description");
        this.debitUnionGlossary.setUsage("N/A");
        this.debitUnionGlossary.setLanguage("en-US");
        this.accountCategory = new AtlasGlossaryCategory();
        this.accountCategory.setName("Account categorization");
        this.accountCategory.setShortDescription("Short description");
        this.accountCategory.setLongDescription("Long description");
        this.customerCategory = new AtlasGlossaryCategory();
        this.customerCategory.setQualifiedName("customer@testBankingGlossary");
        this.customerCategory.setName("Customer category");
        this.customerCategory.setShortDescription("Short description");
        this.customerCategory.setLongDescription("Long description");
        this.mortgageCategory = new AtlasGlossaryCategory();
        this.mortgageCategory.setName("Mortgage categorization");
        this.mortgageCategory.setShortDescription("Short description");
        this.mortgageCategory.setLongDescription("Long description");
        this.loanCategory = new AtlasGlossaryCategory();
        this.loanCategory.setName("Loan categorization>");
        this.loanCategory.setShortDescription("Short description");
        this.loanCategory.setLongDescription("Long description");
        this.checkingAccount = new AtlasGlossaryTerm();
        this.checkingAccount.setName("A checking account");
        this.checkingAccount.setShortDescription("Short description");
        this.checkingAccount.setLongDescription("Long description");
        this.checkingAccount.setAbbreviation("CHK");
        this.checkingAccount.setExamples(Arrays.asList("Personal", "Joint"));
        this.checkingAccount.setUsage("N/A");
        this.savingsAccount = new AtlasGlossaryTerm();
        this.savingsAccount.setQualifiedName("sav_acc@testBankingGlossary");
        this.savingsAccount.setName("A savings account");
        this.savingsAccount.setShortDescription("Short description");
        this.savingsAccount.setLongDescription("Long description");
        this.savingsAccount.setAbbreviation("SAV");
        this.savingsAccount.setExamples(Arrays.asList("Personal", "Joint"));
        this.savingsAccount.setUsage("N/A");
        this.fixedRateMortgage = new AtlasGlossaryTerm();
        this.fixedRateMortgage.setName("Conventional mortgage");
        this.fixedRateMortgage.setShortDescription("Short description");
        this.fixedRateMortgage.setLongDescription("Long description");
        this.fixedRateMortgage.setAbbreviation("FMTG");
        this.fixedRateMortgage.setExamples(Arrays.asList("15-yr", "30-yr"));
        this.fixedRateMortgage.setUsage("N/A");
        this.adjustableRateMortgage = new AtlasGlossaryTerm();
        this.adjustableRateMortgage.setQualifiedName("arm_mtg@testBankingGlossary");
        this.adjustableRateMortgage.setName("ARM loans");
        this.adjustableRateMortgage.setShortDescription("Short description");
        this.adjustableRateMortgage.setLongDescription("Long description");
        this.adjustableRateMortgage.setAbbreviation("ARMTG");
        this.adjustableRateMortgage.setExamples(Arrays.asList("5/1", "7/1", "10/1"));
        this.adjustableRateMortgage.setUsage("N/A");
        this.currentAccount = new AtlasGlossaryTerm();
        this.currentAccount.setName("current@account");
        this.currentAccount.setShortDescription("Short description");
        this.currentAccount.setLongDescription("Long description");
        this.currentAccount.setAbbreviation("CURR");
        this.currentAccount.setExamples(Arrays.asList("Personal", "Joint"));
        this.currentAccount.setUsage("N/A");
    }

    @Test(groups={"Glossary.CREATE"})
    public void testCreateGlossary() {
        List glossaryCategories;
        try {
            AtlasGlossary created = this.glossaryService.createGlossary(this.bankGlossary);
            this.bankGlossary.setGuid(created.getGuid());
            created = this.glossaryService.createGlossary(this.creditUnionGlossary);
            this.creditUnionGlossary.setGuid(created.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary creation should've succeeded", (Throwable)e);
        }
        try {
            this.glossaryService.createGlossary(this.bankGlossary);
            Assert.fail((String)"Glossary duplicate creation should've failed");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.GLOSSARY_ALREADY_EXISTS);
        }
        try {
            this.glossaryService.createGlossary(this.creditUnionGlossary);
            Assert.fail((String)"Glossary duplicate creation should've failed");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.GLOSSARY_ALREADY_EXISTS);
        }
        try {
            this.glossaryService.createGlossary(this.debitUnionGlossary);
            Assert.fail((String)"Invalid glossary creation should've failed");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_DISPLAY_NAME);
        }
        try {
            glossaryCategories = this.glossaryService.getGlossaryCategoriesHeaders(this.bankGlossary.getGuid(), 0, 10, SortOrder.ASCENDING);
            Assert.assertNotNull((Object)glossaryCategories);
            Assert.assertEquals((int)glossaryCategories.size(), (int)0);
            glossaryCategories = this.glossaryService.getGlossaryCategoriesHeaders(this.creditUnionGlossary.getGuid(), 0, 10, SortOrder.ASCENDING);
            Assert.assertNotNull((Object)glossaryCategories);
            Assert.assertEquals((int)glossaryCategories.size(), (int)0);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Get glossary categories calls should've succeeded", (Throwable)e);
        }
        try {
            glossaryCategories = this.glossaryService.getGlossaryTermsHeaders(this.bankGlossary.getGuid(), 0, 10, SortOrder.ASCENDING);
            Assert.assertNotNull((Object)glossaryCategories);
            Assert.assertEquals((int)glossaryCategories.size(), (int)0);
            glossaryCategories = this.glossaryService.getGlossaryTermsHeaders(this.creditUnionGlossary.getGuid(), 0, 10, SortOrder.ASCENDING);
            Assert.assertNotNull((Object)glossaryCategories);
            Assert.assertEquals((int)glossaryCategories.size(), (int)0);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Get glossary categories calls should've succeeded", (Throwable)e);
        }
        AtlasGlossaryHeader glossaryId = new AtlasGlossaryHeader();
        glossaryId.setGlossaryGuid(this.bankGlossary.getGuid());
        this.checkingAccount.setAnchor(glossaryId);
        this.savingsAccount.setAnchor(glossaryId);
        this.fixedRateMortgage.setAnchor(glossaryId);
        this.adjustableRateMortgage.setAnchor(glossaryId);
        this.currentAccount.setAnchor(glossaryId);
        this.accountCategory.setAnchor(glossaryId);
        this.customerCategory.setAnchor(glossaryId);
        this.mortgageCategory.setAnchor(glossaryId);
        this.loanCategory.setAnchor(glossaryId);
    }

    @Test(groups={"Glossary.CREATE"}, dependsOnMethods={"testCategoryCreation"})
    public void testTermCreationWithoutAnyRelations() {
        try {
            this.checkingAccount = this.glossaryService.createTerm(this.checkingAccount);
            Assert.assertNotNull((Object)this.checkingAccount);
            Assert.assertNotNull((Object)this.checkingAccount.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term creation should've succeeded", (Throwable)e);
        }
        try {
            this.glossaryService.createTerm(this.currentAccount);
            Assert.fail((String)"Invalid term creation should've failed");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_DISPLAY_NAME);
        }
    }

    @Test(groups={"Glossary.CREATE"}, dependsOnMethods={"testTermCreationWithoutAnyRelations"})
    public void testTermCreateWithRelation() {
        try {
            AtlasRelatedTermHeader relatedTermHeader = new AtlasRelatedTermHeader();
            relatedTermHeader.setTermGuid(this.checkingAccount.getGuid());
            relatedTermHeader.setDescription("test description");
            relatedTermHeader.setExpression("test expression");
            relatedTermHeader.setSource("UT");
            relatedTermHeader.setSteward("UT");
            relatedTermHeader.setStatus(AtlasTermRelationshipStatus.ACTIVE);
            this.savingsAccount.setSeeAlso(Collections.singleton(relatedTermHeader));
            this.savingsAccount = this.glossaryService.createTerm(this.savingsAccount);
            Assert.assertNotNull((Object)this.savingsAccount);
            Assert.assertNotNull((Object)this.savingsAccount.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term creation with relation should've succeeded", (Throwable)e);
        }
    }

    @Test(groups={"Glossary.UPDATE"}, dependsOnGroups={"Glossary.CREATE"})
    public void testTermAfterEntityIsDeleted() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("Asset");
        AtlasTermAssignmentHeader loan = new AtlasTermAssignmentHeader();
        loan.setTermGuid(this.fixedRateMortgage.getGuid());
        loan.setRelationGuid(this.fixedRateMortgage.getAnchor().getRelationGuid());
        loan.setQualifiedName(this.fixedRateMortgage.getQualifiedName());
        AtlasEntity assetEntity = new AtlasEntity("Asset");
        assetEntity.setAttribute("qualifiedName", (Object)"testAsset");
        assetEntity.setAttribute("name", (Object)"testAsset");
        assetEntity.addMeaning(loan);
        try {
            EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(assetEntity), false);
            AtlasEntityHeader firstEntityCreated = response.getFirstEntityCreated();
            this.relatedObjectId = new AtlasRelatedObjectId();
            this.relatedObjectId.setGuid(firstEntityCreated.getGuid());
            this.relatedObjectId.setTypeName(firstEntityCreated.getTypeName());
            Assert.assertNotNull((Object)this.relatedObjectId);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Entity creation should've succeeded", (Throwable)e);
        }
        try {
            this.glossaryService.assignTermToEntities(this.fixedRateMortgage.getGuid(), Arrays.asList(this.relatedObjectId));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term assignment to asset should've succeeded", (Throwable)e);
        }
        try {
            this.entityStore.deleteById(this.relatedObjectId.getGuid());
            List entityHeaders = this.discoveryService.searchWithParameters(params).getEntities();
            Assert.assertNotNull((Object)AtlasType.toJson((Object)((AtlasEntityHeader)entityHeaders.get(0)).getMeaningNames()));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Entity delete should've succeeded");
        }
    }

    @Test(groups={"Glossary.CREATE"}, dependsOnMethods={"testCategoryCreation"})
    public void testTermCreationWithCategory() {
        try {
            AtlasTermCategorizationHeader termCategorizationHeader = new AtlasTermCategorizationHeader();
            termCategorizationHeader.setCategoryGuid(this.mortgageCategory.getGuid());
            termCategorizationHeader.setDescription("Test description");
            termCategorizationHeader.setStatus(AtlasTermRelationshipStatus.DRAFT);
            this.fixedRateMortgage.setCategories(Collections.singleton(termCategorizationHeader));
            this.adjustableRateMortgage.setCategories(Collections.singleton(termCategorizationHeader));
            List terms = this.glossaryService.createTerms(Arrays.asList(this.fixedRateMortgage, this.adjustableRateMortgage));
            this.fixedRateMortgage.setGuid(((AtlasGlossaryTerm)terms.get(0)).getGuid());
            this.adjustableRateMortgage.setGuid(((AtlasGlossaryTerm)terms.get(1)).getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term creation should've succeeded", (Throwable)e);
        }
    }

    @Test(groups={"Glossary.CREATE"}, dependsOnMethods={"testCreateGlossary"})
    public void testCategoryCreation() {
        try {
            this.customerCategory = this.glossaryService.createCategory(this.customerCategory);
            AtlasRelatedCategoryHeader parentHeader = new AtlasRelatedCategoryHeader();
            parentHeader.setCategoryGuid(this.customerCategory.getGuid());
            this.accountCategory.setParentCategory(parentHeader);
            List categories = this.glossaryService.createCategories(Arrays.asList(this.accountCategory, this.mortgageCategory));
            this.accountCategory.setGuid(((AtlasGlossaryCategory)categories.get(0)).getGuid());
            Assert.assertNotNull((Object)this.accountCategory.getParentCategory());
            Assert.assertEquals((String)this.accountCategory.getParentCategory().getCategoryGuid(), (String)this.customerCategory.getGuid());
            Assert.assertTrue((boolean)this.accountCategory.getQualifiedName().endsWith(this.customerCategory.getQualifiedName()));
            this.mortgageCategory.setGuid(((AtlasGlossaryCategory)categories.get(1)).getGuid());
            Assert.assertNull((Object)this.mortgageCategory.getParentCategory());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Category creation should've succeeded", (Throwable)e);
        }
        try {
            this.glossaryService.createCategory(this.loanCategory);
            Assert.fail((String)"Invalid category creation should've failed");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_DISPLAY_NAME);
        }
    }

    @DataProvider
    public Object[][] getAllGlossaryDataProvider() {
        return new Object[][]{{1, 0, SortOrder.ASCENDING, 1}, {5, 0, SortOrder.ASCENDING, 2}, {10, 0, SortOrder.ASCENDING, 2}, {1, 1, SortOrder.ASCENDING, 1}, {5, 1, SortOrder.ASCENDING, 1}, {10, 1, SortOrder.ASCENDING, 1}, {1, 2, SortOrder.ASCENDING, 0}, {5, 2, SortOrder.ASCENDING, 0}, {10, 2, SortOrder.ASCENDING, 0}};
    }

    @Test(dataProvider="getAllGlossaryDataProvider", groups={"Glossary.GET"}, dependsOnGroups={"Glossary.CREATE"})
    public void testGetAllGlossaries(int limit, int offset, SortOrder sortOrder, int expected) {
        try {
            List glossaries = this.glossaryService.getGlossaries(limit, offset, sortOrder);
            Assert.assertEquals((int)glossaries.size(), (int)expected);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Get glossaries should've succeeded", (Throwable)e);
        }
    }

    @Test(groups={"Glossary.UPDATE"}, dependsOnGroups={"Glossary.CREATE"})
    public void testUpdateGlossary() {
        try {
            this.bankGlossary = this.glossaryService.getGlossary(this.bankGlossary.getGuid());
            this.bankGlossary.setShortDescription("Updated short description");
            this.bankGlossary.setLongDescription("Updated long description");
            AtlasGlossary updatedGlossary = this.glossaryService.updateGlossary(this.bankGlossary);
            Assert.assertNotNull((Object)updatedGlossary);
            Assert.assertEquals((String)updatedGlossary.getGuid(), (String)this.bankGlossary.getGuid());
            ArrayList a = new ArrayList(updatedGlossary.getCategories());
            ArrayList b = new ArrayList(this.bankGlossary.getCategories());
            Assert.assertEquals(a, b);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary fetch/update should've succeeded", (Throwable)e);
        }
        try {
            this.debitUnionGlossary.setName("Test Glossary Update");
            this.debitUnionGlossary = this.glossaryService.createGlossary(this.debitUnionGlossary);
            Assert.assertNotNull((Object)this.debitUnionGlossary);
            this.debitUnionGlossary.setName("<test glossary create>");
            this.glossaryService.updateGlossary(this.debitUnionGlossary);
            Assert.fail((String)"Invalid glossary update should've failed");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_DISPLAY_NAME);
        }
    }

    @Test(dependsOnGroups={"Glossary.MIGRATE"})
    public void testInvalidFetches() {
        try {
            this.glossaryService.getGlossary(this.mortgageCategory.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.UNEXPECTED_TYPE);
        }
        try {
            this.glossaryService.getTerm(this.bankGlossary.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.UNEXPECTED_TYPE);
        }
        try {
            this.glossaryService.getCategory(this.savingsAccount.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.UNEXPECTED_TYPE);
        }
    }

    @Test(dependsOnMethods={"testInvalidFetches"})
    public void testDeleteGlossary() {
        try {
            this.glossaryService.deleteGlossary(this.bankGlossary.getGuid());
            try {
                this.glossaryService.getGlossary(this.bankGlossary.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_GUID_NOT_FOUND);
            }
            try {
                this.glossaryService.getTerm(this.fixedRateMortgage.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_GUID_NOT_FOUND);
            }
            try {
                this.glossaryService.getTerm(this.adjustableRateMortgage.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_GUID_NOT_FOUND);
            }
            try {
                this.glossaryService.getTerm(this.savingsAccount.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_GUID_NOT_FOUND);
            }
            try {
                this.glossaryService.getTerm(this.checkingAccount.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_GUID_NOT_FOUND);
            }
            try {
                this.glossaryService.getCategory(this.customerCategory.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_GUID_NOT_FOUND);
            }
            try {
                this.glossaryService.getCategory(this.accountCategory.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_GUID_NOT_FOUND);
            }
            try {
                this.glossaryService.getCategory(this.mortgageCategory.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INSTANCE_GUID_NOT_FOUND);
            }
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary delete should've succeeded", (Throwable)e);
        }
    }

    @Test(groups={"Glossary.UPDATE"}, dependsOnGroups={"Glossary.CREATE"})
    public void testUpdateGlossaryTerm() {
        ArrayList<AtlasGlossaryTerm> glossaryTerms = new ArrayList<AtlasGlossaryTerm>();
        AtlasClassification classification = new AtlasClassification("TestClassification");
        for (AtlasGlossaryTerm term : Arrays.asList(this.checkingAccount, this.savingsAccount, this.fixedRateMortgage, this.adjustableRateMortgage)) {
            try {
                glossaryTerms.add(this.glossaryService.getTerm(term.getGuid()));
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Fetch of GlossaryTerm should've succeeded", (Throwable)e);
            }
        }
        for (AtlasGlossaryTerm t : glossaryTerms) {
            try {
                t.setShortDescription("Updated short description");
                t.setLongDescription("Updated long description");
                this.entityStore.addClassifications(t.getGuid(), Arrays.asList(classification));
                AtlasGlossaryTerm updatedTerm = this.glossaryService.updateTerm(t);
                Assert.assertNotNull((Object)updatedTerm);
                Assert.assertEquals((String)updatedTerm.getGuid(), (String)t.getGuid());
                Assert.assertNotNull((Object)updatedTerm.getClassifications());
                Assert.assertEquals((int)updatedTerm.getClassifications().size(), (int)1);
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Glossary term fetch/update should've succeeded", (Throwable)e);
            }
        }
        try {
            this.currentAccount.setName("Test term update");
            this.currentAccount = this.glossaryService.createTerm(this.currentAccount);
            this.currentAccount.setName("<Test term update>");
            this.glossaryService.updateTerm(this.currentAccount);
            Assert.fail((String)"Invalid term update should've failed");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_DISPLAY_NAME);
        }
    }

    @Test(groups={"Glossary.UPDATE"}, dependsOnGroups={"Glossary.CREATE"})
    public void testUpdateGlossaryCategory() {
        ArrayList<AtlasGlossaryCategory> glossaryCategories = new ArrayList<AtlasGlossaryCategory>();
        for (AtlasGlossaryCategory glossaryCategory : Arrays.asList(this.customerCategory, this.accountCategory, this.mortgageCategory)) {
            try {
                glossaryCategories.add(this.glossaryService.getCategory(glossaryCategory.getGuid()));
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Category fetch should've succeeded", (Throwable)e);
            }
        }
        for (AtlasGlossaryCategory c : glossaryCategories) {
            try {
                c.setShortDescription("Updated short description");
                c.setLongDescription("Updated long description");
                AtlasGlossaryCategory updatedCategory = this.glossaryService.updateCategory(c);
                Assert.assertNotNull((Object)updatedCategory);
                Assert.assertEquals((String)updatedCategory.getGuid(), (String)c.getGuid());
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Glossary category fetching should've succeeded", (Throwable)e);
            }
        }
        try {
            this.customerCategory = this.glossaryService.getCategory(this.customerCategory.getGuid());
            this.customerCategory.setChildrenCategories(null);
            this.customerCategory = this.glossaryService.updateCategory(this.customerCategory);
            Assert.assertNotNull((Object)this.customerCategory);
            Assert.assertNull((Object)this.customerCategory.getChildrenCategories());
            this.accountCategory = this.glossaryService.getCategory(this.accountCategory.getGuid());
            Assert.assertNull((Object)this.accountCategory.getParentCategory());
            Assert.assertTrue((boolean)this.accountCategory.getQualifiedName().endsWith(this.bankGlossary.getQualifiedName()));
            this.mortgageCategory = this.glossaryService.getCategory(this.mortgageCategory.getGuid());
            Assert.assertNull((Object)this.mortgageCategory.getParentCategory());
            Assert.assertTrue((boolean)this.mortgageCategory.getQualifiedName().endsWith(this.bankGlossary.getQualifiedName()));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Customer category fetch should've succeeded");
        }
        try {
            this.loanCategory.setName("Test category update");
            this.loanCategory = this.glossaryService.createCategory(this.loanCategory);
            this.loanCategory.setName("<Test category update>");
            this.glossaryService.updateCategory(this.loanCategory);
            Assert.fail((String)"Invalid category update should've failed");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((Object)e.getAtlasErrorCode(), (Object)AtlasErrorCode.INVALID_DISPLAY_NAME);
        }
    }

    @Test(groups={"Glossary.MIGRATE"}, dependsOnGroups={"Glossary.GET.postUpdate"})
    public void testTermMigration() {
        Assert.assertNotNull((Object)this.creditUnionGlossary);
        AtlasGlossaryHeader newGlossaryHeader = new AtlasGlossaryHeader();
        newGlossaryHeader.setGlossaryGuid(this.creditUnionGlossary.getGuid());
        try {
            this.checkingAccount = this.glossaryService.getTerm(this.checkingAccount.getGuid());
            this.savingsAccount = this.glossaryService.getTerm(this.savingsAccount.getGuid());
            this.checkingAccount.setAnchor(newGlossaryHeader);
            this.checkingAccount.setSeeAlso(null);
            this.savingsAccount.setAnchor(newGlossaryHeader);
            this.savingsAccount.setSeeAlso(null);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term fetch for migration should've succeeded", (Throwable)e);
        }
        try {
            this.checkingAccount = this.glossaryService.updateTerm(this.checkingAccount);
            Assert.assertNotNull((Object)this.checkingAccount);
            Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.checkingAccount.getSeeAlso()));
            this.savingsAccount = this.glossaryService.updateTerm(this.savingsAccount);
            Assert.assertNotNull((Object)this.savingsAccount);
            Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.savingsAccount.getSeeAlso()));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term anchor change should've succeeded", (Throwable)e);
        }
        try {
            List terms = this.glossaryService.getGlossaryTermsHeaders(this.creditUnionGlossary.getGuid(), 0, 5, SortOrder.ASCENDING);
            Assert.assertNotNull((Object)terms);
            Assert.assertEquals((int)terms.size(), (int)2);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term fetch for glossary should've succeeded", (Throwable)e);
        }
    }

    @Test(groups={"Glossary.MIGRATE"}, dependsOnGroups={"Glossary.GET.postUpdate"})
    public void testCategoryMigration() {
        Assert.assertNotNull((Object)this.creditUnionGlossary);
        AtlasGlossaryHeader newGlossaryHeader = new AtlasGlossaryHeader();
        newGlossaryHeader.setGlossaryGuid(this.creditUnionGlossary.getGuid());
        try {
            this.customerCategory = this.glossaryService.getCategory(this.customerCategory.getGuid());
            this.mortgageCategory = this.glossaryService.getCategory(this.mortgageCategory.getGuid());
            this.accountCategory = this.glossaryService.getCategory(this.accountCategory.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Category fetch for migration should've succeeded");
        }
        this.customerCategory.setAnchor(newGlossaryHeader);
        this.mortgageCategory.setAnchor(newGlossaryHeader);
        this.accountCategory.setAnchor(newGlossaryHeader);
        try {
            this.customerCategory = this.glossaryService.updateCategory(this.customerCategory);
            this.mortgageCategory = this.glossaryService.updateCategory(this.mortgageCategory);
            this.accountCategory = this.glossaryService.updateCategory(this.accountCategory);
            Assert.assertTrue((boolean)this.customerCategory.getQualifiedName().endsWith(this.creditUnionGlossary.getQualifiedName()));
            Assert.assertEquals((String)this.customerCategory.getAnchor().getGlossaryGuid(), (String)newGlossaryHeader.getGlossaryGuid());
            Assert.assertTrue((boolean)this.accountCategory.getQualifiedName().endsWith(this.creditUnionGlossary.getQualifiedName()));
            Assert.assertEquals((String)this.accountCategory.getAnchor().getGlossaryGuid(), (String)newGlossaryHeader.getGlossaryGuid());
            Assert.assertTrue((boolean)this.mortgageCategory.getQualifiedName().endsWith(this.creditUnionGlossary.getQualifiedName()));
            Assert.assertEquals((String)this.mortgageCategory.getAnchor().getGlossaryGuid(), (String)newGlossaryHeader.getGlossaryGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Category anchor change should've succeeded");
        }
        try {
            List categories = this.glossaryService.getGlossaryCategoriesHeaders(this.creditUnionGlossary.getGuid(), 0, 5, SortOrder.ASCENDING);
            Assert.assertNotNull((Object)categories);
            Assert.assertEquals((int)categories.size(), (int)3);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Category migration should've succeeded", (Throwable)e);
        }
        AtlasRelatedCategoryHeader child1 = new AtlasRelatedCategoryHeader();
        child1.setCategoryGuid(this.accountCategory.getGuid());
        AtlasRelatedCategoryHeader child2 = new AtlasRelatedCategoryHeader();
        child2.setCategoryGuid(this.mortgageCategory.getGuid());
        this.customerCategory.addChild(child1);
        this.customerCategory.addChild(child2);
        try {
            this.customerCategory = this.glossaryService.updateCategory(this.customerCategory);
            Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)this.customerCategory.getChildrenCategories()));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Children addition to Category should've succeeded");
        }
        this.customerCategory.setAnchor(newGlossaryHeader);
        newGlossaryHeader.setGlossaryGuid(this.bankGlossary.getGuid());
        try {
            this.customerCategory = this.glossaryService.getCategory(this.customerCategory.getGuid());
            Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)this.customerCategory.getChildrenCategories()));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Category fetch should've succeeded");
        }
        try {
            this.accountCategory = this.glossaryService.getCategory(this.accountCategory.getGuid());
            Assert.assertEquals((String)this.accountCategory.getAnchor().getGlossaryGuid(), (String)this.customerCategory.getAnchor().getGlossaryGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Category fetch should've succeeded");
        }
        try {
            this.mortgageCategory = this.glossaryService.getCategory(this.mortgageCategory.getGuid());
            Assert.assertEquals((String)this.mortgageCategory.getAnchor().getGlossaryGuid(), (String)this.customerCategory.getAnchor().getGlossaryGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Category fetch should've succeeded");
        }
    }

    @Test(groups={"Glossary.UPDATE"}, dependsOnGroups={"Glossary.CREATE"})
    public void testAddTermsToCategory() {
        AtlasGlossaryCategory updated;
        AtlasRelatedTermHeader relatedTermId;
        AtlasGlossaryTerm termEntry;
        Assert.assertNotNull((Object)this.accountCategory);
        try {
            this.accountCategory = this.glossaryService.getCategory(this.accountCategory.getGuid());
            Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.accountCategory.getTerms()));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Fetch of accountCategory should've succeeded", (Throwable)e);
        }
        for (AtlasGlossaryTerm term : Arrays.asList(this.checkingAccount, this.savingsAccount)) {
            try {
                termEntry = this.glossaryService.getTerm(term.getGuid());
                relatedTermId = new AtlasRelatedTermHeader();
                relatedTermId.setTermGuid(termEntry.getGuid());
                relatedTermId.setStatus(AtlasTermRelationshipStatus.ACTIVE);
                relatedTermId.setSteward("UT");
                relatedTermId.setSource("UT");
                relatedTermId.setExpression("N/A");
                relatedTermId.setDescription("Categorization under account category");
                this.accountCategory.addTerm(relatedTermId);
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Term fetching should've succeeded", (Throwable)e);
            }
        }
        try {
            updated = this.glossaryService.updateCategory(this.accountCategory);
            Assert.assertNotNull((Object)updated.getTerms());
            Assert.assertEquals((int)updated.getTerms().size(), (int)2);
            this.accountCategory = updated;
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary category update should've succeeded", (Throwable)e);
        }
        Assert.assertNotNull((Object)this.accountCategory);
        try {
            this.accountCategory = this.glossaryService.getCategory(this.accountCategory.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Fetch of accountCategory should've succeeded", (Throwable)e);
        }
        for (AtlasGlossaryTerm term : Arrays.asList(this.fixedRateMortgage, this.adjustableRateMortgage)) {
            try {
                termEntry = this.glossaryService.getTerm(term.getGuid());
                relatedTermId = new AtlasRelatedTermHeader();
                relatedTermId.setTermGuid(termEntry.getGuid());
                relatedTermId.setStatus(AtlasTermRelationshipStatus.ACTIVE);
                relatedTermId.setSteward("UT");
                relatedTermId.setSource("UT");
                relatedTermId.setExpression("N/A");
                relatedTermId.setDescription("Categorization under mortgage category");
                this.mortgageCategory.addTerm(relatedTermId);
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Term fetching should've succeeded", (Throwable)e);
            }
        }
        try {
            updated = this.glossaryService.updateCategory(this.mortgageCategory);
            Assert.assertNotNull((Object)updated.getTerms());
            Assert.assertEquals((int)updated.getTerms().size(), (int)2);
            this.mortgageCategory = updated;
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary category update should've succeeded", (Throwable)e);
        }
    }

    @Test(groups={"Glossary.UPDATE"}, dependsOnGroups={"Glossary.CREATE"})
    public void testAddGlossaryCategoryChildren() {
        Assert.assertNotNull((Object)this.customerCategory);
        try {
            this.customerCategory = this.glossaryService.getCategory(this.customerCategory.getGuid());
            Assert.assertNull((Object)this.customerCategory.getParentCategory());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Fetch of accountCategory should've succeeded", (Throwable)e);
        }
        AtlasRelatedCategoryHeader id = new AtlasRelatedCategoryHeader();
        id.setCategoryGuid(this.mortgageCategory.getGuid());
        id.setDescription("Sub-category of customer");
        this.customerCategory.addChild(id);
        try {
            AtlasGlossaryCategory updateGlossaryCategory = this.glossaryService.updateCategory(this.customerCategory);
            Assert.assertNull((Object)updateGlossaryCategory.getParentCategory());
            Assert.assertNotNull((Object)updateGlossaryCategory.getChildrenCategories());
            LOG.debug(AtlasJson.toJson((Object)updateGlossaryCategory));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Sub category addition should've succeeded", (Throwable)e);
        }
        for (AtlasGlossaryCategory childCategory : Arrays.asList(this.accountCategory, this.mortgageCategory)) {
            try {
                AtlasGlossaryCategory child = this.glossaryService.getCategory(childCategory.getGuid());
                Assert.assertNotNull((Object)child);
                Assert.assertNotNull((Object)child.getParentCategory());
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Category fetch should've been a success", (Throwable)e);
            }
        }
    }

    @Test(groups={"Glossary.UPDATE"}, dependsOnGroups={"Glossary.CREATE"})
    public void testTermAssignmentAndDissociation() {
        AtlasEntity assetEntity = new AtlasEntity("Asset");
        assetEntity.setAttribute("qualifiedName", (Object)"testAsset");
        assetEntity.setAttribute("name", (Object)"testAsset");
        try {
            EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(assetEntity), false);
            AtlasEntityHeader firstEntityCreated = response.getFirstEntityCreated();
            this.relatedObjectId = new AtlasRelatedObjectId();
            this.relatedObjectId.setGuid(firstEntityCreated.getGuid());
            this.relatedObjectId.setTypeName(firstEntityCreated.getTypeName());
            Assert.assertNotNull((Object)this.relatedObjectId);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Entity creation should've succeeded", (Throwable)e);
        }
        try {
            this.glossaryService.assignTermToEntities(this.fixedRateMortgage.getGuid(), Arrays.asList(this.relatedObjectId));
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term assignment to asset should've succeeded", (Throwable)e);
        }
        try {
            List assignedEntities = this.glossaryService.getAssignedEntities(this.fixedRateMortgage.getGuid(), 0, 1, SortOrder.ASCENDING);
            Assert.assertNotNull((Object)assignedEntities);
            Assert.assertEquals((int)assignedEntities.size(), (int)1);
            String relationshipGuid = ((AtlasRelatedObjectId)assignedEntities.get(0)).getRelationshipGuid();
            Assert.assertNotNull((Object)relationshipGuid);
            this.relatedObjectId.setRelationshipGuid(relationshipGuid);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term fetch should've succeeded", (Throwable)e);
        }
        try {
            this.glossaryService.removeTermFromEntities(this.fixedRateMortgage.getGuid(), Arrays.asList(this.relatedObjectId));
            AtlasGlossaryTerm term = this.glossaryService.getTerm(this.fixedRateMortgage.getGuid());
            Assert.assertNotNull((Object)term);
            Assert.assertNull((Object)term.getAssignedEntities());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Term update should've succeeded", (Throwable)e);
        }
        try {
            this.entityStore.deleteById(this.relatedObjectId.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Entity delete should've succeeded");
        }
    }

    @Test(groups={"Glossary.UPDATE"}, dependsOnGroups={"Glossary.CREATE"})
    public void testTermRelation() {
        AtlasRelatedTermHeader relatedTerm = new AtlasRelatedTermHeader();
        relatedTerm.setTermGuid(this.savingsAccount.getGuid());
        relatedTerm.setStatus(AtlasTermRelationshipStatus.DRAFT);
        relatedTerm.setSteward("UT");
        relatedTerm.setSource("UT");
        relatedTerm.setExpression("N/A");
        relatedTerm.setDescription("Related term");
        Assert.assertNotNull((Object)this.checkingAccount);
        try {
            this.checkingAccount = this.glossaryService.getTerm(this.checkingAccount.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary term fetch should've been a success", (Throwable)e);
        }
        this.checkingAccount.setSeeAlso(new HashSet<AtlasRelatedTermHeader>(Arrays.asList(relatedTerm)));
        try {
            this.checkingAccount = this.glossaryService.updateTerm(this.checkingAccount);
            Assert.assertNotNull((Object)this.checkingAccount.getSeeAlso());
            Assert.assertEquals((int)this.checkingAccount.getSeeAlso().size(), (int)1);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"RelatedTerm association should've succeeded", (Throwable)e);
        }
        relatedTerm.setTermGuid(this.fixedRateMortgage.getGuid());
        Assert.assertNotNull((Object)this.adjustableRateMortgage);
        try {
            this.adjustableRateMortgage = this.glossaryService.getTerm(this.adjustableRateMortgage.getGuid());
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary term fetch should've been a success", (Throwable)e);
        }
        this.adjustableRateMortgage.setSeeAlso(new HashSet<AtlasRelatedTermHeader>(Arrays.asList(relatedTerm)));
        try {
            this.adjustableRateMortgage = this.glossaryService.updateTerm(this.adjustableRateMortgage);
            Assert.assertNotNull((Object)this.adjustableRateMortgage.getSeeAlso());
            Assert.assertEquals((int)this.adjustableRateMortgage.getSeeAlso().size(), (int)1);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"RelatedTerm association should've succeeded", (Throwable)e);
        }
    }

    @Test(dataProvider="getGlossaryTermsProvider", groups={"Glossary.GET.postUpdate"}, dependsOnGroups={"Glossary.UPDATE"})
    public void testGetGlossaryTerms(int offset, int limit, int expected) {
        String guid = this.bankGlossary.getGuid();
        SortOrder sortOrder = SortOrder.ASCENDING;
        try {
            List glossaryTerms = this.glossaryService.getGlossaryTermsHeaders(guid, offset, limit, sortOrder);
            Assert.assertNotNull((Object)glossaryTerms);
            Assert.assertEquals((int)glossaryTerms.size(), (int)expected);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary term fetching should've succeeded", (Throwable)e);
        }
    }

    @DataProvider
    public Object[][] getGlossaryCategoriesProvider() {
        return new Object[][]{{0, -1, 4}, {0, 2, 2}, {2, 5, 2}};
    }

    @Test(dataProvider="getGlossaryCategoriesProvider", groups={"Glossary.GET.postUpdate"}, dependsOnGroups={"Glossary.UPDATE"})
    public void testGetGlossaryCategories(int offset, int limit, int expected) {
        String guid = this.bankGlossary.getGuid();
        SortOrder sortOrder = SortOrder.ASCENDING;
        try {
            List glossaryCategories = this.glossaryService.getGlossaryCategoriesHeaders(guid, offset, limit, sortOrder);
            Assert.assertNotNull((Object)glossaryCategories);
            Assert.assertEquals((int)glossaryCategories.size(), (int)expected);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)"Glossary term fetching should've succeeded");
        }
    }

    @DataProvider
    public Object[][] getCategoryTermsProvider() {
        return new Object[][]{{0, -1, 2}, {0, 2, 2}, {1, 5, 1}, {2, 5, 0}};
    }

    @Test(dataProvider="getCategoryTermsProvider", dependsOnGroups={"Glossary.CREATE"})
    public void testGetCategoryTerms(int offset, int limit, int expected) {
        for (AtlasGlossaryCategory c : Arrays.asList(this.accountCategory, this.mortgageCategory)) {
            try {
                List categoryTerms = this.glossaryService.getCategoryTerms(c.getGuid(), offset, limit, SortOrder.ASCENDING);
                Assert.assertNotNull((Object)categoryTerms);
                Assert.assertEquals((int)categoryTerms.size(), (int)expected);
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Category term retrieval should've been a success", (Throwable)e);
            }
        }
    }

    @Test
    public void testGetTemplate() {
        try {
            String glossaryTermHeaderListAsString = GlossaryTermUtils.getGlossaryTermHeaders();
            Assert.assertNotNull((Object)glossaryTermHeaderListAsString);
            Assert.assertEquals((String)glossaryTermHeaderListAsString, (String)"GlossaryName, TermName, ShortDescription, LongDescription, Examples, Abbreviation, Usage, AdditionalAttributes, TranslationTerms, ValidValuesFor, Synonyms, ReplacedBy, ValidValues, ReplacementTerms, SeeAlso, TranslatedTerms, IsA, Antonyms, Classifies, PreferredToTerms, PreferredTerms");
        }
        catch (Exception e) {
            Assert.fail((String)"The Template for Glossary Term should've been a success", (Throwable)e);
        }
    }

    @Test(dependsOnGroups={"Glossary.CREATE"})
    public void testImportGlossaryData() {
        try {
            InputStream inputStream = GlossaryServiceTest.getFile(CSV_FILES, "template_1.csv");
            BulkImportResponse bulkImportResponse = this.glossaryService.importGlossaryData(inputStream, "template_1.csv");
            Assert.assertNotNull((Object)bulkImportResponse);
            Assert.assertEquals((int)bulkImportResponse.getSuccessImportInfoList().size(), (int)1);
            InputStream inputStream1 = GlossaryServiceTest.getFile(EXCEL_FILES, "template_1.xlsx");
            BulkImportResponse bulkImportResponse1 = this.glossaryService.importGlossaryData(inputStream1, "template_1.xlsx");
            Assert.assertNotNull((Object)bulkImportResponse1);
            Assert.assertEquals((int)bulkImportResponse1.getSuccessImportInfoList().size(), (int)1);
            InputStream inputStream2 = GlossaryServiceTest.getFile(CSV_FILES, "template_with_circular_relationship.csv");
            BulkImportResponse bulkImportResponse2 = this.glossaryService.importGlossaryData(inputStream2, "template_with_circular_relationship.csv");
            Assert.assertNotNull((Object)bulkImportResponse2);
            Assert.assertEquals((int)bulkImportResponse2.getSuccessImportInfoList().size(), (int)3);
            Assert.assertEquals((int)bulkImportResponse2.getFailedImportInfoList().size(), (int)0);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)("The GlossaryTerm should have been created " + (Object)((Object)e)));
        }
    }

    @Test
    public void testEmptyFileException() {
        InputStream inputStream = GlossaryServiceTest.getFile(CSV_FILES, "empty.csv");
        try {
            this.glossaryService.importGlossaryData(inputStream, "empty.csv");
            Assert.fail((String)"Error occurred : Failed to recognize the empty file.");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"No data found in the uploaded file");
        }
    }

    @Test
    public void testInvalidFileException() {
        InputStream inputStream = GlossaryServiceTest.getFile(EXCEL_FILES, "invalid_xls.xls");
        try {
            BulkImportResponse bulkImportResponse = this.glossaryService.importGlossaryData(inputStream, "invalid_xls.xls");
            Assert.fail((String)"Error occurred : Failed to recognize the invalid xls file.");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid XLS file");
        }
    }

    @Test
    public void testFileExtension() throws IOException {
        InputStream inputStream = GlossaryServiceTest.getFile(CSV_FILES, "incorrectEXT.py");
        String userDir = System.getProperty("user.dir");
        String filePath = GlossaryServiceTest.getTestFilePath(userDir, CSV_FILES, "incorrectEXT.py");
        File f = new File(filePath);
        try {
            FileUtils.readFileData((String)"incorrectEXT.py", (InputStream)inputStream);
            Assert.fail((String)"Error occurred : Incorrect file extension.");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)("The provided file type: " + f.getName() + " is not supported. Expected file formats are .csv and .xls."));
        }
    }

    @Test
    public void testIncorrectFileException() {
        InputStream inputStream = GlossaryServiceTest.getFile(CSV_FILES, "incorrectFile.csv");
        try {
            BulkImportResponse bulkImportResponse = this.glossaryService.importGlossaryData(inputStream, "incorrectFile.csv");
            Assert.assertEquals((int)bulkImportResponse.getSuccessImportInfoList().size(), (int)1);
            Assert.assertEquals((int)bulkImportResponse.getFailedImportInfoList().size(), (int)1);
        }
        catch (AtlasBaseException e) {
            Assert.fail((String)("The incorrect file exception should have handled " + (Object)((Object)e)));
        }
    }

    private static InputStream getFile(String subDir, String fileName) {
        String userDir = System.getProperty("user.dir");
        String filePath = GlossaryServiceTest.getTestFilePath(userDir, subDir, fileName);
        File f = new File(filePath);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            LOG.error("File could not be found at: {}", (Object)filePath, (Object)e);
        }
        return fs;
    }

    private static String getTestFilePath(String startPath, String subDir, String fileName) {
        if (StringUtils.isNotEmpty((String)subDir)) {
            return startPath + "/src/test/resources/" + subDir + "/" + fileName;
        }
        return startPath + "/src/test/resources/" + fileName;
    }
}

