/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.BasicTestSetup;
import org.apache.atlas.SortOrder;
import org.apache.atlas.TestModules;
import org.apache.atlas.discovery.RelationshipSearchProcessor;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.commons.collections.CollectionUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class RelationshipSearchProcessorTest
extends BasicTestSetup {
    @Inject
    private AtlasGraph graph;
    @Inject
    public GraphBackedSearchIndexer indexer;

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        this.setupRelationshipTestData();
    }

    @Test
    public void totalRelationships() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post");
        params.setLimit(20);
        this.executeAndAssert(params, 17);
    }

    @Test
    public void searchByAttribute() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post");
        params.setRelationshipFilters(this.getSingleFilterCondition("user_name", SearchParameters.Operator.CONTAINS, "Ajay"));
        params.setLimit(20);
        this.executeAndAssert(params, 7);
    }

    @Test
    public void searchByAttributes() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post");
        SearchParameters.FilterCriteria filterCriteria = new SearchParameters.FilterCriteria();
        filterCriteria.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        ArrayList<SearchParameters.FilterCriteria> criteria = new ArrayList<SearchParameters.FilterCriteria>();
        SearchParameters.FilterCriteria f1 = new SearchParameters.FilterCriteria();
        f1.setAttributeName("post_name");
        f1.setOperator(SearchParameters.Operator.EQ);
        f1.setAttributeValue("christmas-post@Mary");
        criteria.add(f1);
        SearchParameters.FilterCriteria f2 = new SearchParameters.FilterCriteria();
        f2.setAttributeName("reaction");
        f2.setOperator(SearchParameters.Operator.EQ);
        f2.setAttributeValue("like");
        criteria.add(f2);
        filterCriteria.setCriterion(criteria);
        params.setRelationshipFilters(filterCriteria);
        params.setLimit(20);
        this.executeAndAssert(params, 2);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="Attribute name not found for type user_post")
    public void invalidAttribute() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post");
        params.setRelationshipFilters(this.getSingleFilterCondition("name", SearchParameters.Operator.CONTAINS, "Ajay"));
        params.setLimit(20);
        this.executeAndAssert(params, 0);
    }

    public void sortByPostName() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post");
        params.setRelationshipFilters(this.getSingleFilterCondition("user_name", SearchParameters.Operator.CONTAINS, "Ajay"));
        params.setLimit(20);
        params.setSortBy("post_name");
        params.setSortOrder(SortOrder.DESCENDING);
        List<AtlasEdge> edges = this.executeAndAssert(params, 7);
        Assert.assertEquals((String)"ganeshchaturthi-post@Divya", (String)((String)edges.get(0).getProperty("user_post.post_name", String.class)));
    }

    @Test
    public void sortByReaction() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post");
        params.setRelationshipFilters(this.getSingleFilterCondition("user_name", SearchParameters.Operator.CONTAINS, "Ajay"));
        params.setLimit(20);
        params.setSortBy("reaction");
        params.setSortOrder(SortOrder.DESCENDING);
        List<AtlasEdge> edges = this.executeAndAssert(params, 7);
        Assert.assertEquals((String)"wow", (String)((String)edges.get(0).getProperty("user_post.reaction", String.class)));
        Assert.assertEquals((String)"create", (String)((String)edges.get(6).getProperty("user_post.reaction", String.class)));
    }

    @Test
    public void searchBymultipleTypes() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post,highlight_post");
        params.setLimit(30);
        this.executeAndAssert(params, 25);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="Attribute post_name not found for type highlight_post")
    public void searchBymultipleTypesFilter() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post,highlight_post");
        params.setRelationshipFilters(this.getSingleFilterCondition("post_name", SearchParameters.Operator.CONTAINS, "Ajay"));
        params.setLimit(30);
        this.executeAndAssert(params, 0);
    }

    @Test
    public void searchByTypeMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setRelationshipName("user_post,highlight_post");
        params.setLimit(10);
        params.setMarker("*");
        SearchContext context1 = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        RelationshipSearchProcessor processor1 = new RelationshipSearchProcessor(context1, this.indexer.getEdgeIndexKeys());
        List result1 = processor1.executeEdges();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)result1));
        Assert.assertEquals((int)result1.size(), (int)10);
        Assert.assertNotNull((Object)processor1.getNextMarker());
        params.setMarker(processor1.getNextMarker());
        SearchContext context2 = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        RelationshipSearchProcessor processor2 = new RelationshipSearchProcessor(context2, this.indexer.getEdgeIndexKeys());
        List result2 = processor2.executeEdges();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)result2));
        Assert.assertEquals((int)result2.size(), (int)10);
        Assert.assertNotNull((Object)processor2.getNextMarker());
    }

    private List<AtlasEdge> executeAndAssert(SearchParameters params, int expected) throws AtlasBaseException {
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        RelationshipSearchProcessor processor = new RelationshipSearchProcessor(context, this.indexer.getEdgeIndexKeys());
        List result = processor.executeEdges();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)result));
        Assert.assertEquals((int)result.size(), (int)expected);
        return result;
    }

    @AfterClass
    public void teardown() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }
}

