/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.BasicTestSetup;
import org.apache.atlas.SortOrder;
import org.apache.atlas.TestModules;
import org.apache.atlas.discovery.FreeTextSearchProcessor;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class FreeTextSearchProcessorTest
extends BasicTestSetup {
    @Inject
    private AtlasGraph graph;
    @Inject
    private AtlasTypeRegistry typeRegistry;
    @Inject
    private EntityGraphRetriever entityRetriever;
    private String entityGUID;

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        this.setupTestData();
        this.createEntityWithQualifiedName();
    }

    @Test
    public void searchTablesByName() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("sales");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        Assert.assertEquals((long)processor.getResultCount(), (long)3L);
        Assert.assertEquals((int)processor.execute().size(), (int)3);
    }

    @Test
    public void searchByNameSortBy() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("sales");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        params.setSortBy("owner");
        params.setSortOrder(SortOrder.ASCENDING);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertEquals((long)processor.getResultCount(), (long)3L);
        Assert.assertEquals((int)vertices.size(), (int)3);
        AtlasVertex firstVertex = (AtlasVertex)vertices.get(0);
        String firstOwner = (String)this.entityRetriever.toAtlasEntityHeader(firstVertex, (Set)Sets.newHashSet((Object[])new String[]{params.getSortBy()})).getAttribute(params.getSortBy());
        AtlasVertex secondVertex = (AtlasVertex)vertices.get(1);
        String secondOwner = (String)this.entityRetriever.toAtlasEntityHeader(secondVertex, (Set)Sets.newHashSet((Object[])new String[]{params.getSortBy()})).getAttribute(params.getSortBy());
        Assert.assertEquals((String)firstOwner, (String)"Jane BI");
        Assert.assertEquals((String)secondOwner, (String)"Joe");
    }

    @Test
    public void emptySearch() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("not_exists");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        Assert.assertEquals((long)processor.getResultCount(), (long)0L);
        Assert.assertEquals((int)processor.execute().size(), (int)0);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="not_exists_type: Unknown/invalid typename")
    public void searchByNonExistingClassification() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("not_exists_type");
        params.setQuery("aaa");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        new FreeTextSearchProcessor(context);
    }

    @Test(description="filtering internal types")
    public void searchByTextFilteringInternalTypes() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setQuery("*");
        params.setExcludeDeletedEntities(true);
        params.setLimit(500);
        params.setOffset(0);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertNotNull((Object)vertices);
        for (AtlasVertex vertex : vertices) {
            String entityTypeName = AtlasGraphUtilsV2.getTypeName((AtlasElement)vertex);
            AtlasEntityType entityType = context.getTypeRegistry().getEntityTypeByName(entityTypeName);
            Assert.assertFalse((boolean)entityType.isInternalType());
            Assert.assertNotEquals((Object)"AtlasGlossaryTerm", (Object)entityTypeName);
        }
    }

    @Test
    public void searchQualifiedName() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setQuery("h1qualified*");
        params.setExcludeDeletedEntities(true);
        params.setLimit(500);
        params.setOffset(0);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.entityGUID));
    }

    @Test
    public void searchName() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setQuery("h1Name*");
        params.setExcludeDeletedEntities(true);
        params.setLimit(500);
        params.setOffset(0);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.entityGUID));
    }

    @Test
    public void searchNameWithStar() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setQuery("*h1*");
        params.setExcludeDeletedEntities(true);
        params.setLimit(500);
        params.setOffset(0);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, Collections.emptySet());
        FreeTextSearchProcessor processor = new FreeTextSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.entityGUID));
    }

    private void createEntityWithQualifiedName() throws AtlasBaseException {
        AtlasEntity entityToDelete = new AtlasEntity("hdfs_path");
        entityToDelete.setAttribute("name", (Object)"h1NameHDFS");
        entityToDelete.setAttribute("qualifiedName", (Object)"h1qualifiedNameHDFS");
        entityToDelete.setAttribute("path", (Object)"h1PathHDFS");
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entityToDelete)), false);
        AtlasEntityHeader entityHeader = (AtlasEntityHeader)response.getCreatedEntities().get(0);
        this.entityGUID = entityHeader.getGuid();
    }

    @AfterClass
    public void teardown() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }
}

