/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.atlas.BasicTestSetup;
import org.apache.atlas.TestModules;
import org.apache.atlas.discovery.ClassificationSearchProcessor;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class ClassificationSearchProcessorTest
extends BasicTestSetup {
    @Inject
    private AtlasGraph graph;
    @Inject
    public GraphBackedSearchIndexer indexer;
    @Inject
    private EntityGraphRetriever entityRetriever;
    private int totalClassifiedEntities = 0;
    private int dimensionTagEntities = 10;
    private String dimensionTagDeleteGuid;
    private String dimensionalTagGuid;
    private String CJKGUID1;
    private String CJKGUID2;

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        this.setupTestData();
        this.createDimensionTaggedEntityAndDelete();
        this.createDimensionalTaggedEntityWithAttr();
        this.createChineseEntityWithClassificationSingleChar();
        this.createChineseEntityWithClassificationMultipleChar();
    }

    @Test(priority=-1)
    public void searchByALLTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("_ALL_CLASSIFICATION_TYPES");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        this.totalClassifiedEntities = vertices.size();
    }

    @Test
    public void searchByALLTagAndIndexSysFilters() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("_ALL_CLASSIFICATION_TYPES");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("__timestamp", SearchParameters.Operator.LT, String.valueOf(System.currentTimeMillis()));
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)this.totalClassifiedEntities);
    }

    @Test
    public void searchByALLTagAndIndexSysFiltersToTestLimit() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("_ALL_CLASSIFICATION_TYPES");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("__timestamp", SearchParameters.Operator.LT, String.valueOf(System.currentTimeMillis()));
        params.setTagFilters(filterCriteria);
        params.setLimit(this.totalClassifiedEntities - 2);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)(this.totalClassifiedEntities - 2));
    }

    public void searchByNOTCLASSIFIED() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("_NOT_CLASSIFIED");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)20);
    }

    @Test
    public void searchByTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Dimension");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)this.dimensionTagEntities);
    }

    @Test
    public void searchByTagAndTagFilters() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Dimensional");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.EQ, "Test");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.dimensionalTagGuid));
    }

    @Test
    public void searchByTagAndIndexSysFilters() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Dimension");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("__timestamp", SearchParameters.Operator.LT, String.valueOf(System.currentTimeMillis()));
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)this.dimensionTagEntities);
    }

    @Test
    public void searchByWildcardTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Dimension*");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)(this.dimensionTagEntities + 1));
    }

    @Test
    public void searchByALLWildcardTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("*");
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)20);
    }

    @Test
    public void searchWithNotContains() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Dimensional");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.NOT_CONTAINS, "Test");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)vertices));
    }

    @Test
    public void searchByTagAndGraphSysFilters() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Dimension");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("__entityStatus", SearchParameters.Operator.EQ, "DELETED");
        params.setTagFilters(filterCriteria);
        params.setExcludeDeletedEntities(false);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.dimensionTagDeleteGuid));
    }

    @Test
    public void searchByWildcardTagMarker() throws AtlasBaseException {
        String LAST_MARKER = "-1";
        SearchParameters params = new SearchParameters();
        params.setClassification("*");
        int limit = 5;
        String marker = "*";
        params.setLimit(limit);
        while (!StringUtils.equals((String)marker, (String)"-1")) {
            params.setMarker(marker);
            SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
            ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
            List vertices = processor.execute();
            long totalCount = vertices.size();
            marker = processor.getNextMarker();
            if (totalCount < (long)limit) {
                Assert.assertEquals((String)marker, (String)"-1");
                break;
            }
            Assert.assertNotNull((Object)marker);
            Assert.assertEquals((int)vertices.size(), (int)5);
        }
    }

    @Test
    public void searchByTagAndGraphSysFiltersMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Dimension");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("__entityStatus", SearchParameters.Operator.EQ, "DELETED");
        params.setTagFilters(filterCriteria);
        params.setExcludeDeletedEntities(false);
        params.setLimit(20);
        params.setMarker("*");
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.dimensionTagDeleteGuid));
        Assert.assertNull((Object)processor.getNextMarker());
    }

    private void createDimensionTaggedEntityAndDelete() throws AtlasBaseException {
        AtlasEntity entityToDelete = new AtlasEntity("hive_table");
        entityToDelete.setAttribute("name", (Object)"entity to be deleted");
        entityToDelete.setAttribute("qualifiedName", (Object)"entity.tobedeleted");
        ArrayList<AtlasClassification> cls = new ArrayList<AtlasClassification>();
        cls.add(new AtlasClassification("Dimension"));
        entityToDelete.setClassifications(cls);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entityToDelete)), false);
        AtlasEntityHeader entityHeader = (AtlasEntityHeader)response.getCreatedEntities().get(0);
        this.dimensionTagDeleteGuid = entityHeader.getGuid();
        this.entityStore.deleteById(this.dimensionTagDeleteGuid);
    }

    private void createDimensionalTaggedEntityWithAttr() throws AtlasBaseException {
        AtlasEntity entityToDelete = new AtlasEntity("hive_table");
        entityToDelete.setAttribute("name", (Object)"Entity1");
        entityToDelete.setAttribute("qualifiedName", (Object)"entity.one");
        ArrayList<AtlasClassification> cls = new ArrayList<AtlasClassification>();
        cls.add(new AtlasClassification("Dimensional", (Map)new HashMap<String, Object>(){
            {
                this.put("attr1", "Test");
            }
        }));
        entityToDelete.setClassifications(cls);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entityToDelete)), false);
        AtlasEntityHeader entityHeader = (AtlasEntityHeader)response.getCreatedEntities().get(0);
        this.dimensionalTagGuid = entityHeader.getGuid();
    }

    private void createChineseEntityWithClassificationSingleChar() throws AtlasBaseException {
        AtlasEntity entityToDelete = new AtlasEntity("hdfs_path");
        entityToDelete.setAttribute("name", (Object)"h1");
        entityToDelete.setAttribute("qualifiedName", (Object)"h1qualified");
        entityToDelete.setAttribute("path", (Object)"h1");
        ArrayList<AtlasClassification> cls = new ArrayList<AtlasClassification>();
        cls.add(new AtlasClassification("JdbcAccess", (Map)new HashMap<String, Object>(){
            {
                this.put("attr1", "\u72d7");
            }
        }));
        entityToDelete.setClassifications(cls);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entityToDelete)), false);
        AtlasEntityHeader entityHeader = (AtlasEntityHeader)response.getCreatedEntities().get(0);
        this.CJKGUID1 = entityHeader.getGuid();
    }

    private void createChineseEntityWithClassificationMultipleChar() throws AtlasBaseException {
        AtlasEntity entityToDelete = new AtlasEntity("hdfs_path");
        entityToDelete.setAttribute("name", (Object)"h2");
        entityToDelete.setAttribute("qualifiedName", (Object)"h2qualified");
        entityToDelete.setAttribute("path", (Object)"h2");
        ArrayList<AtlasClassification> cls = new ArrayList<AtlasClassification>();
        cls.add(new AtlasClassification("JdbcAccess", (Map)new HashMap<String, Object>(){
            {
                this.put("attr1", "\u6570\u636e");
            }
        }));
        entityToDelete.setClassifications(cls);
        EntityMutationResponse response = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entityToDelete)), false);
        AtlasEntityHeader entityHeader = (AtlasEntityHeader)response.getCreatedEntities().get(0);
        this.CJKGUID2 = entityHeader.getGuid();
    }

    @Test
    public void searchJapaneseChineseByTagEquals() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.EQ, "\u72d7");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID1));
    }

    @Test
    public void searchJapaneseChineseByTagNotEquals() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.NEQ, "\u72d7");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID2));
    }

    @Test
    public void searchJapaneseChineseByTagContains() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.CONTAINS, "\u72d7");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID1));
    }

    @Test
    public void searchJapaneseChineseByTagBeginswith() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.STARTS_WITH, "\u72d7");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID1));
    }

    @Test
    public void searchJapaneseChineseByTagEndsWith() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.ENDS_WITH, "\u72d7");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID1));
    }

    @Test
    public void searchJapaneseChineseByTagISNULL() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.IS_NULL, "");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)2);
    }

    @Test
    public void searchJapaneseChineseByTagISNOTNULL() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.NOT_NULL, "\u72d7");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)2);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID1));
    }

    @Test
    public void searchJapaneseChineseByTagEqualsMultiple() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.EQ, "\u6570\u636e");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID2));
    }

    @Test
    public void searchJapaneseChineseByTagNotEqualsMultiple() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.NEQ, "\u6570\u636e");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID1));
    }

    @Test
    public void searchJapaneseChineseByTagContainsMultiple() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.CONTAINS, "\u6570\u636e");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID2));
    }

    @Test
    public void searchJapaneseChineseByTagBeginsWithMultiple() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.STARTS_WITH, "\u6570\u636e");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID2));
    }

    @Test
    public void searchJapaneseChineseByTagEndsWithMultiple() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("JdbcAccess");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("attr1", SearchParameters.Operator.ENDS_WITH, "\u6570\u636e");
        params.setTagFilters(filterCriteria);
        params.setLimit(20);
        SearchContext context = new SearchContext(params, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        ClassificationSearchProcessor processor = new ClassificationSearchProcessor(context);
        List vertices = processor.execute();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)vertices));
        Assert.assertEquals((int)vertices.size(), (int)1);
        List guids = vertices.stream().map(g -> {
            try {
                return this.entityRetriever.toAtlasEntityHeader(g).getGuid();
            }
            catch (AtlasBaseException e) {
                Assert.fail((String)"Failure in mapping vertex to AtlasEntityHeader");
                return "";
            }
        }).collect(Collectors.toList());
        Assert.assertTrue((boolean)guids.contains(this.CJKGUID2));
    }

    @AfterClass
    public void teardown() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }
}

