/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.BasicTestSetup;
import org.apache.atlas.SortOrder;
import org.apache.atlas.TestModules;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasAggregationEntry;
import org.apache.atlas.model.discovery.AtlasQuickSearchResult;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.QuickSearchParameters;
import org.apache.atlas.model.discovery.RelationshipSearchParameters;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={TestModules.TestOnlyModule.class})
public class AtlasDiscoveryServiceTest
extends BasicTestSetup {
    @Inject
    private AtlasDiscoveryService discoveryService;
    String salesFactGuid = null;
    String spChar1 = "default.test_dot_name";
    String spChar2 = "default.test_dot_name@db.test_db";
    String spChar3 = "default.test_dot_name_12.col1@db1";
    String spChar4 = "default_.test_dot_name";
    String spChar5 = "default.test_colon_name:test_db";
    String spChar6 = "default.test_colon_name:-test_db";
    String spChar7 = "crn:def:default:name-76778-87e7-23@test";
    String spChar8 = "default.:test_db_name";
    String spChar9 = "default.customer's_name";
    String spChar10 = "default.customers'_data_name";
    String spChar11 = "search_with space@name";
    String spChar12 = "search_with space 123@name";
    String spChar13 = "search_with_special-char#having$and%inthename=attr";
    String spChar14 = "search_with_specialChar!name";
    String spChar15 = "search_with_star*in_name";
    String spChar16 = "search_with_star5.*5_inname";
    String spChar17 = "search_quest?n_name";
    String spChar18 = "/warehouse/tablespace/external/hive/name/hortonia_bank";
    String spChar19 = "/warehouse/tablespace/external/hive/name/exis_bank";
    String spChar20 = "search_name_with nameblank@namecluster";

    @BeforeClass
    public void setup() throws Exception {
        super.initialize();
        ApplicationProperties.get().setProperty("atlas.search.freetext.enable", (Object)true);
        this.setupTestData();
        this.createDimensionalTaggedEntity("sales");
        this.createSpecialCharTestEntities();
        this.setupRelationshipTestData();
        this.createJapaneseEntityWithDescription();
    }

    @Test
    public void term() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTermName("salesTerm@salesGlossary");
        this.assertSearchProcessorWithoutMarker(params, 10);
    }

    @Test
    public void termTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTermName("salesTerm@salesGlossary");
        params.setClassification("Metric");
        this.assertSearchProcessorWithoutMarker(params, 4);
    }

    @Test
    public void termEntity() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTermName("salesTerm@salesGlossary");
        params.setTypeName("hive_table");
        this.assertSearchProcessorWithoutMarker(params, 10);
    }

    @Test
    public void termEntityTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTermName("salesTerm@salesGlossary");
        params.setTypeName("hive_table");
        params.setClassification("Dimensional");
        List entityHeaders = this.discoveryService.searchWithParameters(params).getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)entityHeaders));
    }

    @Test
    public void queryALLTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("_ALL_CLASSIFICATION_TYPES");
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 5);
    }

    @Test
    public void queryALLTagTagFilter() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("_ALL_CLASSIFICATION_TYPES");
        SearchParameters.FilterCriteria fc = this.getSingleFilterCondition("__typeName", SearchParameters.Operator.NOT_CONTAINS, "Metric");
        params.setTagFilters(fc);
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 4);
    }

    @Test
    public void queryNOTCLASSIFIEDTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("_NOT_CLASSIFIED");
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 11);
    }

    @Test
    public void queryALLWildcardTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("*");
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 5);
    }

    @Test
    public void queryWildcardTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Dimen*on");
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 2);
    }

    @Test
    public void queryTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Metric");
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 3);
    }

    @Test
    public void queryTagTagFilter() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setClassification("Metric");
        SearchParameters.FilterCriteria fc = this.getSingleFilterCondition("__timestamp", SearchParameters.Operator.LT, String.valueOf(System.currentTimeMillis()));
        params.setTagFilters(fc);
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 3);
    }

    @Test
    public void queryEntity() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 4);
    }

    @Test
    public void queryEntityEntityFilter() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria fc = this.getSingleFilterCondition("tableType", SearchParameters.Operator.NOT_NULL, "null");
        params.setEntityFilters(fc);
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 3);
    }

    @Test
    public void queryEntityEntityFilterTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria fc = this.getSingleFilterCondition("tableType", SearchParameters.Operator.IS_NULL, "null");
        params.setEntityFilters(fc);
        params.setClassification("Dimensional");
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 1);
    }

    @Test
    public void queryEntityEntityFilterTagTagFilter() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria fcE = this.getSingleFilterCondition("tableType", SearchParameters.Operator.IS_NULL, "null");
        params.setEntityFilters(fcE);
        params.setClassification("Dimensional");
        params.setQuery("sales");
        SearchParameters.FilterCriteria fcC = this.getSingleFilterCondition("attr1", SearchParameters.Operator.EQ, "value1");
        params.setTagFilters(fcC);
        this.assertSearchProcessorWithoutMarker(params, 1);
    }

    @Test
    public void queryEntityTagTagFilter() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setClassification("Metric");
        SearchParameters.FilterCriteria fc = this.getSingleFilterCondition("__timestamp", SearchParameters.Operator.LT, String.valueOf(System.currentTimeMillis()));
        params.setTagFilters(fc);
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 2);
    }

    @Test
    public void queryEntityTag() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setClassification("Metric");
        params.setQuery("sales");
        this.assertSearchProcessorWithoutMarker(params, 2);
    }

    @Test
    public void entityEntityFilterTagTagFilter() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria fcE = this.getSingleFilterCondition("tableType", SearchParameters.Operator.EQ, "Managed");
        params.setEntityFilters(fcE);
        params.setClassification("Metric");
        SearchParameters.FilterCriteria fcC = this.getSingleFilterCondition("__timestamp", SearchParameters.Operator.LT, String.valueOf(System.currentTimeMillis()));
        params.setTagFilters(fcC);
        this.assertSearchProcessorWithoutMarker(params, 4);
    }

    @Test
    public void entityTagTagFilter() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setClassification("Metric");
        SearchParameters.FilterCriteria fc = this.getSingleFilterCondition("__timestamp", SearchParameters.Operator.LT, String.valueOf(System.currentTimeMillis()));
        params.setTagFilters(fc);
        this.assertSearchProcessorWithoutMarker(params, 4);
    }

    @Test
    public void searchWith0offsetMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setOffset(0);
        params.setMarker("*");
        params.setLimit(5);
        this.assertSearchProcessorWithMarker(params, 5);
    }

    @Test
    public void searchWithNoOffsetMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setMarker("*");
        params.setLimit(5);
        this.assertSearchProcessorWithMarker(params, 5);
    }

    @Test
    public void searchWithGreaterThan0OffsetBlankMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setOffset(1);
        params.setMarker("");
        params.setLimit(5);
        this.assertSearchProcessorWithoutMarker(params, 5);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="Marker can be used only if offset=0.")
    public void searchWithGreaterThan0OffsetMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setOffset(1);
        params.setMarker("*");
        params.setLimit(5);
        List entityHeaders = this.discoveryService.searchWithParameters(params).getEntities();
        Assert.assertNotNull((Object)entityHeaders);
    }

    @Test
    public void searchWithMarkerSet() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setMarker("*");
        params.setLimit(5);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        List entityHeaders = searchResult.getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)entityHeaders));
        Assert.assertEquals((int)entityHeaders.size(), (int)5);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)searchResult.getNextMarker()));
        params.setMarker(searchResult.getNextMarker());
        AtlasSearchResult nextsearchResult = this.discoveryService.searchWithParameters(params);
        List nextentityHeaders = nextsearchResult.getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)nextentityHeaders));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)nextsearchResult.getNextMarker()));
        if (entityHeaders.size() < params.getLimit()) {
            Assert.assertTrue((nextsearchResult.getNextMarker() == String.valueOf(-1) ? 1 : 0) != 0);
        }
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="Invalid marker!")
    public void searchWithInvalidMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setMarker("*");
        params.setLimit(5);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        List entityHeaders = searchResult.getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)entityHeaders));
        Assert.assertEquals((int)entityHeaders.size(), (int)5);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)searchResult.getNextMarker()));
        params.setMarker(searchResult.getNextMarker() + "abc");
        AtlasSearchResult nextsearchResult = this.discoveryService.searchWithParameters(params);
    }

    @Test
    public void searchWithLastPageMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setExcludeDeletedEntities(true);
        params.setMarker("*");
        int totalCount = this.discoveryService.searchWithParameters(params).getEntities().size();
        params.setMarker("*");
        params.setLimit(5);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        List entityHeaders = searchResult.getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)entityHeaders));
        Assert.assertEquals((int)entityHeaders.size(), (int)5);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)searchResult.getNextMarker()));
        params.setMarker("*");
        params.setLimit(totalCount + 10);
        AtlasSearchResult nextsearchResult = this.discoveryService.searchWithParameters(params);
        Assert.assertEquals((String)nextsearchResult.getNextMarker(), (String)"-1");
    }

    @Test
    public void termMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTermName("salesTerm@salesGlossary");
        params.setMarker("*");
        this.assertSearchProcessorWithoutMarker(params, 10);
    }

    @Test
    public void queryEntityTagMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setClassification("Metric");
        params.setQuery("sales");
        params.setMarker("*");
        params.setLimit(5);
        this.assertSearchProcessorWithMarker(params, 2);
    }

    @Test
    public void entityEntityFilterTagTagFilterMarker() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria fcE = this.getSingleFilterCondition("tableType", SearchParameters.Operator.EQ, "Managed");
        params.setEntityFilters(fcE);
        params.setClassification("Metric");
        SearchParameters.FilterCriteria fcC = this.getSingleFilterCondition("__timestamp", SearchParameters.Operator.LT, String.valueOf(System.currentTimeMillis()));
        params.setTagFilters(fcC);
        params.setMarker("*");
        this.assertSearchProcessorWithoutMarker(params, 4);
    }

    @DataProvider(name="specialCharSearchContains")
    private Object[][] specialCharSearchContains() {
        return new Object[][]{{"name", SearchParameters.Operator.CONTAINS, "test_dot", 4}, {"name", SearchParameters.Operator.CONTAINS, "test_dot_name_", 1}, {"name", SearchParameters.Operator.CONTAINS, "test_colon_name", 2}, {"name", SearchParameters.Operator.CONTAINS, "def:default:name", 1}, {"name", SearchParameters.Operator.CONTAINS, "space 12", 1}, {"name", SearchParameters.Operator.CONTAINS, "with space", 2}, {"name", SearchParameters.Operator.CONTAINS, "Char!name", 1}, {"name", SearchParameters.Operator.CONTAINS, "with_star", 2}, {"name", SearchParameters.Operator.CONTAINS, "/external/hive/name/", 2}, {"name", SearchParameters.Operator.CONTAINS, "test_dot_name@db", 1}, {"name", SearchParameters.Operator.CONTAINS, "name@db", 1}, {"name", SearchParameters.Operator.CONTAINS, "def:default:name-", 1}, {"name", SearchParameters.Operator.CONTAINS, "star*in", 1}, {"name", SearchParameters.Operator.CONTAINS, "Char!na", 1}, {"name", SearchParameters.Operator.CONTAINS, "ith spac", 2}, {"name", SearchParameters.Operator.CONTAINS, "778-87", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "test_dot", 4}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "test_dot_qf_", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "test_colon_qf", 2}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "def:default:qf", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "space 12", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "with space", 2}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "Char!qf", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "with_star", 2}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "/external/hive/qf/", 2}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "test_dot_qf@db", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "qf@db", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "def:default:qf-", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "star*in", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "Char!q", 1}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "ith spac", 2}, {"qualifiedName", SearchParameters.Operator.CONTAINS, "778-87", 1}};
    }

    @DataProvider(name="specialCharSearchName")
    private Object[][] specialCharSearchName() {
        return new Object[][]{{"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_", 3}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name@db.test", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name@db.", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name", 3}, {"name", SearchParameters.Operator.ENDS_WITH, "test_db", 3}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name_12.col1@db", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name_12.col1@", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name_12.col1", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name_12.col", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name_12.", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_dot_name_12", 1}, {"name", SearchParameters.Operator.ENDS_WITH, "col1@db1", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default_.test_dot", 1}, {"name", SearchParameters.Operator.ENDS_WITH, "test_dot_name", 2}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_colon_name:test_", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_colon_name:-test_", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_colon_name:-", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.test_colon", 2}, {"name", SearchParameters.Operator.STARTS_WITH, "crn:def:default:name-76778-87e7-23@", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "crn:def:default:name-76778-87e7-", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "crn:def:default:", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.:test_db", 1}, {"name", SearchParameters.Operator.ENDS_WITH, "test_db_name", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.customer's", 1}, {"name", SearchParameters.Operator.ENDS_WITH, "mer's_name", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "default.customers'_data", 1}, {"name", SearchParameters.Operator.ENDS_WITH, "customers'_data_name", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with space", 2}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with space ", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with space 123@", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with space 1", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_special-char#having$and%inthename=", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_special-char#having$and%in", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_special-char#having$", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_special-char#h", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_special", 2}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_spe", 2}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_specialChar!", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_star*in", 1}, {"name", SearchParameters.Operator.ENDS_WITH, "5.*5_inname", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_with_star5.*5_", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "search_quest?n_", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "/warehouse/tablespace/external/hive/name/hortonia", 1}, {"name", SearchParameters.Operator.STARTS_WITH, "/warehouse/tablespace/external/hive/name/", 2}};
    }

    @DataProvider(name="specialCharSearchQFName")
    private Object[][] specialCharSearchQFName() {
        return new Object[][]{{"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_", 3}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf@db.test", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf@db.", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf", 3}, {"qualifiedName", SearchParameters.Operator.ENDS_WITH, "test_db", 3}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf_12.col1@db", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf_12.col1@", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf_12.col1", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf_12.col", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf_12.", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_dot_qf_12", 1}, {"qualifiedName", SearchParameters.Operator.ENDS_WITH, "col1@db1", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default_.test_dot", 1}, {"qualifiedName", SearchParameters.Operator.ENDS_WITH, "test_dot_qf", 2}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_colon_qf:test_", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_colon_qf:-test_", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_colon_qf:-", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.test_colon", 2}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "crn:def:default:qf-76778-87e7-23@", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "crn:def:default:qf-76778-87e7-", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "crn:def:default:", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.:test_db", 1}, {"qualifiedName", SearchParameters.Operator.ENDS_WITH, "test_db_qf", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.customer's", 1}, {"qualifiedName", SearchParameters.Operator.ENDS_WITH, "mer's_qf", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "default.customers'_data", 1}, {"qualifiedName", SearchParameters.Operator.ENDS_WITH, "customers'_data_qf", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with space", 2}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with space ", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with space 123@", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with space 1", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_special-char#having$and%intheqf=", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_special-char#having$and%in", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_special-char#having$", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_special-char#h", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_special", 2}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_spe", 2}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_specialChar!", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_star*in", 1}, {"qualifiedName", SearchParameters.Operator.ENDS_WITH, "5.*5_inqf", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_with_star5.*5_", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "search_quest?n_", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "/warehouse/tablespace/external/hive/qf/hortonia", 1}, {"qualifiedName", SearchParameters.Operator.STARTS_WITH, "/warehouse/tablespace/external/hive/qf/", 2}};
    }

    @DataProvider(name="specialCharSearchEQ")
    private Object[][] specialCharSearch() {
        return new Object[][]{{"name", SearchParameters.Operator.EQ, this.spChar1, 1}, {"name", SearchParameters.Operator.EQ, this.spChar2, 1}, {"name", SearchParameters.Operator.EQ, this.spChar3, 1}, {"name", SearchParameters.Operator.EQ, this.spChar4, 1}, {"name", SearchParameters.Operator.EQ, this.spChar5, 1}, {"name", SearchParameters.Operator.EQ, this.spChar6, 1}, {"name", SearchParameters.Operator.EQ, this.spChar7, 1}, {"name", SearchParameters.Operator.EQ, this.spChar8, 1}, {"name", SearchParameters.Operator.EQ, this.spChar9, 1}, {"name", SearchParameters.Operator.EQ, this.spChar10, 1}, {"name", SearchParameters.Operator.EQ, this.spChar11, 1}, {"name", SearchParameters.Operator.EQ, this.spChar12, 1}, {"name", SearchParameters.Operator.EQ, this.spChar13, 1}, {"name", SearchParameters.Operator.EQ, this.spChar14, 1}, {"name", SearchParameters.Operator.EQ, this.spChar15, 1}, {"name", SearchParameters.Operator.EQ, this.spChar16, 1}, {"name", SearchParameters.Operator.EQ, this.spChar17, 1}, {"name", SearchParameters.Operator.EQ, this.spChar18, 1}, {"name", SearchParameters.Operator.EQ, this.spChar19, 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar1.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar2.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar3.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar4.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar5.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar6.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar7.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar8.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar9.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar10.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar11.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar12.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar13.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar14.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar15.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar16.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar17.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar18.replace("name", "qf"), 1}, {"qualifiedName", SearchParameters.Operator.EQ, this.spChar19.replace("name", "qf"), 1}};
    }

    @DataProvider(name="specialCharQuickSearch")
    private Object[][] specialCharQuickSearch() {
        return new Object[][]{{"default.test_dot_name", 3}, {"default.test_dot_name*", 3}, {"test_dot_name", 0}, {"*test_dot_name", 2}, {"*test_dot_name*", 4}, {"default.test_dot_name\\*", 0}, {"default.test_dot_qf", 3}, {"default.test_dot_qf*", 3}, {"test_dot_qf", 1}, {"*test_dot_qf", 3}, {"*test_dot_qf*", 4}, {"default.test_dot_qf\\*", 2}, {"default.test_dot_name_12.col1", 1}, {"default.test_dot_name_12.col1*", 1}, {"default.test_dot_name_12.col", 0}, {"default.test_dot_name_12.col*", 1}, {"default.test_dot_qf_12.col1", 1}, {"default.test_dot_qf_12.col1*", 0}, {"default.test_dot_name_12*", 1}, {"default.test_dot_qf_12*", 1}, {"search_name_with nameblank@namecluster", 0}, {"search_name_with nameblank*", 0}, {"search_name_with\\ nameblank@namecluster", 1}, {"search_name_with\\ nameblank*", 1}, {"search_qf_with\\ qfblank*", 0}, {"search_qf_with\\ qfblank@qfcluster", 1}, {"search_qf_with qfblank@qfcluster", 1}, {"search_qf_with qfblank@q", 1}, {"search_qf_with qfblank*", 1}};
    }

    public void createSpecialCharTestEntities() throws AtlasBaseException {
        List<String> nameList = Arrays.asList(this.spChar1, this.spChar2, this.spChar3, this.spChar4, this.spChar5, this.spChar6, this.spChar7, this.spChar8, this.spChar9, this.spChar10, this.spChar11, this.spChar12, this.spChar13, this.spChar14, this.spChar15, this.spChar16, this.spChar17, this.spChar18, this.spChar19, this.spChar20);
        for (String nameStr : nameList) {
            AtlasEntity entityToDelete = new AtlasEntity("hive_table");
            entityToDelete.setAttribute("name", (Object)nameStr);
            entityToDelete.setAttribute("qualifiedName", (Object)("qualifiedName" + System.currentTimeMillis()));
            EntityMutationResponse entityMutationResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entityToDelete)), false);
        }
        List<String> qfList = nameList;
        for (String qfStr : qfList) {
            qfStr = qfStr.replace("name", "qf");
            AtlasEntity entityToDelete = new AtlasEntity("hive_table");
            entityToDelete.setAttribute("name", (Object)("name" + System.currentTimeMillis()));
            entityToDelete.setAttribute("qualifiedName", (Object)qfStr);
            EntityMutationResponse entityMutationResponse = this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entityToDelete)), false);
        }
    }

    @Test(dataProvider="specialCharSearchEQ")
    public void specialCharSearchAssertEq(String attrName, SearchParameters.Operator operator, String attrValue, int expected) throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition(attrName, operator, attrValue);
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        this.assertSearchResult(searchResult, expected, attrValue);
    }

    @Test(dataProvider="specialCharSearchContains")
    public void specialCharSearchAssertContains(String attrName, SearchParameters.Operator operator, String attrValue, int expected) throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition(attrName, operator, attrValue);
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        this.assertSearchResult(searchResult, expected, attrValue);
    }

    @Test(dataProvider="specialCharSearchContains")
    public void specialCharQuickSearchAssertContains(String attrName, SearchParameters.Operator operator, String attrValue, int expected) throws AtlasBaseException {
        QuickSearchParameters params = new QuickSearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition(attrName, operator, attrValue);
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        AtlasQuickSearchResult searchResult = this.discoveryService.quickSearch(params);
        this.assertSearchResult(searchResult.getSearchResults(), expected, attrValue);
        List<String> failedCases = Arrays.asList("def:default:qf-", "star*in", "ith spac", "778-87");
        if (attrName.equals("qualifiedName") && failedCases.contains(attrValue)) {
            expected = 0;
        }
        if (expected > 0) {
            this.assertAggregationMetrics(searchResult);
        }
    }

    @Test(dataProvider="specialCharSearchName")
    public void specialCharSearchAssertName(String attrName, SearchParameters.Operator operator, String attrValue, int expected) throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition(attrName, operator, attrValue);
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        this.assertSearchResult(searchResult, expected, attrValue);
    }

    @Test(dataProvider="specialCharSearchName")
    public void specialCharQuickSearchAssertName(String attrName, SearchParameters.Operator operator, String attrValue, int expected) throws AtlasBaseException {
        QuickSearchParameters params = new QuickSearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition(attrName, operator, attrValue);
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        AtlasQuickSearchResult searchResult = this.discoveryService.quickSearch(params);
        this.assertSearchResult(searchResult.getSearchResults(), expected, attrValue);
        if (expected > 0) {
            this.assertAggregationMetrics(searchResult);
        }
    }

    @Test(dataProvider="specialCharSearchQFName")
    public void specialCharSearchAssertQFName(String attrName, SearchParameters.Operator operator, String attrValue, int expected) throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition(attrName, operator, attrValue);
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        this.assertSearchResult(searchResult, expected, attrValue);
    }

    @Test(dataProvider="specialCharSearchQFName")
    public void specialCharQuickSearchAssertQFName(String attrName, SearchParameters.Operator operator, String attrValue, int expected) throws AtlasBaseException {
        QuickSearchParameters params = new QuickSearchParameters();
        params.setTypeName("hive_table");
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition(attrName, operator, attrValue);
        params.setEntityFilters(filterCriteria);
        params.setLimit(20);
        AtlasQuickSearchResult searchResult = this.discoveryService.quickSearch(params);
        this.assertSearchResult(searchResult.getSearchResults(), expected, attrValue);
        if (expected > 0) {
            this.assertAggregationMetrics(searchResult);
        }
    }

    @Test(dataProvider="specialCharQuickSearch")
    public void specialCharQuickSearch(String searchValue, int expected) throws AtlasBaseException {
        QuickSearchParameters params = new QuickSearchParameters();
        params.setQuery(searchValue);
        params.setLimit(5);
        params.setOffset(0);
        AtlasQuickSearchResult searchResult = this.discoveryService.quickSearch(params);
        this.assertSearchResult(searchResult.getSearchResults(), expected, searchValue);
        if (expected > 0) {
            this.assertAggregationMetrics(searchResult);
        }
    }

    @Test
    public void searchWithEntityQuickSearchSortAsc() throws AtlasBaseException {
        QuickSearchParameters params = new QuickSearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("sales");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        params.setSortBy("owner");
        params.setSortOrder(SortOrder.ASCENDING);
        AtlasQuickSearchResult searchResult = this.discoveryService.quickSearch(params);
        List list = searchResult.getSearchResults().getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)list));
        Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((AtlasEntityHeader)list.get(0)).getAttribute("owner").toString().equalsIgnoreCase("Jane BI"));
        Assert.assertTrue((boolean)((AtlasEntityHeader)list.get(1)).getAttribute("owner").toString().equalsIgnoreCase("Joe"));
    }

    @Test
    public void searchWithEntityQuickSearchSortDesc() throws AtlasBaseException {
        QuickSearchParameters params = new QuickSearchParameters();
        params.setTypeName("hive_table");
        params.setQuery("sales");
        params.setExcludeDeletedEntities(true);
        params.setLimit(3);
        params.setSortBy("name");
        params.setSortOrder(SortOrder.DESCENDING);
        AtlasQuickSearchResult searchResult = this.discoveryService.quickSearch(params);
        List list = searchResult.getSearchResults().getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)list));
        Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((AtlasEntityHeader)list.get(0)).getDisplayText().equalsIgnoreCase("time_dim"));
        Assert.assertTrue((boolean)((AtlasEntityHeader)list.get(1)).getDisplayText().equalsIgnoreCase("sales_fact_monthly_mv"));
    }

    @Test
    public void searchRelatedEntitiesSortAsc() throws AtlasBaseException {
        String guid = this.gethiveTableSalesFactGuid();
        SearchParameters params = new SearchParameters();
        params.setLimit(10);
        AtlasSearchResult relResult = this.discoveryService.searchRelatedEntities(guid, "__hive_table.columns", false, params);
        List list = relResult.getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)list));
        Assert.assertTrue((list.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((AtlasEntityHeader)list.get(0)).getDisplayText().equalsIgnoreCase("customer_id"));
        Assert.assertTrue((boolean)((AtlasEntityHeader)list.get(5)).getDisplayText().equalsIgnoreCase("time_id"));
    }

    @Test
    public void searchRelatedEntitiesSortDesc() throws AtlasBaseException {
        String guid = this.gethiveTableSalesFactGuid();
        SearchParameters params = new SearchParameters();
        params.setLimit(10);
        params.setSortOrder(SortOrder.DESCENDING);
        AtlasSearchResult relResult = this.discoveryService.searchRelatedEntities(guid, "columns", false, params);
        List list = relResult.getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)list));
        Assert.assertTrue((list.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((AtlasEntityHeader)list.get(5)).getDisplayText().equalsIgnoreCase("customer_id"));
        Assert.assertTrue((boolean)((AtlasEntityHeader)list.get(0)).getDisplayText().equalsIgnoreCase("time_id"));
    }

    @Test
    public void excludeHeaderAttributesStringAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setExcludeHeaderAttributes(true);
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("tableType", SearchParameters.Operator.EQ, "Managed");
        params.setEntityFilters(filterCriteria);
        params.setSortBy("name");
        params.setAttributes((Set)new HashSet<String>(){
            {
                this.add("name");
            }
        });
        params.setLimit(1);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        AtlasSearchResult.AttributeSearchResult expected = new AtlasSearchResult.AttributeSearchResult();
        expected.setName(Arrays.asList("name"));
        expected.setValues(Arrays.asList(Arrays.asList("log_fact_daily_mv")));
        this.assertSearchResult(searchResult, expected);
    }

    @Test
    public void excludeHeaderAttributesRelationAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setExcludeHeaderAttributes(true);
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("name", SearchParameters.Operator.EQ, "time_dim");
        params.setEntityFilters(filterCriteria);
        params.setAttributes((Set)new HashSet<String>(){
            {
                this.add("name");
                this.add("db");
            }
        });
        params.setLimit(1);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        Assert.assertNotNull((Object)searchResult);
        Assert.assertNotNull((Object)searchResult.getEntities());
        Assert.assertNotNull((Object)searchResult.getReferredEntities());
    }

    @Test
    public void excludeHeaderAttributesSystemAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setExcludeHeaderAttributes(true);
        params.setAttributes((Set)new HashSet<String>(){
            {
                this.add("name");
                this.add("__state");
            }
        });
        params.setLimit(1);
        SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("tableType", SearchParameters.Operator.EQ, "Managed");
        params.setEntityFilters(filterCriteria);
        params.setSortBy("name");
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        AtlasSearchResult.AttributeSearchResult expected = new AtlasSearchResult.AttributeSearchResult();
        expected.setName(Arrays.asList("name", "__state"));
        expected.setValues(Arrays.asList(Arrays.asList("log_fact_daily_mv", "ACTIVE")));
        this.assertSearchResult(searchResult, expected);
    }

    @Test
    public void excludeHeaderAttributesAllEntityTypeSysAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table,_ALL_ENTITY_TYPES");
        params.setExcludeHeaderAttributes(true);
        params.setAttributes((Set)new HashSet<String>(){
            {
                this.add("__state");
            }
        });
        params.setLimit(2);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        AtlasSearchResult.AttributeSearchResult expected = new AtlasSearchResult.AttributeSearchResult();
        expected.setName(Arrays.asList("__state"));
        expected.setValues(Arrays.asList(Arrays.asList("ACTIVE"), Arrays.asList("ACTIVE")));
        this.assertSearchResult(searchResult, expected);
    }

    @Test
    public void excludeHeaderAttributesAllEntityTypeSysAttrs() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table,_ALL_ENTITY_TYPES");
        params.setExcludeHeaderAttributes(true);
        params.setAttributes((Set)new HashSet<String>(){
            {
                this.add("__state");
                this.add("__guid");
            }
        });
        params.setLimit(2);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        Assert.assertEquals((int)searchResult.getAttributes().getValues().size(), (int)2);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="Attribute name not found for type __ENTITY_ROOT")
    public void excludeHeaderAttributesAllEntityType() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table,_ALL_ENTITY_TYPES");
        params.setExcludeHeaderAttributes(true);
        params.setAttributes((Set)new HashSet<String>(){
            {
                this.add("name");
            }
        });
        params.setLimit(1);
        this.discoveryService.searchWithParameters(params);
    }

    @Test(expectedExceptions={AtlasBaseException.class}, expectedExceptionsMessageRegExp="Attribute name1 not found for type hive_table")
    public void excludeHeaderAttributesInvalidAttr() throws AtlasBaseException {
        SearchParameters params = new SearchParameters();
        params.setTypeName("hive_table");
        params.setExcludeHeaderAttributes(true);
        params.setAttributes((Set)new HashSet<String>(){
            {
                this.add("name1");
            }
        });
        params.setLimit(1);
        this.discoveryService.searchWithParameters(params);
    }

    @Test
    public void searchRelations() throws AtlasBaseException {
        RelationshipSearchParameters sp = new RelationshipSearchParameters();
        sp.setRelationshipName("highlight_post");
        sp.setMarker("*");
        sp.setLimit(10);
        sp.setRelationshipFilters(this.getSingleFilterCondition("highlight_name", SearchParameters.Operator.EQ, "year2021@Ajay"));
        AtlasSearchResult sr = this.discoveryService.searchRelationsWithParameters(sp);
        Assert.assertEquals((int)sr.getRelations().size(), (int)4);
    }

    @Test
    public void cjkCharQuickSearch() throws AtlasBaseException {
        this.addLabels();
        String searchValue = "\u4f60";
        int expected = 1;
        QuickSearchParameters params = new QuickSearchParameters();
        params.setQuery(searchValue);
        params.setLimit(5);
        params.setOffset(0);
        AtlasQuickSearchResult searchResult = this.discoveryService.quickSearch(params);
        this.assertSearchResult(searchResult.getSearchResults(), expected, searchValue);
    }

    @Test(dependsOnMethods={"cjkCharQuickSearch"})
    public void cjkCharBasicSearch() throws AtlasBaseException {
        String searchValue = "\u4f60\u597d";
        int expected = 1;
        SearchParameters params = new SearchParameters();
        params.setQuery(searchValue);
        params.setLimit(5);
        params.setOffset(0);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        this.assertSearchResult(searchResult, expected, searchValue);
    }

    @Test
    public void japaneseReceiptStarSearch() throws AtlasBaseException {
        String searchValue = "\u30ec\u30b7\u30fc\u30c8";
        int expected = 1;
        SearchParameters params = new SearchParameters();
        params.setQuery(searchValue);
        params.setTypeName("hdfs_path");
        params.setLimit(5);
        params.setOffset(0);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        this.assertSearchResult(searchResult, expected, searchValue);
    }

    @Test
    public void japaneseLedgerSearch() throws AtlasBaseException {
        String searchValue = "\u5143\u5e33";
        int expected = 2;
        SearchParameters params = new SearchParameters();
        params.setQuery(searchValue);
        params.setLimit(5);
        params.setOffset(0);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        this.assertSearchResult(searchResult, expected, searchValue);
    }

    @Test
    public void japaneseLedgerStarSearch() throws AtlasBaseException {
        String searchValue = "\u306e\u53f0*";
        int expected = 1;
        SearchParameters params = new SearchParameters();
        params.setQuery(searchValue);
        params.setLimit(5);
        params.setOffset(0);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        this.assertSearchResult(searchResult, expected, searchValue);
    }

    private String gethiveTableSalesFactGuid() throws AtlasBaseException {
        if (this.salesFactGuid == null) {
            SearchParameters params = new SearchParameters();
            params.setTypeName("hive_table");
            SearchParameters.FilterCriteria filterCriteria = this.getSingleFilterCondition("name", SearchParameters.Operator.EQ, "sales_fact");
            params.setEntityFilters(filterCriteria);
            AtlasSearchResult result = this.discoveryService.searchWithParameters(params);
            if (result != null && CollectionUtils.isNotEmpty((Collection)result.getEntities())) {
                this.salesFactGuid = ((AtlasEntityHeader)result.getEntities().get(0)).getGuid();
            }
        }
        return this.salesFactGuid;
    }

    private void assertSearchResult(AtlasSearchResult searchResult, int expected, String query) {
        Assert.assertNotNull((Object)searchResult);
        if (expected == 0) {
            Assert.assertTrue((searchResult.getAttributes() == null || CollectionUtils.isEmpty((Collection)searchResult.getAttributes().getValues()) ? 1 : 0) != 0);
            Assert.assertNull((Object)searchResult.getEntities(), (String)query);
        } else if (searchResult.getEntities() != null) {
            Assert.assertEquals((int)searchResult.getEntities().size(), (int)expected, (String)query);
        } else {
            Assert.assertNotNull((Object)searchResult.getAttributes());
            Assert.assertNotNull((Object)searchResult.getAttributes().getValues());
            Assert.assertEquals((int)searchResult.getAttributes().getValues().size(), (int)expected, (String)query);
        }
    }

    private void assertSearchResult(AtlasSearchResult searchResult, AtlasSearchResult.AttributeSearchResult expected) {
        Assert.assertNotNull((Object)searchResult);
        AtlasSearchResult.AttributeSearchResult result = searchResult.getAttributes();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getName().containsAll(expected.getName()));
        int i = 0;
        for (List value : result.getValues()) {
            Assert.assertTrue((boolean)value.containsAll((Collection)expected.getValues().get(i)));
            ++i;
        }
    }

    private void assertAggregationMetrics(AtlasQuickSearchResult searchResult) {
        Map agg = searchResult.getAggregationMetrics();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)((Collection)agg.get("__typeName"))));
        AtlasAggregationEntry entry = (AtlasAggregationEntry)((List)agg.get("__typeName")).get(0);
        Assert.assertTrue((entry != null && entry.getCount() > 0L ? 1 : 0) != 0);
    }

    private void createDimensionalTaggedEntity(String name) throws AtlasBaseException {
        EntityMutationResponse resp = this.createDummyEntity(name, "hive_table", new String[0]);
        AtlasEntityHeader entityHeader = (AtlasEntityHeader)resp.getCreatedEntities().get(0);
        String guid = entityHeader.getGuid();
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("attr1", "value1");
        this.entityStore.addClassification(Arrays.asList(guid), new AtlasClassification("Dimensional", attr));
    }

    private void createJapaneseEntityWithDescription() throws AtlasBaseException {
        AtlasEntity entity = new AtlasEntity("hdfs_path");
        entity.setAttribute("name", (Object)"\u5143\u5e33");
        entity.setAttribute("qualifiedName", (Object)"\u30ec\u30b7\u30fc\u30c8");
        entity.setAttribute("path", (Object)"\u30ec\u30b7\u30fc\u30c8");
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entity)), false);
        AtlasEntity entity2 = new AtlasEntity("hdfs_path");
        entity2.setAttribute("name", (Object)"cjk");
        entity2.setAttribute("qualifiedName", (Object)"\u306e\u53f0\u5e33");
        entity2.setAttribute("path", (Object)"cjk");
        this.entityStore.createOrUpdate((EntityStream)new AtlasEntityStream(new AtlasEntity.AtlasEntitiesWithExtInfo(entity2)), false);
    }

    private void assertSearchProcessorWithoutMarker(SearchParameters params, int expected) throws AtlasBaseException {
        this.assertSearchProcessor(params, expected, false);
    }

    private void assertSearchProcessorWithMarker(SearchParameters params, int expected) throws AtlasBaseException {
        this.assertSearchProcessor(params, expected, true);
    }

    private void assertSearchProcessor(SearchParameters params, int expected, boolean checkMarker) throws AtlasBaseException {
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(params);
        List entityHeaders = searchResult.getEntities();
        Assert.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)entityHeaders));
        Assert.assertEquals((int)entityHeaders.size(), (int)expected);
        if (checkMarker) {
            Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)searchResult.getNextMarker()));
        } else {
            Assert.assertTrue((boolean)StringUtils.isEmpty((String)searchResult.getNextMarker()));
        }
    }

    @AfterClass
    public void teardown() throws Exception {
        AtlasGraphProvider.cleanup();
        super.cleanup();
    }
}

