/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMapType
extends AtlasType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMapType.class);
    private final String keyTypeName;
    private final String valueTypeName;
    private AtlasType keyType;
    private AtlasType valueType;

    public AtlasMapType(AtlasType keyType, AtlasType valueType) {
        super(AtlasBaseTypeDef.getMapTypeName(keyType.getTypeName(), valueType.getTypeName()), TypeCategory.MAP, "atlas_core");
        this.keyTypeName = keyType.getTypeName();
        this.valueTypeName = valueType.getTypeName();
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public AtlasMapType(String keyTypeName, String valueTypeName, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(AtlasBaseTypeDef.getMapTypeName(keyTypeName, valueTypeName), TypeCategory.MAP, "atlas_core");
        this.keyTypeName = keyTypeName;
        this.valueTypeName = valueTypeName;
        this.resolveReferences(typeRegistry);
    }

    public String getKeyTypeName() {
        return this.keyTypeName;
    }

    public String getValueTypeName() {
        return this.valueTypeName;
    }

    public AtlasType getKeyType() {
        return this.keyType;
    }

    public AtlasType getValueType() {
        return this.valueType;
    }

    public void setKeyType(AtlasType keyType) {
        this.keyType = keyType;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        this.keyType = typeRegistry.getType(this.keyTypeName);
        this.valueType = typeRegistry.getType(this.valueTypeName);
    }

    @Override
    public Map<Object, Object> createDefaultValue() {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Object key = this.keyType.createDefaultValue();
        if (key != null) {
            ret.put(key, this.valueType.createDefaultValue());
        }
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry e : map.entrySet()) {
                    if (this.keyType.isValidValue(e.getKey()) && this.valueType.isValidValue(e.getValue())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean areEqualValues(Object val1, Object val2, Map<String, String> guidAssignments) {
        boolean ret = true;
        if (val1 == null) {
            ret = this.isEmptyMapValue(val2);
        } else if (val2 == null) {
            ret = this.isEmptyMapValue(val1);
        } else {
            Map map1 = this.getMapFromValue(val1);
            if (map1 == null) {
                ret = false;
            } else {
                Map map2 = this.getMapFromValue(val2);
                if (map2 == null) {
                    ret = false;
                } else {
                    int len = map1.size();
                    if (len != map2.size()) {
                        ret = false;
                    } else {
                        for (Object key : map1.keySet()) {
                            if (this.valueType.areEqualValues(map1.get(key), map2.get(key), guidAssignments)) continue;
                            ret = false;
                            break;
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry e : map.entrySet()) {
                    if (this.keyType.isValidValueForUpdate(e.getKey()) && this.valueType.isValidValueForUpdate(e.getValue())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<Object, Object> getNormalizedValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            obj = AtlasType.fromJson(obj.toString(), Map.class);
        }
        if (obj instanceof Map) {
            HashMap<Object, Object> ret = new HashMap<Object, Object>();
            Map map = (Map)obj;
            for (Map.Entry e : map.entrySet()) {
                Object normalizedKey = this.keyType.getNormalizedValue(e.getKey());
                if (normalizedKey != null) {
                    Object value = e.getValue();
                    if (value != null) {
                        Object normalizedValue = this.valueType.getNormalizedValue(e.getValue());
                        if (normalizedValue != null) {
                            ret.put(normalizedKey, normalizedValue);
                            continue;
                        }
                        return null;
                    }
                    ret.put(normalizedKey, value);
                    continue;
                }
                return null;
            }
            return ret;
        }
        return null;
    }

    @Override
    public Map<Object, Object> getNormalizedValueForUpdate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            HashMap<Object, Object> ret = new HashMap<Object, Object>();
            Map map = (Map)obj;
            for (Map.Entry e : map.entrySet()) {
                Object normalizedKey = this.keyType.getNormalizedValueForUpdate(e.getKey());
                if (normalizedKey != null) {
                    Object value = e.getValue();
                    if (value != null) {
                        Object normalizedValue = this.valueType.getNormalizedValueForUpdate(e.getValue());
                        if (normalizedValue != null) {
                            ret.put(normalizedKey, normalizedValue);
                            continue;
                        }
                        return null;
                    }
                    ret.put(normalizedKey, value);
                    continue;
                }
                return null;
            }
            return ret;
        }
        return null;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry e : map.entrySet()) {
                    Object key = e.getKey();
                    if (!this.keyType.isValidValue(key)) {
                        ret = false;
                        messages.add(objName + "." + key + ": invalid key for type " + this.getTypeName());
                        continue;
                    }
                    Object value = e.getValue();
                    ret = this.valueType.validateValue(value, objName + "." + key, messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry e : map.entrySet()) {
                    Object key = e.getKey();
                    if (!this.keyType.isValidValueForUpdate(key)) {
                        ret = false;
                        messages.add(objName + "." + key + ": invalid key for type " + this.getTypeName());
                        continue;
                    }
                    Object value = e.getValue();
                    ret = this.valueType.validateValueForUpdate(value, objName + "." + key, messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public AtlasType getTypeForAttribute() {
        AtlasType keyAttributeType = this.keyType.getTypeForAttribute();
        AtlasType valueAttributeType = this.valueType.getTypeForAttribute();
        if (keyAttributeType == this.keyType && valueAttributeType == this.valueType) {
            return this;
        }
        AtlasMapType attributeType = new AtlasMapType(keyAttributeType, valueAttributeType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTypeForAttribute(): {} ==> {}", (Object)this.getTypeName(), (Object)attributeType.getTypeName());
        }
        return attributeType;
    }

    private boolean isEmptyMapValue(Object val) {
        if (val == null) {
            return true;
        }
        if (val instanceof Map) {
            return ((Map)val).isEmpty();
        }
        if (val instanceof String) {
            Map map = AtlasType.fromJson(val.toString(), Map.class);
            return map == null || map.isEmpty();
        }
        return false;
    }

    private Map getMapFromValue(Object val) {
        Map ret = val instanceof Map ? (Map)val : (val instanceof String ? AtlasType.fromJson(val.toString(), Map.class) : null);
        return ret;
    }
}

