/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.lineage.LineageOnDemandConstraints;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true, value={"visitedEdges"})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasLineageInfo
implements Serializable {
    private String baseEntityGuid;
    private LineageDirection lineageDirection;
    private int lineageDepth;
    private Map<String, AtlasEntityHeader> guidEntityMap;
    private Set<LineageRelation> relations;
    private Set<String> visitedEdges;
    private Map<String, LineageInfoOnDemand> relationsOnDemand;
    private Map<String, LineageOnDemandConstraints> lineageOnDemandPayload;

    public AtlasLineageInfo() {
    }

    public AtlasLineageInfo(String baseEntityGuid, Map<String, AtlasEntityHeader> guidEntityMap, Set<LineageRelation> relations, LineageDirection lineageDirection, int lineageDepth) {
        this(baseEntityGuid, guidEntityMap, relations, null, null, lineageDirection, lineageDepth);
    }

    public AtlasLineageInfo(String baseEntityGuid, Map<String, AtlasEntityHeader> guidEntityMap, Set<LineageRelation> relations, Set<String> visitedEdges, Map<String, LineageInfoOnDemand> relationsOnDemand, LineageDirection lineageDirection, int lineageDepth) {
        this.baseEntityGuid = baseEntityGuid;
        this.lineageDirection = lineageDirection;
        this.lineageDepth = lineageDepth;
        this.guidEntityMap = guidEntityMap;
        this.relations = relations;
        this.visitedEdges = visitedEdges;
        this.relationsOnDemand = relationsOnDemand;
    }

    public String getBaseEntityGuid() {
        return this.baseEntityGuid;
    }

    public void setBaseEntityGuid(String baseEntityGuid) {
        this.baseEntityGuid = baseEntityGuid;
    }

    public Map<String, AtlasEntityHeader> getGuidEntityMap() {
        return this.guidEntityMap;
    }

    public void setGuidEntityMap(Map<String, AtlasEntityHeader> guidEntityMap) {
        this.guidEntityMap = guidEntityMap;
    }

    public Set<LineageRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(Set<LineageRelation> relations) {
        this.relations = relations;
    }

    public Set<String> getVisitedEdges() {
        return this.visitedEdges;
    }

    public void setVisitedEdges(Set<String> visitedEdges) {
        this.visitedEdges = visitedEdges;
    }

    public Map<String, LineageInfoOnDemand> getRelationsOnDemand() {
        return this.relationsOnDemand;
    }

    public void setRelationsOnDemand(Map<String, LineageInfoOnDemand> relationsOnDemand) {
        this.relationsOnDemand = relationsOnDemand;
    }

    public LineageDirection getLineageDirection() {
        return this.lineageDirection;
    }

    public void setLineageDirection(LineageDirection lineageDirection) {
        this.lineageDirection = lineageDirection;
    }

    public int getLineageDepth() {
        return this.lineageDepth;
    }

    public void setLineageDepth(int lineageDepth) {
        this.lineageDepth = lineageDepth;
    }

    public Map<String, LineageOnDemandConstraints> getLineageOnDemandPayload() {
        return this.lineageOnDemandPayload;
    }

    public void setLineageOnDemandPayload(Map<String, LineageOnDemandConstraints> lineageOnDemandPayload) {
        this.lineageOnDemandPayload = lineageOnDemandPayload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasLineageInfo that = (AtlasLineageInfo)o;
        return this.lineageDepth == that.lineageDepth && Objects.equals(this.baseEntityGuid, that.baseEntityGuid) && this.lineageDirection == that.lineageDirection && Objects.equals(this.guidEntityMap, that.guidEntityMap) && Objects.equals(this.relations, that.relations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseEntityGuid, this.lineageDirection, this.lineageDepth, this.guidEntityMap, this.relations});
    }

    public String toString() {
        return "AtlasLineageInfo{baseEntityGuid=" + this.baseEntityGuid + ", guidEntityMap=" + this.guidEntityMap + ", relations=" + this.relations + ", relationsOnDemand=" + this.relationsOnDemand + ", lineageDirection=" + (Object)((Object)this.lineageDirection) + ", lineageDepth=" + this.lineageDepth + '}';
    }

    public static enum LineageDirection {
        INPUT,
        OUTPUT,
        BOTH;

    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true, value={"inputRelationsReachedLimit", "outputRelationsReachedLimit"})
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class LineageInfoOnDemand {
        @JsonProperty
        boolean hasMoreInputs;
        @JsonProperty
        boolean hasMoreOutputs;
        int inputRelationsCount;
        int outputRelationsCount;
        boolean isInputRelationsReachedLimit;
        boolean isOutputRelationsReachedLimit;
        LineageOnDemandConstraints onDemandConstraints;

        public LineageInfoOnDemand() {
        }

        public LineageInfoOnDemand(LineageOnDemandConstraints onDemandConstraints) {
            this.onDemandConstraints = onDemandConstraints;
            this.hasMoreInputs = false;
            this.hasMoreOutputs = false;
            this.inputRelationsCount = 0;
            this.outputRelationsCount = 0;
            this.isInputRelationsReachedLimit = false;
            this.isOutputRelationsReachedLimit = false;
        }

        public boolean isInputRelationsReachedLimit() {
            return this.isInputRelationsReachedLimit;
        }

        public void setInputRelationsReachedLimit(boolean inputRelationsReachedLimit) {
            this.isInputRelationsReachedLimit = inputRelationsReachedLimit;
        }

        public boolean isOutputRelationsReachedLimit() {
            return this.isOutputRelationsReachedLimit;
        }

        public void setOutputRelationsReachedLimit(boolean outputRelationsReachedLimit) {
            this.isOutputRelationsReachedLimit = outputRelationsReachedLimit;
        }

        public boolean hasMoreInputs() {
            return this.hasMoreInputs;
        }

        public void setHasMoreInputs(boolean hasMoreInputs) {
            this.hasMoreInputs = hasMoreInputs;
        }

        public boolean hasMoreOutputs() {
            return this.hasMoreOutputs;
        }

        public void setHasMoreOutputs(boolean hasMoreOutputs) {
            this.hasMoreOutputs = hasMoreOutputs;
        }

        public int getInputRelationsCount() {
            return this.inputRelationsCount;
        }

        public void incrementInputRelationsCount() {
            if (this.hasMoreInputs) {
                return;
            }
            if (this.isInputRelationsReachedLimit) {
                this.setHasMoreInputs(true);
                return;
            }
            ++this.inputRelationsCount;
            if (this.inputRelationsCount == this.onDemandConstraints.getInputRelationsLimit()) {
                this.setInputRelationsReachedLimit(true);
                return;
            }
        }

        public int getOutputRelationsCount() {
            return this.outputRelationsCount;
        }

        public void incrementOutputRelationsCount() {
            if (this.hasMoreOutputs) {
                return;
            }
            if (this.isOutputRelationsReachedLimit) {
                this.setHasMoreOutputs(true);
                return;
            }
            ++this.outputRelationsCount;
            if (this.outputRelationsCount == this.onDemandConstraints.getOutputRelationsLimit()) {
                this.setOutputRelationsReachedLimit(true);
                return;
            }
        }

        public String toString() {
            return "LineageInfoOnDemand{hasMoreInputs='" + this.hasMoreInputs + '\'' + ", hasMoreOutputs='" + this.hasMoreOutputs + '\'' + ", inputRelationsCount='" + this.inputRelationsCount + '\'' + ", outputRelationsCount='" + this.outputRelationsCount + '\'' + '}';
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class LineageRelation {
        private String fromEntityId;
        private String toEntityId;
        private String relationshipId;

        public LineageRelation() {
        }

        public LineageRelation(String fromEntityId, String toEntityId, String relationshipId) {
            this.fromEntityId = fromEntityId;
            this.toEntityId = toEntityId;
            this.relationshipId = relationshipId;
        }

        public String getFromEntityId() {
            return this.fromEntityId;
        }

        public void setFromEntityId(String fromEntityId) {
            this.fromEntityId = fromEntityId;
        }

        public String getToEntityId() {
            return this.toEntityId;
        }

        public void setToEntityId(String toEntityId) {
            this.toEntityId = toEntityId;
        }

        public String getRelationshipId() {
            return this.relationshipId;
        }

        public void setRelationshipId(String relationshipId) {
            this.relationshipId = relationshipId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineageRelation that = (LineageRelation)o;
            return Objects.equals(this.fromEntityId, that.fromEntityId) && Objects.equals(this.toEntityId, that.toEntityId) && Objects.equals(this.relationshipId, that.relationshipId);
        }

        public int hashCode() {
            return Objects.hash(this.fromEntityId, this.toEntityId, this.relationshipId);
        }

        public String toString() {
            return "LineageRelation{fromEntityId='" + this.fromEntityId + '\'' + ", toEntityId='" + this.toEntityId + '\'' + ", relationshipId='" + this.relationshipId + '\'' + '}';
        }
    }
}

