/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.commons.collections.CollectionUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasRelationship
extends AtlasStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_GUID = "guid";
    public static final String KEY_HOME_ID = "homeId";
    public static final String KEY_PROVENANCE_TYPE = "provenanceType";
    public static final String KEY_STATUS = "status";
    public static final String KEY_CREATED_BY = "createdBy";
    public static final String KEY_UPDATED_BY = "updatedBy";
    public static final String KEY_CREATE_TIME = "createTime";
    public static final String KEY_UPDATE_TIME = "updateTime";
    public static final String KEY_VERSION = "version";
    public static final String KEY_END1 = "end1";
    public static final String KEY_END2 = "end2";
    public static final String KEY_LABEL = "label";
    public static final String KEY_PROPAGATE_TAGS = "propagateTags";
    public static final String KEY_BLOCKED_PROPAGATED_CLASSIFICATIONS = "blockedPropagatedClassifications";
    public static final String KEY_PROPAGATED_CLASSIFICATIONS = "propagatedClassifications";
    private String guid = null;
    private String homeId = null;
    private Integer provenanceType = null;
    private AtlasObjectId end1 = null;
    private AtlasObjectId end2 = null;
    private String label = null;
    private AtlasRelationshipDef.PropagateTags propagateTags = AtlasRelationshipDef.PropagateTags.NONE;
    private Status status = Status.ACTIVE;
    private String createdBy = null;
    private String updatedBy = null;
    private Date createTime = null;
    private Date updateTime = null;
    private Long version = 0L;
    private Set<AtlasClassification> propagatedClassifications;
    private Set<AtlasClassification> blockedPropagatedClassifications;
    @JsonIgnore
    private static AtomicLong s_nextId = new AtomicLong(System.nanoTime());

    public AtlasRelationship() {
        this.init();
    }

    public AtlasRelationship(String typeName) {
        this(typeName, null);
    }

    public AtlasRelationship(String typeName, Map<String, Object> attributes) {
        super(typeName, attributes);
        this.init();
    }

    public AtlasRelationship(String typeName, AtlasObjectId end1, AtlasObjectId end2) {
        super(typeName);
        this.init(AtlasRelationship.nextInternalId(), null, 0, end1, end2, null, null, null, null, null, null, null, 0L, null, null);
    }

    public AtlasRelationship(String typeName, AtlasObjectId end1, AtlasObjectId end2, Map<String, Object> attributes) {
        super(typeName, attributes);
        this.init(AtlasRelationship.nextInternalId(), null, 0, end1, end2, null, null, null, null, null, null, null, 0L, null, null);
    }

    public AtlasRelationship(String typeName, String attrName, Object attrValue) {
        super(typeName, attrName, attrValue);
        this.init();
    }

    public AtlasRelationship(AtlasRelationshipDef relationshipDef) {
        this(relationshipDef != null ? relationshipDef.getName() : null);
    }

    public AtlasRelationship(Map map) {
        super(map);
        if (map != null) {
            Object oGuid = map.get(KEY_GUID);
            Object homeId = map.get(KEY_HOME_ID);
            Object provenanceType = map.get(KEY_PROVENANCE_TYPE);
            Object oEnd1 = map.get(KEY_END1);
            Object oEnd2 = map.get(KEY_END2);
            Object label = map.get(KEY_LABEL);
            Object propagateTags = map.get(KEY_PROPAGATE_TAGS);
            Object status = map.get(KEY_STATUS);
            Object createdBy = map.get(KEY_CREATED_BY);
            Object updatedBy = map.get(KEY_UPDATED_BY);
            Object createTime = map.get(KEY_CREATE_TIME);
            Object updateTime = map.get(KEY_UPDATE_TIME);
            Object version = map.get(KEY_VERSION);
            Object propagatedClassifications = map.get(KEY_PROPAGATED_CLASSIFICATIONS);
            Object blockedPropagatedClassifications = map.get(KEY_BLOCKED_PROPAGATED_CLASSIFICATIONS);
            if (oGuid != null) {
                this.setGuid(oGuid.toString());
            }
            if (homeId != null) {
                this.setHomeId(homeId.toString());
            }
            if (provenanceType instanceof Number) {
                this.setProvenanceType(((Number)provenanceType).intValue());
            }
            if (oEnd1 != null) {
                if (oEnd1 instanceof AtlasObjectId) {
                    this.setEnd1((AtlasObjectId)oEnd1);
                } else if (oEnd1 instanceof Map) {
                    this.setEnd1(new AtlasObjectId((Map)oEnd1));
                }
            }
            if (oEnd2 != null) {
                if (oEnd2 instanceof AtlasObjectId) {
                    this.setEnd2((AtlasObjectId)oEnd2);
                } else if (oEnd2 instanceof Map) {
                    this.setEnd2(new AtlasObjectId((Map)oEnd2));
                }
            }
            if (label != null) {
                this.setLabel(label.toString());
            }
            if (propagateTags != null) {
                this.setPropagateTags(AtlasRelationshipDef.PropagateTags.valueOf(propagateTags.toString()));
            }
            if (status != null) {
                this.setStatus(Status.valueOf(status.toString()));
            }
            if (createdBy != null) {
                this.setCreatedBy(createdBy.toString());
            }
            if (createTime instanceof Number) {
                this.setCreateTime(new Date(((Number)createTime).longValue()));
            }
            if (updatedBy != null) {
                this.setUpdatedBy(updatedBy.toString());
            }
            if (updateTime instanceof Number) {
                this.setUpdateTime(new Date(((Number)updateTime).longValue()));
            }
            if (version instanceof Number) {
                this.setVersion(((Number)version).longValue());
            }
            if (CollectionUtils.isNotEmpty((Collection)((List)propagatedClassifications))) {
                this.propagatedClassifications = new HashSet<AtlasClassification>();
                for (Object elem : (List)propagatedClassifications) {
                    if (elem instanceof AtlasClassification) {
                        this.propagatedClassifications.add((AtlasClassification)elem);
                        continue;
                    }
                    if (!(elem instanceof Map)) continue;
                    this.propagatedClassifications.add(new AtlasClassification((Map)elem));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)((List)blockedPropagatedClassifications))) {
                this.blockedPropagatedClassifications = new HashSet<AtlasClassification>();
                for (Object elem : (List)blockedPropagatedClassifications) {
                    if (elem instanceof AtlasClassification) {
                        this.blockedPropagatedClassifications.add((AtlasClassification)elem);
                        continue;
                    }
                    if (!(elem instanceof Map)) continue;
                    this.blockedPropagatedClassifications.add(new AtlasClassification((Map)elem));
                }
            }
        }
    }

    public AtlasRelationship(AtlasRelationship other) {
        super(other);
        if (other != null) {
            this.init(other.guid, other.homeId, other.provenanceType, other.end1, other.end2, other.label, other.propagateTags, other.status, other.createdBy, other.updatedBy, other.createTime, other.updateTime, other.version, other.propagatedClassifications, other.blockedPropagatedClassifications);
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getHomeId() {
        return this.homeId;
    }

    public void setHomeId(String homeId) {
        this.homeId = homeId;
    }

    public Integer getProvenanceType() {
        return this.provenanceType;
    }

    public void setProvenanceType(Integer provenanceType) {
        this.provenanceType = provenanceType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public AtlasObjectId getEnd1() {
        return this.end1;
    }

    public void setEnd1(AtlasObjectId end1) {
        this.end1 = end1;
    }

    public AtlasObjectId getEnd2() {
        return this.end2;
    }

    public void setEnd2(AtlasObjectId end2) {
        this.end2 = end2;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public AtlasRelationshipDef.PropagateTags getPropagateTags() {
        return this.propagateTags;
    }

    public void setPropagateTags(AtlasRelationshipDef.PropagateTags propagateTags) {
        this.propagateTags = propagateTags;
    }

    private static String nextInternalId() {
        return "-" + Long.toString(s_nextId.getAndIncrement());
    }

    public Set<AtlasClassification> getPropagatedClassifications() {
        return this.propagatedClassifications;
    }

    public void setPropagatedClassifications(Set<AtlasClassification> propagatedClassifications) {
        this.propagatedClassifications = propagatedClassifications;
    }

    public Set<AtlasClassification> getBlockedPropagatedClassifications() {
        return this.blockedPropagatedClassifications;
    }

    public void setBlockedPropagatedClassifications(Set<AtlasClassification> blockedPropagatedClassifications) {
        this.blockedPropagatedClassifications = blockedPropagatedClassifications;
    }

    private void init() {
        this.init(AtlasRelationship.nextInternalId(), null, 0, null, null, null, null, null, null, null, null, null, 0L, null, null);
    }

    private void init(String guid, String homeId, Integer provenanceType, AtlasObjectId end1, AtlasObjectId end2, String label, AtlasRelationshipDef.PropagateTags propagateTags, Status status, String createdBy, String updatedBy, Date createTime, Date updateTime, Long version, Set<AtlasClassification> propagatedClassifications, Set<AtlasClassification> blockedPropagatedClassifications) {
        this.setGuid(guid);
        this.setHomeId(homeId);
        this.setProvenanceType(provenanceType);
        this.setEnd1(end1);
        this.setEnd2(end2);
        this.setLabel(label);
        this.setPropagateTags(propagateTags);
        this.setStatus(status);
        this.setCreatedBy(createdBy);
        this.setUpdatedBy(updatedBy);
        this.setCreateTime(createTime);
        this.setUpdateTime(updateTime);
        this.setVersion(version);
        this.setPropagatedClassifications(propagatedClassifications);
        this.setBlockedPropagatedClassifications(blockedPropagatedClassifications);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasRelationship{");
        super.toString(sb);
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", homeId='").append(this.homeId).append('\'');
        sb.append(", provenanceType=").append(this.provenanceType);
        sb.append(", end1=").append(this.end1);
        sb.append(", end2=").append(this.end2);
        sb.append(", label='").append(this.label).append('\'');
        sb.append(", propagateTags=").append((Object)this.propagateTags);
        sb.append(", status=").append((Object)this.status);
        sb.append(", createdBy='").append(this.createdBy).append('\'');
        sb.append(", updatedBy='").append(this.updatedBy).append('\'');
        AtlasRelationship.dumpDateField(", createTime=", this.createTime, sb);
        AtlasRelationship.dumpDateField(", updateTime=", this.updateTime, sb);
        sb.append(", version=").append(this.version);
        sb.append(", propagatedClassifications=[");
        AtlasRelationship.dumpObjects(this.propagatedClassifications, sb);
        sb.append("]");
        sb.append(", blockedPropagatedClassifications=[");
        AtlasRelationship.dumpObjects(this.blockedPropagatedClassifications, sb);
        sb.append("]");
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasRelationship that = (AtlasRelationship)o;
        return Objects.equals(this.guid, that.guid) && Objects.equals(this.homeId, that.homeId) && Objects.equals(this.provenanceType, that.provenanceType) && Objects.equals(this.end1, that.end1) && Objects.equals(this.end2, that.end2) && Objects.equals(this.label, that.label) && this.propagateTags == that.propagateTags && this.status == that.status && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.updatedBy, that.updatedBy) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.updateTime, that.updateTime) && Objects.equals(this.version, that.version) && Objects.equals(this.propagatedClassifications, that.propagatedClassifications) && Objects.equals(this.blockedPropagatedClassifications, that.blockedPropagatedClassifications);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.guid, this.homeId, this.provenanceType, this.end1, this.end2, this.label, this.propagateTags, this.status, this.createdBy, this.updatedBy, this.createTime, this.updateTime, this.version, this.propagatedClassifications, this.blockedPropagatedClassifications});
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static enum Status {
        ACTIVE,
        DELETED;

    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasRelationshipWithExtInfo
    implements Serializable {
        private AtlasRelationship relationship;
        private Map<String, AtlasEntityHeader> referredEntities;

        public AtlasRelationshipWithExtInfo() {
        }

        public AtlasRelationshipWithExtInfo(AtlasRelationship relationship) {
            this.setRelationship(relationship);
        }

        public AtlasRelationship getRelationship() {
            return this.relationship;
        }

        public void setRelationship(AtlasRelationship relationship) {
            this.relationship = relationship;
        }

        public Map<String, AtlasEntityHeader> getReferredEntities() {
            return this.referredEntities;
        }

        public void setReferredEntities(Map<String, AtlasEntityHeader> referredEntities) {
            this.referredEntities = referredEntities;
        }

        public boolean referredEntitiesContains(String guid) {
            return this.referredEntities != null ? this.referredEntities.containsKey(guid) : false;
        }

        @JsonIgnore
        public final void addReferredEntity(String guid, AtlasEntityHeader entityHeader) {
            Map<String, AtlasEntityHeader> r = this.referredEntities;
            if (r == null) {
                this.referredEntities = r = new HashMap<String, AtlasEntityHeader>();
            }
            if (guid != null) {
                r.put(guid, entityHeader);
            }
        }

        @JsonIgnore
        public final AtlasEntityHeader removeReferredEntity(String guid) {
            Map<String, AtlasEntityHeader> r = this.referredEntities;
            return r != null && guid != null ? r.remove(guid) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AtlasRelationshipWithExtInfo that = (AtlasRelationshipWithExtInfo)o;
            return Objects.equals(this.relationship, that.relationship) && Objects.equals(this.referredEntities, that.referredEntities);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.relationship, this.referredEntities);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AtlasRelationshipWithExtInfo{");
            sb.append("relationship=").append(this.relationship);
            sb.append(", referredEntities=").append(this.referredEntities);
            sb.append('}');
            return sb.toString();
        }
    }
}

