/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.glossary.relations.AtlasTermAssignmentHeader;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasEntity
extends AtlasStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_GUID = "guid";
    public static final String KEY_HOME_ID = "homeId";
    public static final String KEY_IS_PROXY = "isProxy";
    public static final String KEY_IS_INCOMPLETE = "isIncomplete";
    public static final String KEY_PROVENANCE_TYPE = "provenanceType";
    public static final String KEY_STATUS = "status";
    public static final String KEY_CREATED_BY = "createdBy";
    public static final String KEY_UPDATED_BY = "updatedBy";
    public static final String KEY_CREATE_TIME = "createTime";
    public static final String KEY_UPDATE_TIME = "updateTime";
    public static final String KEY_VERSION = "version";
    private String guid = null;
    private String homeId = null;
    private Boolean isProxy = Boolean.FALSE;
    private Boolean isIncomplete = Boolean.FALSE;
    private Integer provenanceType = 0;
    private Status status = Status.ACTIVE;
    private String createdBy = null;
    private String updatedBy = null;
    private Date createTime = null;
    private Date updateTime = null;
    private Long version = 0L;
    private Map<String, Object> relationshipAttributes;
    private List<AtlasClassification> classifications;
    private List<AtlasTermAssignmentHeader> meanings;
    private Map<String, String> customAttributes;
    private Map<String, Map<String, Object>> businessAttributes;
    private Set<String> labels;
    private Set<String> pendingTasks;
    @JsonIgnore
    private static AtomicLong s_nextId = new AtomicLong(System.nanoTime());

    public AtlasEntity() {
        this(null, null);
    }

    public AtlasEntity(String typeName) {
        this(typeName, null);
    }

    public AtlasEntity(AtlasEntityDef entityDef) {
        this(entityDef != null ? entityDef.getName() : null, null);
    }

    public AtlasEntity(String typeName, String attrName, Object attrValue) {
        super(typeName, attrName, attrValue);
        this.init();
    }

    public AtlasEntity(String typeName, Map<String, Object> attributes) {
        super(typeName, attributes);
        this.init();
    }

    public AtlasEntity(AtlasEntityHeader header) {
        super(header.getTypeName(), header.getAttributes());
        this.setGuid(header.getGuid());
        this.setStatus(header.getStatus());
        this.setClassifications(header.getClassifications());
        this.setMeanings(header.getMeanings());
    }

    public AtlasEntity(Map map) {
        super(map);
        if (map != null) {
            Object oGuid = map.get(KEY_GUID);
            Object homeId = map.get(KEY_HOME_ID);
            Object isProxy = map.get(KEY_IS_PROXY);
            Object isIncomplete = map.get(KEY_IS_INCOMPLETE);
            Object provenanceType = map.get(KEY_PROVENANCE_TYPE);
            Object status = map.get(KEY_STATUS);
            Object createdBy = map.get(KEY_CREATED_BY);
            Object updatedBy = map.get(KEY_UPDATED_BY);
            Object createTime = map.get(KEY_CREATE_TIME);
            Object updateTime = map.get(KEY_UPDATE_TIME);
            Object version = map.get(KEY_VERSION);
            if (oGuid != null) {
                this.setGuid(oGuid.toString());
            }
            if (homeId != null) {
                this.setHomeId(homeId.toString());
            }
            if (isProxy != null) {
                this.setIsProxy((Boolean)isProxy);
            } else {
                this.setIsProxy(Boolean.FALSE);
            }
            if (isIncomplete != null) {
                this.setIsIncomplete((Boolean)isIncomplete);
            } else {
                this.setIsIncomplete(Boolean.FALSE);
            }
            if (provenanceType instanceof Number) {
                this.setProvenanceType(((Number)version).intValue());
            }
            if (status != null) {
                this.setStatus(Status.valueOf(status.toString()));
            }
            if (createdBy != null) {
                this.setCreatedBy(createdBy.toString());
            }
            if (createTime instanceof Number) {
                this.setCreateTime(new Date(((Number)createTime).longValue()));
            }
            if (updatedBy != null) {
                this.setUpdatedBy(updatedBy.toString());
            }
            if (updateTime instanceof Number) {
                this.setUpdateTime(new Date(((Number)updateTime).longValue()));
            }
            if (version instanceof Number) {
                this.setVersion(((Number)version).longValue());
            }
        }
    }

    public AtlasEntity(AtlasEntity other) {
        super(other);
        if (other != null) {
            this.setGuid(other.getGuid());
            this.setHomeId(other.getHomeId());
            this.setIsProxy(other.isProxy());
            this.setIsIncomplete(other.getIsIncomplete());
            this.setProvenanceType(other.getProvenanceType());
            this.setStatus(other.getStatus());
            this.setCreatedBy(other.getCreatedBy());
            this.setUpdatedBy(other.getUpdatedBy());
            this.setCreateTime(other.getCreateTime());
            this.setUpdateTime(other.getUpdateTime());
            this.setVersion(other.getVersion());
            this.setClassifications(other.getClassifications());
            this.setRelationshipAttributes(other.getRelationshipAttributes());
            this.setMeanings(other.getMeanings());
            this.setCustomAttributes(other.getCustomAttributes());
            this.setBusinessAttributes(other.getBusinessAttributes());
            this.setLabels(other.getLabels());
            this.setPendingTasks(other.getPendingTasks());
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getHomeId() {
        return this.homeId;
    }

    public void setHomeId(String homeId) {
        this.homeId = homeId;
    }

    public Boolean isProxy() {
        return this.isProxy;
    }

    public void setIsProxy(Boolean isProxy) {
        this.isProxy = isProxy;
    }

    public Boolean getIsIncomplete() {
        return this.isIncomplete;
    }

    public void setIsIncomplete(Boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
    }

    public Integer getProvenanceType() {
        return this.provenanceType;
    }

    public void setProvenanceType(Integer provenanceType) {
        this.provenanceType = provenanceType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Map<String, Object> getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    public void setRelationshipAttributes(Map<String, Object> relationshipAttributes) {
        this.relationshipAttributes = relationshipAttributes;
    }

    public void setRelationshipAttribute(String name, Object value) {
        Map<String, Object> r = this.relationshipAttributes;
        if (r != null) {
            r.put(name, value);
        } else {
            r = new HashMap<String, Object>();
            r.put(name, value);
            this.relationshipAttributes = r;
        }
    }

    public Object getRelationshipAttribute(String name) {
        Map<String, Object> a = this.relationshipAttributes;
        return a != null ? a.get(name) : null;
    }

    public boolean hasRelationshipAttribute(String name) {
        Map<String, Object> r = this.relationshipAttributes;
        return r != null ? r.containsKey(name) : false;
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(Map<String, String> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public Map<String, Map<String, Object>> getBusinessAttributes() {
        return this.businessAttributes;
    }

    public void setBusinessAttributes(Map<String, Map<String, Object>> businessAttributes) {
        this.businessAttributes = businessAttributes;
    }

    public void setBusinessAttribute(String nsName, String nsAttrName, Object nsValue) {
        Map<String, Object> businessAttributeMap;
        Map<String, Map<String, Object>> businessAttributes = this.businessAttributes;
        if (businessAttributes == null) {
            this.businessAttributes = businessAttributes = new HashMap<String, Map<String, Object>>();
        }
        if ((businessAttributeMap = businessAttributes.get(nsName)) == null) {
            businessAttributeMap = new HashMap<String, Object>();
            businessAttributes.put(nsName, businessAttributeMap);
        }
        businessAttributeMap.put(nsAttrName, nsValue);
    }

    public Object getBusinessAttribute(String bmName, String bmAttrName) {
        Map<String, Map<String, Object>> businessAttributes = this.businessAttributes;
        Map<String, Object> businessAttributeMap = businessAttributes == null ? null : businessAttributes.get(bmName);
        return businessAttributeMap == null ? null : businessAttributeMap.get(bmAttrName);
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<String> labels) {
        this.labels = labels;
    }

    public Set<String> getPendingTasks() {
        return this.pendingTasks;
    }

    public void setPendingTasks(Set<String> pendingTasks) {
        this.pendingTasks = pendingTasks;
    }

    public List<AtlasClassification> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<AtlasClassification> classifications) {
        this.classifications = classifications;
    }

    public void addClassifications(List<AtlasClassification> classifications) {
        List<AtlasClassification> c = this.classifications;
        if (c == null) {
            c = new ArrayList<AtlasClassification>();
        }
        c.addAll(classifications);
        this.classifications = c;
    }

    public List<AtlasTermAssignmentHeader> getMeanings() {
        return this.meanings;
    }

    public void setMeanings(List<AtlasTermAssignmentHeader> meanings) {
        this.meanings = meanings;
    }

    public void addMeaning(AtlasTermAssignmentHeader meaning) {
        List<AtlasTermAssignmentHeader> meanings = this.meanings;
        if (meanings == null) {
            meanings = new ArrayList<AtlasTermAssignmentHeader>();
        }
        meanings.add(meaning);
        this.setMeanings(meanings);
    }

    private void init() {
        this.setGuid(AtlasEntity.nextInternalId());
        this.setHomeId(null);
        this.setIsProxy(Boolean.FALSE);
        this.setIsIncomplete(Boolean.FALSE);
        this.setProvenanceType(0);
        this.setStatus(null);
        this.setCreatedBy(null);
        this.setUpdatedBy(null);
        this.setCreateTime(null);
        this.setUpdateTime(null);
        this.setClassifications(null);
        this.setMeanings(null);
        this.setCustomAttributes(null);
        this.setBusinessAttributes(null);
        this.setLabels(null);
        this.setPendingTasks(null);
    }

    private static String nextInternalId() {
        return "-" + Long.toString(s_nextId.getAndIncrement());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasEntity{");
        super.toString(sb);
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", homeId='").append(this.homeId).append('\'');
        sb.append(", isProxy='").append(this.isProxy).append('\'');
        sb.append(", isIncomplete=").append(this.isIncomplete);
        sb.append(", provenanceType=").append(this.provenanceType);
        sb.append(", status=").append((Object)this.status);
        sb.append(", createdBy='").append(this.createdBy).append('\'');
        sb.append(", updatedBy='").append(this.updatedBy).append('\'');
        AtlasEntity.dumpDateField(", createTime=", this.createTime, sb);
        AtlasEntity.dumpDateField(", updateTime=", this.updateTime, sb);
        sb.append(", version=").append(this.version);
        sb.append(", relationshipAttributes=[");
        AtlasEntity.dumpObjects(this.relationshipAttributes, sb);
        sb.append("]");
        sb.append(", classifications=[");
        AtlasBaseTypeDef.dumpObjects(this.classifications, sb);
        sb.append(']');
        sb.append(", meanings=[");
        AtlasBaseTypeDef.dumpObjects(this.meanings, sb);
        sb.append(']');
        sb.append(", customAttributes=[");
        AtlasEntity.dumpObjects(this.customAttributes, sb);
        sb.append("]");
        sb.append(", businessAttributes=[");
        AtlasEntity.dumpObjects(this.businessAttributes, sb);
        sb.append("]");
        sb.append(", labels=[");
        AtlasEntity.dumpObjects(this.labels, sb);
        sb.append("]");
        sb.append(", pendingTasks=[");
        AtlasEntity.dumpObjects(this.pendingTasks, sb);
        sb.append("]");
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasEntity that = (AtlasEntity)o;
        return Objects.equals(this.guid, that.guid) && Objects.equals(this.homeId, that.homeId) && Objects.equals(this.isProxy, that.isProxy) && Objects.equals(this.isIncomplete, that.isIncomplete) && Objects.equals(this.provenanceType, that.provenanceType) && this.status == that.status && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.updatedBy, that.updatedBy) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.updateTime, that.updateTime) && Objects.equals(this.version, that.version) && Objects.equals(this.relationshipAttributes, that.relationshipAttributes) && Objects.equals(this.customAttributes, that.customAttributes) && Objects.equals(this.businessAttributes, that.businessAttributes) && Objects.equals(this.labels, that.labels) && Objects.equals(this.classifications, that.classifications);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.guid, this.homeId, this.isProxy, this.isIncomplete, this.provenanceType, this.status, this.createdBy, this.updatedBy, this.createTime, this.updateTime, this.version, this.relationshipAttributes, this.classifications, this.customAttributes, this.businessAttributes, this.labels});
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static enum Status {
        ACTIVE,
        DELETED,
        PURGED;

    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasEntity.class})
    public static class AtlasEntities
    extends PList<AtlasEntity> {
        private static final long serialVersionUID = 1L;

        public AtlasEntities() {
        }

        public AtlasEntities(List<AtlasEntity> list) {
            super(list);
        }

        public AtlasEntities(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasEntitiesWithExtInfo
    extends AtlasEntityExtInfo {
        private static final long serialVersionUID = 1L;
        private List<AtlasEntity> entities;

        public AtlasEntitiesWithExtInfo() {
            this(null, null);
        }

        public AtlasEntitiesWithExtInfo(AtlasEntity entity) {
            this(Arrays.asList(entity), null);
        }

        public AtlasEntitiesWithExtInfo(List<AtlasEntity> entities) {
            this(entities, null);
        }

        public AtlasEntitiesWithExtInfo(AtlasEntityWithExtInfo entity) {
            this(Arrays.asList(entity.getEntity()), entity);
        }

        public AtlasEntitiesWithExtInfo(List<AtlasEntity> entities, AtlasEntityExtInfo extInfo) {
            super(extInfo);
            this.entities = entities;
        }

        public List<AtlasEntity> getEntities() {
            return this.entities;
        }

        public void setEntities(List<AtlasEntity> entities) {
            this.entities = entities;
        }

        @Override
        @JsonIgnore
        public AtlasEntity getEntity(String guid) {
            AtlasEntity ret = super.getEntity(guid);
            if (ret == null && CollectionUtils.isNotEmpty(this.entities)) {
                for (AtlasEntity entity : this.entities) {
                    if (!StringUtils.equals((String)guid, (String)entity.getGuid())) continue;
                    ret = entity;
                    break;
                }
            }
            return ret;
        }

        public void addEntity(AtlasEntity entity) {
            List<AtlasEntity> entities = this.entities;
            if (entities == null) {
                this.entities = entities = new ArrayList<AtlasEntity>();
            }
            entities.add(entity);
        }

        public void removeEntity(AtlasEntity entity) {
            List<AtlasEntity> entities = this.entities;
            if (entity != null && entities != null) {
                entities.remove(entity);
            }
        }

        @Override
        public void compact() {
            super.compact();
            if (CollectionUtils.isNotEmpty(this.entities)) {
                for (AtlasEntity entity : this.entities) {
                    this.removeReferredEntity(entity.getGuid());
                }
            }
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasEntitiesWithExtInfo{");
            sb.append("entities=[");
            AtlasBaseTypeDef.dumpObjects(this.entities, sb);
            sb.append("],");
            super.toString(sb);
            sb.append("}");
            return sb;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasEntitiesWithExtInfo that = (AtlasEntitiesWithExtInfo)o;
            return Objects.equals(this.entities, that.entities);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.entities);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasEntityWithExtInfo
    extends AtlasEntityExtInfo {
        private static final long serialVersionUID = 1L;
        private AtlasEntity entity;

        public AtlasEntityWithExtInfo() {
            this(null, null);
        }

        public AtlasEntityWithExtInfo(AtlasEntity entity) {
            this(entity, null);
        }

        public AtlasEntityWithExtInfo(AtlasEntity entity, AtlasEntityExtInfo extInfo) {
            super(extInfo);
            this.entity = entity;
        }

        public AtlasEntity getEntity() {
            return this.entity;
        }

        public void setEntity(AtlasEntity entity) {
            this.entity = entity;
        }

        @Override
        @JsonIgnore
        public AtlasEntity getEntity(String guid) {
            AtlasEntity ret = super.getEntity(guid);
            if (ret == null && this.entity != null && StringUtils.equals((String)guid, (String)this.entity.getGuid())) {
                ret = this.entity;
            }
            return ret;
        }

        @Override
        @JsonIgnore
        public void compact() {
            super.compact();
            if (this.entity != null) {
                this.removeEntity(this.entity.getGuid());
            }
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasEntityWithExtInfo{");
            sb.append("entity=").append(this.entity).append(",");
            super.toString(sb);
            sb.append("}");
            return sb;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasEntityWithExtInfo that = (AtlasEntityWithExtInfo)o;
            return Objects.equals(this.entity, that.entity);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.entity);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasEntityExtInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, AtlasEntity> referredEntities;

        public AtlasEntityExtInfo() {
            this.setReferredEntities(null);
        }

        public AtlasEntityExtInfo(AtlasEntity referredEntity) {
            this.addReferredEntity(referredEntity);
        }

        public AtlasEntityExtInfo(Map<String, AtlasEntity> referredEntities) {
            this.setReferredEntities(referredEntities);
        }

        public AtlasEntityExtInfo(AtlasEntityExtInfo other) {
            if (other != null) {
                this.setReferredEntities(other.getReferredEntities());
            }
        }

        public Map<String, AtlasEntity> getReferredEntities() {
            return this.referredEntities;
        }

        public void setReferredEntities(Map<String, AtlasEntity> referredEntities) {
            this.referredEntities = referredEntities;
        }

        @JsonIgnore
        public final void addReferredEntity(AtlasEntity entity) {
            this.addReferredEntity(entity.getGuid(), entity);
        }

        @JsonIgnore
        public final void addReferredEntity(String guid, AtlasEntity entity) {
            Map<String, AtlasEntity> r = this.referredEntities;
            if (r == null) {
                this.referredEntities = r = new HashMap<String, AtlasEntity>();
            }
            if (guid != null) {
                r.put(guid, entity);
            }
        }

        @JsonIgnore
        public final AtlasEntity removeReferredEntity(String guid) {
            Map<String, AtlasEntity> r = this.referredEntities;
            return r != null && guid != null ? r.remove(guid) : null;
        }

        @JsonIgnore
        public final AtlasEntity getReferredEntity(String guid) {
            Map<String, AtlasEntity> r = this.referredEntities;
            return r != null && guid != null ? r.get(guid) : null;
        }

        @JsonIgnore
        public AtlasEntity getEntity(String guid) {
            return this.getReferredEntity(guid);
        }

        @JsonIgnore
        public AtlasEntity removeEntity(String guid) {
            Map<String, AtlasEntity> r = this.referredEntities;
            return r != null && guid != null ? r.remove(guid) : null;
        }

        public void updateEntityGuid(String oldGuid, String newGuid) {
            AtlasEntity entity = this.getEntity(oldGuid);
            if (entity != null) {
                entity.setGuid(newGuid);
                if (this.removeEntity(oldGuid) != null) {
                    this.addReferredEntity(newGuid, entity);
                }
            }
        }

        public boolean hasEntity(String guid) {
            return this.getEntity(guid) != null;
        }

        public void compact() {
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasEntityExtInfo{");
            sb.append("referredEntities={");
            AtlasBaseTypeDef.dumpObjects(this.referredEntities, sb);
            sb.append("}");
            sb.append("}");
            return sb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasEntityExtInfo that = (AtlasEntityExtInfo)o;
            return Objects.equals(this.referredEntities, that.referredEntities);
        }

        public int hashCode() {
            return Objects.hash(this.referredEntities);
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }
    }
}

