/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasCheckStateResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int entitiesScanned = 0;
    private int entitiesOk = 0;
    private int entitiesFixed = 0;
    private int entitiesPartiallyFixed = 0;
    private int entitiesNotFixed = 0;
    private State state = State.OK;
    private Map<String, AtlasEntityState> entities = null;

    public int getEntitiesScanned() {
        return this.entitiesScanned;
    }

    public void setEntitiesScanned(int entitiesScanned) {
        this.entitiesScanned = entitiesScanned;
    }

    public void incrEntitiesScanned() {
        ++this.entitiesScanned;
    }

    public int getEntitiesOk() {
        return this.entitiesOk;
    }

    public void setEntitiesOk(int entitiesOk) {
        this.entitiesOk = entitiesOk;
    }

    public void incrEntitiesOk() {
        ++this.entitiesOk;
    }

    public int getEntitiesFixed() {
        return this.entitiesFixed;
    }

    public void setEntitiesFixed(int entitiesFixed) {
        this.entitiesFixed = entitiesFixed;
    }

    public void incrEntitiesFixed() {
        ++this.entitiesFixed;
    }

    public int getEntitiesPartiallyFixed() {
        return this.entitiesPartiallyFixed;
    }

    public void setEntitiesPartiallyFixed(int entitiesPartiallyFixed) {
        this.entitiesPartiallyFixed = entitiesPartiallyFixed;
    }

    public void incrEntitiesPartiallyFixed() {
        ++this.entitiesPartiallyFixed;
    }

    public int getEntitiesNotFixed() {
        return this.entitiesNotFixed;
    }

    public void setEntitiesNotFixed(int entitiesNotFixed) {
        this.entitiesNotFixed = entitiesNotFixed;
    }

    public void incrEntitiesNotFixed() {
        ++this.entitiesNotFixed;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Map<String, AtlasEntityState> getEntities() {
        return this.entities;
    }

    public void setEntities(Map<String, AtlasEntityState> entities) {
        this.entities = entities;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasCheckStateResult{");
        sb.append("entitiesScanned='").append(this.entitiesScanned);
        sb.append(", entitiesFixed=").append(this.entitiesFixed);
        sb.append(", entitiesPartiallyFixed=").append(this.entitiesPartiallyFixed);
        sb.append(", entitiesNotFixed=").append(this.entitiesNotFixed);
        sb.append(", state=").append((Object)this.state);
        sb.append("entities=[");
        if (this.entities != null) {
            boolean isFirst = true;
            for (Map.Entry<String, AtlasEntityState> entry : this.entities.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                sb.append(entry.getKey()).append(":");
                entry.getValue().toString(sb);
            }
        }
        sb.append("]");
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static enum State {
        OK,
        FIXED,
        PARTIALLY_FIXED,
        NOT_FIXED;

    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasEntityState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String guid;
        private String typeName;
        private String name;
        private AtlasEntity.Status status;
        private State state = State.OK;
        private List<String> issues;

        public String getGuid() {
            return this.guid;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public AtlasEntity.Status getStatus() {
            return this.status;
        }

        public void setStatus(AtlasEntity.Status status) {
            this.status = status;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public List<String> getIssues() {
            return this.issues;
        }

        public void setIssues(List<String> issues) {
            this.issues = issues;
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasEntityState{");
            sb.append("guid=").append(this.guid);
            sb.append(", typeName=").append(this.typeName);
            sb.append(", name=").append(this.name);
            sb.append(", status=").append((Object)this.status);
            sb.append(", state=").append((Object)this.state);
            sb.append(", issues=[");
            AtlasBaseTypeDef.dumpObjects(this.issues, sb);
            sb.append("]");
            sb.append("}");
            return sb;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }
    }
}

