/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasShortType {
    private final AtlasBuiltInTypes.AtlasShortType shortType = new AtlasBuiltInTypes.AtlasShortType();
    private final Object[] validValues = new Object[]{null, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1L), "1"};
    private final Object[] validValuesLimitCheck = new Object[]{(byte)-128, (byte)127, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, Float.valueOf(Float.MIN_VALUE), Double.MIN_VALUE};
    private final Object[] negativeValues = new Object[]{(byte)-1, (short)-1, -1, -1L, Float.valueOf(-1.0f), -1.0, BigInteger.valueOf(-1L), BigDecimal.valueOf(-1L), "-1"};
    private final Object[] negativeValuesLimitCheck = new Object[]{Float.valueOf(-1.4E-45f), -4.9E-324};
    private final Object[] invalidValues = new Object[]{"", "12ab", "abcd", "-12ab", -32769, 32768, Integer.MIN_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Double.MAX_VALUE, Float.valueOf(-3.4028235E38f), -1.7976931348623157E308};

    @Test
    public void testShortTypeDefaultValue() {
        Short defValue = this.shortType.createDefaultValue();
        Assert.assertEquals((Object)defValue, (Object)0);
    }

    @Test
    public void testShortTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.shortType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.validValuesLimitCheck) {
            Assert.assertTrue((boolean)this.shortType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.shortType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.negativeValuesLimitCheck) {
            Assert.assertTrue((boolean)this.shortType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.shortType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testShortTypeGetNormalizedValue() {
        short s;
        Short normalizedValue;
        Assert.assertNull((Object)this.shortType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            normalizedValue = this.shortType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)1, (String)("value=" + value));
        }
        for (Object value : this.validValuesLimitCheck) {
            if (value == null) continue;
            normalizedValue = this.shortType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            if (value instanceof Float) {
                s = ((Float)value).shortValue();
                Assert.assertEquals((Object)normalizedValue, (Object)s, (String)("value=" + value));
                continue;
            }
            if (value instanceof Double) {
                s = ((Double)value).shortValue();
                Assert.assertEquals((Object)normalizedValue, (Object)s, (String)("value=" + value));
                continue;
            }
            Assert.assertEquals((Object)normalizedValue, (Object)Short.valueOf(value.toString()), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            normalizedValue = this.shortType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)-1, (String)("value=" + value));
        }
        for (Object value : this.negativeValuesLimitCheck) {
            normalizedValue = this.shortType.getNormalizedValue(value);
            if (value instanceof Float) {
                s = ((Float)value).shortValue();
                Assert.assertEquals((Object)normalizedValue, (Object)s, (String)("value=" + value));
                continue;
            }
            if (!(value instanceof Double)) continue;
            s = ((Double)value).shortValue();
            Assert.assertEquals((Object)normalizedValue, (Object)s, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.shortType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testShortTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.shortType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.validValuesLimitCheck) {
            Assert.assertTrue((boolean)this.shortType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.shortType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.negativeValuesLimitCheck) {
            Assert.assertTrue((boolean)this.shortType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.shortType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

