/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.TimeBoundary;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasClassificationType {
    private final AtlasClassificationType classificationType;
    private final List<Object> validValues = new ArrayList<Object>();
    private final List<Object> invalidValues = new ArrayList<Object>();

    public TestAtlasClassificationType() {
        this.classificationType = TestAtlasClassificationType.getClassificationType(ModelTestUtil.getClassificationDefWithSuperTypes());
        AtlasClassification invalidValue1 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValue2 = this.classificationType.createDefaultValue();
        Map invalidValue3 = this.classificationType.createDefaultValue().getAttributes();
        AtlasClassification validValueTB1 = this.classificationType.createDefaultValue();
        AtlasClassification validValueTB2 = this.classificationType.createDefaultValue();
        AtlasClassification validValueTB3 = this.classificationType.createDefaultValue();
        AtlasClassification validValueTB4 = this.classificationType.createDefaultValue();
        AtlasClassification validValueTB5 = this.classificationType.createDefaultValue();
        AtlasClassification validValueTB6 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValueTB1 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValueTB2 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValueTB3 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValueTB4 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValueTB5 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValueTB6 = this.classificationType.createDefaultValue();
        TimeBoundary validTB1 = new TimeBoundary("2018/07/07 04:38:55");
        TimeBoundary validTB2 = new TimeBoundary(null, "2018/07/08 04:38:55");
        TimeBoundary validTB3 = new TimeBoundary("2018/07/07 04:38:55", "2018/07/08 04:38:55");
        TimeBoundary validTB4 = new TimeBoundary("2018/07/07 04:38:55", "2018/07/08 04:38:55", "America/Los_Angeles");
        TimeBoundary validTB5 = new TimeBoundary(null, "2018/07/08 04:38:55", "GMT+10:30");
        TimeBoundary validTB6 = new TimeBoundary("2018/07/07 04:38:55", "2018/07/08 04:38:55", "GMT");
        TimeBoundary validTB7 = new TimeBoundary("2018/07/07 04:38:55", "2019/07/08 04:38:55", null);
        TimeBoundary invalidTB1 = new TimeBoundary("2018-07-07 04:38:55");
        TimeBoundary invalidTB2 = new TimeBoundary(null, "2018-07-08 04:38:55");
        TimeBoundary invalidTB3 = new TimeBoundary("2018/07/08 04:38:55", "2018/07/07 04:38:55");
        TimeBoundary invalidTB4 = new TimeBoundary("2018/07/08 04:38:55", "2018/07/07 04:38:55", "");
        TimeBoundary invalidTB5 = new TimeBoundary("2018/07/08 04:38:55", "2018/07/07 04:38:55", "GMT+10:-30");
        TimeBoundary invalidTB6 = new TimeBoundary("2018/07/08 04:38:55", "2018/07/07 04:38:55", "abcd");
        validValueTB1.addValityPeriod(validTB1);
        validValueTB2.addValityPeriod(validTB2);
        validValueTB3.addValityPeriod(validTB3);
        validValueTB4.addValityPeriod(validTB4);
        validValueTB5.addValityPeriod(validTB5);
        validValueTB6.addValityPeriod(validTB6);
        validValueTB6.addValityPeriod(validTB7);
        invalidValueTB1.addValityPeriod(invalidTB1);
        invalidValueTB2.addValityPeriod(invalidTB2);
        invalidValueTB3.addValityPeriod(invalidTB3);
        invalidValueTB4.addValityPeriod(invalidTB4);
        invalidValueTB5.addValityPeriod(invalidTB5);
        invalidValueTB6.addValityPeriod(invalidTB6);
        invalidValue1.setAttribute(ModelTestUtil.getDefaultAttributeName("int"), (Object)"xyz");
        invalidValue2.setAttribute(ModelTestUtil.getDefaultAttributeName("date"), (Object)"xyz");
        invalidValue3.put(ModelTestUtil.getDefaultAttributeName("biginteger"), "xyz");
        this.validValues.add(null);
        this.validValues.add(this.classificationType.createDefaultValue());
        this.validValues.add(this.classificationType.createDefaultValue().getAttributes());
        this.validValues.add(validValueTB1);
        this.validValues.add(validValueTB2);
        this.validValues.add(validValueTB3);
        this.validValues.add(validValueTB4);
        this.validValues.add(validValueTB5);
        this.validValues.add(validValueTB6);
        this.invalidValues.add(invalidValue1);
        this.invalidValues.add(invalidValue2);
        this.invalidValues.add(invalidValue3);
        this.invalidValues.add(new AtlasClassification());
        this.invalidValues.add(new HashMap());
        this.invalidValues.add(1);
        this.invalidValues.add(new HashSet());
        this.invalidValues.add(new ArrayList());
        this.invalidValues.add(new String[0]);
        this.invalidValues.add(invalidValueTB1);
        this.invalidValues.add(invalidValueTB2);
        this.invalidValues.add(invalidValueTB3);
        this.invalidValues.add(invalidValueTB4);
        this.invalidValues.add(invalidValueTB5);
        this.invalidValues.add(invalidValueTB6);
    }

    @Test
    public void testClassificationTypeDefaultValue() {
        AtlasClassification defValue = this.classificationType.createDefaultValue();
        Assert.assertNotNull((Object)defValue);
        Assert.assertEquals((String)defValue.getTypeName(), (String)this.classificationType.getTypeName());
    }

    @Test
    public void testcanApplyToEntityType() throws AtlasBaseException {
        AtlasEntityDef entityDefA = new AtlasEntityDef("EntityA");
        AtlasEntityDef entityDefB = new AtlasEntityDef("EntityB");
        AtlasEntityDef entityDefC = new AtlasEntityDef("EntityC", null, null, null, new HashSet<String>(Arrays.asList(entityDefA.getName())));
        AtlasEntityDef entityDefD = new AtlasEntityDef("EntityD", null, null, null, new HashSet<String>(Arrays.asList(entityDefC.getName())));
        AtlasEntityDef entityDefE = new AtlasEntityDef("EntityE");
        AtlasEntityDef entityDefF = new AtlasEntityDef("EntityF", null, null, null, new HashSet<String>(Arrays.asList(entityDefB.getName(), entityDefE.getName())));
        AtlasClassificationDef classifyDef1 = new AtlasClassificationDef("Classify1", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefA.getName())), null);
        AtlasClassificationDef classifyDef2 = new AtlasClassificationDef("Classify2");
        AtlasClassificationDef classifyDef3 = new AtlasClassificationDef("Classify3", null, null, null, new HashSet<String>(Arrays.asList(classifyDef1.getName())), null, null);
        AtlasClassificationDef classifyDef4 = new AtlasClassificationDef("Classify4", null, null, null, new HashSet<String>(Arrays.asList(classifyDef1.getName())), new HashSet<String>(Arrays.asList(entityDefD.getName())), null);
        AtlasClassificationDef classifyDef5 = new AtlasClassificationDef("Classify5", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefA.getName(), entityDefC.getName())), null);
        AtlasClassificationDef classifyDef6 = new AtlasClassificationDef("Classify6", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefB.getName())), null);
        AtlasClassificationDef classifyDef7 = new AtlasClassificationDef("Classify7", null, null, null, new HashSet<String>(Arrays.asList(classifyDef1.getName(), classifyDef6.getName())), null, null);
        AtlasClassificationDef classifyDef8 = new AtlasClassificationDef("Classify8", null, null, null, new HashSet<String>(Arrays.asList(classifyDef6.getName())), new HashSet<String>(Arrays.asList(entityDefA.getName())), null);
        AtlasClassificationDef classifyDef9 = new AtlasClassificationDef("Classify9", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefE.getName())), null);
        AtlasClassificationDef classifyDef10 = new AtlasClassificationDef("Classify10", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefC.getName(), entityDefA.getName())), null);
        AtlasTypeRegistry registry = ModelTestUtil.getTypesRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = registry.lockTypeRegistryForUpdate();
        ttr.addType((AtlasBaseTypeDef)entityDefA);
        ttr.addType((AtlasBaseTypeDef)entityDefB);
        ttr.addType((AtlasBaseTypeDef)entityDefC);
        ttr.addType((AtlasBaseTypeDef)entityDefD);
        ttr.addType((AtlasBaseTypeDef)entityDefE);
        ttr.addType((AtlasBaseTypeDef)entityDefF);
        ttr.addType((AtlasBaseTypeDef)classifyDef1);
        ttr.addType((AtlasBaseTypeDef)classifyDef2);
        ttr.addType((AtlasBaseTypeDef)classifyDef3);
        ttr.addType((AtlasBaseTypeDef)classifyDef4);
        ttr.addType((AtlasBaseTypeDef)classifyDef5);
        ttr.addType((AtlasBaseTypeDef)classifyDef6);
        ttr.addType((AtlasBaseTypeDef)classifyDef9);
        ttr.addType((AtlasBaseTypeDef)classifyDef10);
        registry.releaseTypeRegistryForUpdate(ttr, true);
        ttr = registry.lockTypeRegistryForUpdate();
        try {
            ttr.addType((AtlasBaseTypeDef)classifyDef7);
            Assert.fail((String)"Fail disjoined parent case");
        }
        catch (AtlasBaseException ae) {
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
        ttr = registry.lockTypeRegistryForUpdate();
        try {
            ttr.addType((AtlasBaseTypeDef)classifyDef8);
            Assert.fail((String)"Fail trying to add an entity type that is not in the parent");
        }
        catch (AtlasBaseException ae) {
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
        AtlasEntityType entityTypeA = registry.getEntityTypeByName(entityDefA.getName());
        AtlasEntityType entityTypeB = registry.getEntityTypeByName(entityDefB.getName());
        AtlasEntityType entityTypeC = registry.getEntityTypeByName(entityDefC.getName());
        AtlasEntityType entityTypeD = registry.getEntityTypeByName(entityDefD.getName());
        AtlasEntityType entityTypeE = registry.getEntityTypeByName(entityDefE.getName());
        AtlasEntityType entityTypeF = registry.getEntityTypeByName(entityDefF.getName());
        AtlasClassificationType classifyType1 = registry.getClassificationTypeByName(classifyDef1.getName());
        AtlasClassificationType classifyType2 = registry.getClassificationTypeByName(classifyDef2.getName());
        AtlasClassificationType classifyType3 = registry.getClassificationTypeByName(classifyDef3.getName());
        AtlasClassificationType classifyType4 = registry.getClassificationTypeByName(classifyDef4.getName());
        AtlasClassificationType classifyType5 = registry.getClassificationTypeByName(classifyDef5.getName());
        AtlasClassificationType classifyType6 = registry.getClassificationTypeByName(classifyDef6.getName());
        AtlasClassificationType classifyType9 = registry.getClassificationTypeByName(classifyDef9.getName());
        AtlasClassificationType classifyType10 = registry.getClassificationTypeByName(classifyDef10.getName());
        Assert.assertTrue((boolean)classifyType1.canApplyToEntityType(entityTypeA));
        Assert.assertFalse((boolean)classifyType1.canApplyToEntityType(entityTypeB));
        Assert.assertTrue((boolean)classifyType1.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType1.canApplyToEntityType(entityTypeD));
        Assert.assertTrue((boolean)classifyType2.canApplyToEntityType(entityTypeA));
        Assert.assertTrue((boolean)classifyType2.canApplyToEntityType(entityTypeB));
        Assert.assertTrue((boolean)classifyType2.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType2.canApplyToEntityType(entityTypeD));
        Assert.assertTrue((boolean)classifyType3.canApplyToEntityType(entityTypeA));
        Assert.assertFalse((boolean)classifyType3.canApplyToEntityType(entityTypeB));
        Assert.assertTrue((boolean)classifyType3.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType3.canApplyToEntityType(entityTypeD));
        Assert.assertFalse((boolean)classifyType4.canApplyToEntityType(entityTypeA));
        Assert.assertFalse((boolean)classifyType4.canApplyToEntityType(entityTypeB));
        Assert.assertFalse((boolean)classifyType4.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType4.canApplyToEntityType(entityTypeD));
        Assert.assertTrue((boolean)classifyType6.canApplyToEntityType(entityTypeF));
        Assert.assertTrue((boolean)classifyType9.canApplyToEntityType(entityTypeF));
        Assert.assertTrue((boolean)classifyType5.canApplyToEntityType(entityTypeA));
        Assert.assertTrue((boolean)classifyType5.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType10.canApplyToEntityType(entityTypeA));
        Assert.assertTrue((boolean)classifyType10.canApplyToEntityType(entityTypeC));
    }

    @Test
    public void testClassificationTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.classificationType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.classificationType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testClassificationTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.classificationType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            Object normalizedValue = this.classificationType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.classificationType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testClassificationTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.classificationType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.classificationType.validateValue(value, "testObj", messages));
            Assert.assertTrue((messages.size() > 0 ? 1 : 0) != 0, (String)("value=" + value));
            messages.clear();
        }
    }

    private static AtlasClassificationType getClassificationType(AtlasClassificationDef classificationDef) {
        try {
            return new AtlasClassificationType(classificationDef, ModelTestUtil.getTypesRegistry());
        }
        catch (AtlasBaseException excp) {
            return null;
        }
    }

    @Test
    public void testClassificationTimebounderTimeZone() {
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"IST"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"JST"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"UTC"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT+0"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT-0"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT+9:00"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT+10:30"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT-0400"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT+8"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT-13"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT+13:59"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"America/Los_Angeles"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"Japan"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"Europe/Berlin"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"Europe/Moscow"));
        Assert.assertTrue((boolean)AtlasClassificationType.isValidTimeZone((String)"Asia/Singapore"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"IND"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"USD"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"UTC+8"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"UTC+09:00"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"+09:00"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"-08:00"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"-1"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT+10:-30"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT+24:00"));
        Assert.assertFalse((boolean)AtlasClassificationType.isValidTimeZone((String)"GMT+13:60"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAttributeNameForSubtype() throws AtlasBaseException {
        AtlasTypeRegistry registry = ModelTestUtil.getTypesRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = registry.lockTypeRegistryForUpdate();
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent = new AtlasClassificationDef("classificationDefParent", "classificationDefParent desc", null, Collections.singletonList(attrDefForClassificationDefParent));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefChild = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefChild = new AtlasClassificationDef("classificationDefChild", "classificationDefChild desc", null, Collections.singletonList(attrDefForClassificationDefChild), Collections.singleton("classificationDefParent"));
        try {
            ttr.addType((AtlasBaseTypeDef)classificationDefChild);
            Assert.fail((String)"Parent attribute name and Child attribute name should not be the same");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getAtlasErrorCode().getErrorCode(), (String)AtlasErrorCode.ATTRIBUTE_NAME_ALREADY_EXISTS_IN_ANOTHER_PARENT_TYPE.getErrorCode());
        }
        finally {
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAttributeNameForSubtypeUpdate() throws AtlasBaseException {
        AtlasTypeRegistry registry = ModelTestUtil.getTypesRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = registry.lockTypeRegistryForUpdate();
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent = new AtlasClassificationDef("classificationDefParent", "classificationDefParent desc", null, Collections.singletonList(attrDefForClassificationDefParent));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefChild = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefChild = new AtlasClassificationDef("classificationDefChild", "classificationDefChild desc", null, Collections.singletonList(attrDefForClassificationDefChild));
        ttr.addType((AtlasBaseTypeDef)classificationDefChild);
        Set superTypes = classificationDefChild.getSuperTypes();
        Assert.assertEquals((int)superTypes.size(), (int)0);
        superTypes.add(classificationDefParent.getName());
        classificationDefChild.setSuperTypes(superTypes);
        try {
            ttr.updateType((AtlasBaseTypeDef)classificationDefChild);
            Assert.fail((String)"Parent attribute name and Child attribute name should not be the same");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getAtlasErrorCode().getErrorCode(), (String)AtlasErrorCode.ATTRIBUTE_NAME_ALREADY_EXISTS_IN_ANOTHER_PARENT_TYPE.getErrorCode());
        }
        finally {
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAttributeNameForSubtypeForMultipleParents() throws AtlasBaseException {
        AtlasTypeRegistry registry = ModelTestUtil.getTypesRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = registry.lockTypeRegistryForUpdate();
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent = new AtlasClassificationDef("classificationDefParent", "classificationDefParent desc", null, Collections.singletonList(attrDefForClassificationDefParent));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent2 = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent2 = new AtlasClassificationDef("classificationDefParent2", "classificationDefParent2 desc", null, Collections.singletonList(attrDefForClassificationDefParent2));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent2);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefChild = new AtlasStructDef.AtlasAttributeDef("attributeC", "string");
        HashSet<String> superTypes = new HashSet<String>();
        superTypes.add("classificationDefParent");
        superTypes.add("classificationDefParent2");
        AtlasClassificationDef classificationDefChild = new AtlasClassificationDef("classificationDefChild", "classificationDefChild desc", null, Collections.singletonList(attrDefForClassificationDefChild), superTypes);
        try {
            ttr.addType((AtlasBaseTypeDef)classificationDefChild);
            Assert.fail((String)"Child type cannot have two Parent types having same attribute names");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getAtlasErrorCode().getErrorCode(), (String)AtlasErrorCode.ATTRIBUTE_NAME_ALREADY_EXISTS_IN_ANOTHER_PARENT_TYPE.getErrorCode());
        }
        finally {
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAttributeNameForSubtypeForMultipleParents_Update() throws AtlasBaseException {
        AtlasTypeRegistry registry = ModelTestUtil.getTypesRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = registry.lockTypeRegistryForUpdate();
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent = new AtlasClassificationDef("classificationDefParent", "classificationDefParent desc", null, Collections.singletonList(attrDefForClassificationDefParent));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent2 = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent2 = new AtlasClassificationDef("classificationDefParent2", "classificationDefParent2 desc", null, Collections.singletonList(attrDefForClassificationDefParent2));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent2);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefChild = new AtlasStructDef.AtlasAttributeDef("attributeC", "string");
        AtlasClassificationDef classificationDefChild = new AtlasClassificationDef("classificationDefChild", "classificationDefChild desc", null, Collections.singletonList(attrDefForClassificationDefChild), Collections.singleton("classificationDefParent"));
        ttr.addType((AtlasBaseTypeDef)classificationDefChild);
        Set superTypes = classificationDefChild.getSuperTypes();
        Assert.assertEquals((int)superTypes.size(), (int)1);
        superTypes.add(classificationDefParent2.getName());
        classificationDefChild.setSuperTypes(superTypes);
        try {
            ttr.updateType((AtlasBaseTypeDef)classificationDefChild);
            Assert.fail((String)"Child type cannot have two Parent types having same attribute names");
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getAtlasErrorCode().getErrorCode(), (String)AtlasErrorCode.ATTRIBUTE_NAME_ALREADY_EXISTS_IN_ANOTHER_PARENT_TYPE.getErrorCode());
        }
        finally {
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipInvalidAttributeNameForSubtype() throws AtlasBaseException {
        AtlasTypeRegistry registry = ModelTestUtil.getTypesRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = registry.lockTypeRegistryForUpdate();
        AtlasStructType.skipCheckForParentChildAttributeName = true;
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent = new AtlasClassificationDef("classificationDefParent", "classificationDefParent desc", null, Collections.singletonList(attrDefForClassificationDefParent));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefChild = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefChild = new AtlasClassificationDef("classificationDefChild", "classificationDefChild desc", null, Collections.singletonList(attrDefForClassificationDefChild), Collections.singleton("classificationDefParent"));
        try {
            ttr.addType((AtlasBaseTypeDef)classificationDefChild);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getAtlasErrorCode().getErrorCode(), (String)AtlasErrorCode.ATTRIBUTE_NAME_ALREADY_EXISTS_IN_ANOTHER_PARENT_TYPE.getErrorCode());
            Assert.fail((String)"Parent attribute name and Child attribute name should be allowed to be the same when skip-check flag is true");
        }
        finally {
            AtlasStructType.skipCheckForParentChildAttributeName = false;
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipInvalidAttributeNameForSubtypeForMultipleParents() throws AtlasBaseException {
        AtlasTypeRegistry registry = ModelTestUtil.getTypesRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = registry.lockTypeRegistryForUpdate();
        AtlasStructType.skipCheckForParentChildAttributeName = true;
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent = new AtlasClassificationDef("classificationDefParent", "classificationDefParent desc", null, Collections.singletonList(attrDefForClassificationDefParent));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefParent2 = new AtlasStructDef.AtlasAttributeDef("attributeP", "string");
        AtlasClassificationDef classificationDefParent2 = new AtlasClassificationDef("classificationDefParent2", "classificationDefParent2 desc", null, Collections.singletonList(attrDefForClassificationDefParent2));
        ttr.addType((AtlasBaseTypeDef)classificationDefParent2);
        AtlasStructDef.AtlasAttributeDef attrDefForClassificationDefChild = new AtlasStructDef.AtlasAttributeDef("attributeC", "string");
        HashSet<String> superTypes = new HashSet<String>();
        superTypes.add("classificationDefParent");
        superTypes.add("classificationDefParent2");
        AtlasClassificationDef classificationDefChild = new AtlasClassificationDef("classificationDefChild", "classificationDefChild desc", null, Collections.singletonList(attrDefForClassificationDefChild), superTypes);
        try {
            ttr.addType((AtlasBaseTypeDef)classificationDefChild);
        }
        catch (AtlasBaseException e) {
            Assert.assertEquals((String)e.getAtlasErrorCode().getErrorCode(), (String)AtlasErrorCode.ATTRIBUTE_NAME_ALREADY_EXISTS_IN_ANOTHER_PARENT_TYPE.getErrorCode());
            Assert.fail((String)"Parent attribute name and Child attribute name should be allowed to be same when skip-check flag is true");
        }
        finally {
            AtlasStructType.skipCheckForParentChildAttributeName = false;
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
    }
}

