/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.util.Arrays;
import java.util.Collections;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasBusinessMetadataDef {
    @Test
    public void businessMetadataDefSerDes() {
        AtlasBusinessMetadataDef businessMetadataDef = new AtlasBusinessMetadataDef("test_businessMetadata", "test_description", null);
        String jsonString = AtlasType.toJson((Object)businessMetadataDef);
        AtlasBusinessMetadataDef businessMetadataDef1 = (AtlasBusinessMetadataDef)AtlasType.fromJson((String)jsonString, AtlasBusinessMetadataDef.class);
        Assert.assertEquals((Object)businessMetadataDef, (Object)businessMetadataDef1, (String)"Incorrect serialization/deserialization of AtlasBusinessMetadataDef");
    }

    @Test
    public void businessMetadataDefEquality() {
        AtlasBusinessMetadataDef businessMetadataDef1 = new AtlasBusinessMetadataDef("test_businessMetadata", "test_description", null);
        AtlasBusinessMetadataDef businessMetadataDef2 = new AtlasBusinessMetadataDef("test_businessMetadata", "test_description", null);
        Assert.assertEquals((Object)businessMetadataDef1, (Object)businessMetadataDef2, (String)"businessMetadatas should be equal because the name of thebusinessMetadata is same");
    }

    @Test
    public void businessMetadataDefUnequality() {
        AtlasBusinessMetadataDef businessMetadataDef1 = new AtlasBusinessMetadataDef("test_businessMetadata", "test_description", null);
        AtlasBusinessMetadataDef businessMetadataDef2 = new AtlasBusinessMetadataDef("test_businessMetadata1", "test_description", null);
        Assert.assertNotEquals((Object)businessMetadataDef1, (Object)businessMetadataDef2, (String)"businessMetadatas should not be equal since they have adifferent name");
    }

    @Test
    public void businessMetadataDefWithAttributes() {
        AtlasBusinessMetadataDef businessMetadataDef1 = new AtlasBusinessMetadataDef("test_businessMetadata", "test_description", null);
        AtlasStructDef.AtlasAttributeDef nsAttr1 = new AtlasStructDef.AtlasAttributeDef("attr1", "int");
        AtlasStructDef.AtlasAttributeDef nsAttr2 = new AtlasStructDef.AtlasAttributeDef("attr2", "int");
        nsAttr1.setOption("applicableEntityTypes", AtlasType.toJson(Collections.singleton("hive_table")));
        nsAttr2.setOption("applicableEntityTypes", AtlasType.toJson(Collections.singleton("hive_table")));
        businessMetadataDef1.setAttributeDefs(Arrays.asList(nsAttr1, nsAttr2));
        Assert.assertEquals((int)businessMetadataDef1.getAttributeDefs().size(), (int)2);
    }

    @Test
    public void businessMetadataDefWithAttributesHavingCardinality() {
        AtlasBusinessMetadataDef businessMetadataDef1 = new AtlasBusinessMetadataDef("test_businessMetadata", "test_description", null);
        AtlasStructDef.AtlasAttributeDef nsAttr1 = new AtlasStructDef.AtlasAttributeDef("attr1", "int");
        AtlasStructDef.AtlasAttributeDef nsAttr2 = new AtlasStructDef.AtlasAttributeDef("attr2", "int");
        nsAttr1.setOption("applicableEntityTypes", AtlasType.toJson(Collections.singleton("hive_table")));
        nsAttr2.setOption("applicableEntityTypes", AtlasType.toJson(Collections.singleton("hive_table")));
        nsAttr2.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SET);
        businessMetadataDef1.setAttributeDefs(Arrays.asList(nsAttr1, nsAttr2));
        Assert.assertEquals((int)businessMetadataDef1.getAttributeDefs().size(), (int)2);
    }
}

