/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.solr;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.solr.SolrIndex;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class Solr6Index
extends SolrIndex {
    private static final Logger LOG = LoggerFactory.getLogger(Solr6Index.class);
    public static final ConfigOption<Boolean> CREATE_SOLR_CLIENT_PER_REQUEST = new ConfigOption(SOLR_NS, "create-client-per-request", "when false, allows the sharing of solr client across other components.", ConfigOption.Type.LOCAL, (Object)false);
    private static boolean createSolrClientPerRequest = false;
    private static Solr6Index INSTANCE = null;
    private final Configuration config;
    private final Mode solrMode;
    private final SolrClient solrClient;

    public Solr6Index(Configuration config) throws BackendException {
        super(config);
        Mode solrMode = Mode.CLOUD;
        try {
            Field fld = SolrIndex.class.getDeclaredField("mode");
            fld.setAccessible(true);
            Object val = fld.get((Object)this);
            if (val != null) {
                solrMode = Mode.parse(val.toString());
            } else {
                LOG.warn("SolrMode is not set. Assuming {}", (Object)solrMode);
            }
        }
        catch (Exception excp) {
            LOG.warn("Failed to get SolrMode. Assuming {}", (Object)solrMode, (Object)excp);
        }
        SolrClient solrClient = null;
        try {
            Field fld = SolrIndex.class.getDeclaredField("solrClient");
            fld.setAccessible(true);
            solrClient = (SolrClient)fld.get((Object)this);
        }
        catch (Exception excp) {
            LOG.warn("Failed to get SolrClient", (Throwable)excp);
        }
        this.config = config;
        this.solrMode = solrMode;
        this.solrClient = solrClient;
        createSolrClientPerRequest = (Boolean)config.get(CREATE_SOLR_CLIENT_PER_REQUEST, new String[0]);
        INSTANCE = this;
    }

    public static SolrClient getSolrClient() {
        SolrClient ret = null;
        Solr6Index index = INSTANCE;
        if (index != null) {
            SolrClient solrClient = ret = createSolrClientPerRequest ? index.createSolrClient() : index.solrClient;
        }
        if (ret == null) {
            LOG.warn("getSolrClient() returning null");
        }
        return ret;
    }

    public static void releaseSolrClient(SolrClient client) {
        if (createSolrClientPerRequest) {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException excp) {
                    LOG.warn("Failed to close SolrClient.", (Throwable)excp);
                }
            }
        } else {
            LOG.debug("Ignoring the closing of solr client as it is owned by Solr6Index.");
        }
    }

    public static Mode getSolrMode() {
        Solr6Index index = INSTANCE;
        return index != null ? index.solrMode : Mode.CLOUD;
    }

    private SolrClient createSolrClient() {
        CloudSolrClient ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HttpClientBuilder = {}", (Object)HttpClientUtil.getHttpClientBuilder(), (Object)new Exception());
        }
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        switch (this.solrMode) {
            case CLOUD: {
                String[] zookeeperUrl = (String[])this.config.get(ZOOKEEPER_URL, new String[0]);
                Optional<Object> chroot = Optional.empty();
                for (int i = zookeeperUrl.length - 1; i >= 0; --i) {
                    int chrootIndex = zookeeperUrl[i].indexOf("/");
                    if (chrootIndex == -1) continue;
                    String hostAndPort = zookeeperUrl[i].substring(0, chrootIndex);
                    if (!chroot.isPresent()) {
                        chroot = Optional.of(zookeeperUrl[i].substring(chrootIndex));
                    }
                    zookeeperUrl[i] = hostAndPort;
                }
                CloudSolrClient.Builder builder = new CloudSolrClient.Builder(Arrays.asList(zookeeperUrl), chroot).withLBHttpSolrClientBuilder(new LBHttpSolrClient.Builder().withHttpSolrClientBuilder(new HttpSolrClient.Builder().withInvariantParams(clientParams)).withBaseSolrUrls((String[])this.config.get(HTTP_URLS, new String[0]))).sendUpdatesOnlyToShardLeaders();
                CloudSolrClient cloudServer = builder.build();
                cloudServer.connect();
                ret = cloudServer;
                break;
            }
            case HTTP: {
                clientParams.add("allowCompression", new String[]{((Boolean)this.config.get(HTTP_ALLOW_COMPRESSION, new String[0])).toString()});
                clientParams.add("connTimeout", new String[]{((Integer)this.config.get(HTTP_CONNECTION_TIMEOUT, new String[0])).toString()});
                clientParams.add("maxConnectionsPerHost", new String[]{((Integer)this.config.get(HTTP_MAX_CONNECTIONS_PER_HOST, new String[0])).toString()});
                clientParams.add("maxConnections", new String[]{((Integer)this.config.get(HTTP_GLOBAL_MAX_CONNECTIONS, new String[0])).toString()});
                CloseableHttpClient client = HttpClientUtil.createClient((SolrParams)clientParams);
                ret = ((LBHttpSolrClient.Builder)new LBHttpSolrClient.Builder().withHttpClient((HttpClient)client)).withBaseSolrUrls((String[])this.config.get(HTTP_URLS, new String[0])).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Solr operation mode: " + (Object)((Object)this.solrMode));
            }
        }
        return ret;
    }

    public static enum Mode {
        HTTP,
        CLOUD;


        public static Mode parse(String mode) {
            for (Mode m : Mode.values()) {
                if (!m.toString().equalsIgnoreCase(mode)) continue;
                return m;
            }
            throw new IllegalArgumentException("Unrecognized mode: " + mode);
        }
    }
}

