/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.lang.reflect.Field;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class ElasticSearch7Index
extends ElasticSearchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearch7Index.class);
    private static ElasticSearch7Index INSTANCE;
    private final ElasticSearchClient client;

    public ElasticSearch7Index(Configuration config) throws BackendException {
        super(config);
        ElasticSearchClient client = null;
        try {
            Field fld = ElasticSearchIndex.class.getDeclaredField("client");
            fld.setAccessible(true);
            client = (ElasticSearchClient)fld.get((Object)this);
        }
        catch (Exception excp) {
            LOG.warn("Failed to get SolrClient", (Throwable)excp);
        }
        this.client = client;
        INSTANCE = this;
    }

    public static ElasticSearchClient getElasticSearchClient() {
        ElasticSearch7Index index = INSTANCE;
        return index != null ? index.client : null;
    }
}

